/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CharStringEncoder
extends Encoder<String> {
    private static final Logger log = LoggerFactory.getLogger(CharStringEncoder.class);

    CharStringEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.CHAR;
    }

    @Override
    public Class<String> inputType() {
        return String.class;
    }

    @Override
    public void encode(ByteBuffer buffer, String input, String name, int size, int scale) {
        log.trace("input = {}", (Object)input);
        ByteBuffer valueBuffer = Charsets.UTF_8.encode(input);
        Preconditions.checkState((size >= valueBuffer.remaining() ? 1 : 0) != 0, (String)"Encoded value for '%s' is %s byte(s) but the column is only %s byte(s).", (Object[])new Object[]{name, valueBuffer.remaining(), size});
        buffer.put(valueBuffer);
        int padding = size - valueBuffer.capacity();
        log.trace("writeChar() - padding value by {} byte(s).");
        for (int i = 0; i < padding; ++i) {
            buffer.put((byte)0);
        }
    }
}

