/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UTCDateEncoder<T>
extends Encoder<T> {
    private static final Logger log = LoggerFactory.getLogger(UTCDateEncoder.class);

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.DATE;
    }

    protected abstract long utcTime(T var1);

    @Override
    public void encode(ByteBuffer buffer, T input, String name, int size, int scale) {
        log.trace("input = {}", input);
        long utcTime = this.utcTime(input);
        long storage = (utcTime - 946684800000L) / 86400000L;
        buffer.putLong(storage);
    }
}

