/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.vertica.binary;

import com.github.jcustenborder.vertica.VerticaColumnType;
import com.github.jcustenborder.vertica.binary.Encoder;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VarCharStringEncoder
extends Encoder<String> {
    private static final Logger log = LoggerFactory.getLogger(VarCharStringEncoder.class);

    VarCharStringEncoder() {
    }

    @Override
    public VerticaColumnType columnType() {
        return VerticaColumnType.VARCHAR;
    }

    @Override
    public Class<String> inputType() {
        return String.class;
    }

    @Override
    public void encode(ByteBuffer buffer, String input, String name, int size, int scale) {
        log.trace("input = {}", (Object)input);
        ByteBuffer valueBuffer = Charsets.UTF_8.encode(input);
        log.trace("writing {} byte(s).", (Object)valueBuffer.remaining());
        buffer.putInt(valueBuffer.remaining());
        buffer.put(valueBuffer);
    }
}

