/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.metadata.TableMetaDataContext;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.Assert;

public abstract class AbstractJdbcInsert {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final JdbcTemplate jdbcTemplate;
    private final TableMetaDataContext tableMetaDataContext = new TableMetaDataContext();
    private final List<String> declaredColumns = new ArrayList<String>();
    private boolean compiled = false;
    private String insertString;
    private int[] insertTypes;
    private String[] generatedKeyNames = new String[0];

    protected AbstractJdbcInsert(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected AbstractJdbcInsert(JdbcTemplate jdbcTemplate) {
        Assert.notNull(jdbcTemplate, "JdbcTemplate must not be null");
        this.jdbcTemplate = jdbcTemplate;
        this.setNativeJdbcExtractor(jdbcTemplate.getNativeJdbcExtractor());
    }

    public void setTableName(String tableName) {
        this.checkIfConfigurationModificationIsAllowed();
        this.tableMetaDataContext.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableMetaDataContext.getTableName();
    }

    public void setSchemaName(String schemaName) {
        this.checkIfConfigurationModificationIsAllowed();
        this.tableMetaDataContext.setSchemaName(schemaName);
    }

    public String getSchemaName() {
        return this.tableMetaDataContext.getSchemaName();
    }

    public void setCatalogName(String catalogName) {
        this.checkIfConfigurationModificationIsAllowed();
        this.tableMetaDataContext.setCatalogName(catalogName);
    }

    public String getCatalogName() {
        return this.tableMetaDataContext.getCatalogName();
    }

    public void setColumnNames(List<String> columnNames) {
        this.checkIfConfigurationModificationIsAllowed();
        this.declaredColumns.clear();
        this.declaredColumns.addAll(columnNames);
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.declaredColumns);
    }

    public String[] getGeneratedKeyNames() {
        return this.generatedKeyNames;
    }

    public void setGeneratedKeyNames(String[] generatedKeyNames) {
        this.checkIfConfigurationModificationIsAllowed();
        this.generatedKeyNames = generatedKeyNames;
    }

    public void setGeneratedKeyName(String generatedKeyName) {
        this.checkIfConfigurationModificationIsAllowed();
        this.generatedKeyNames = new String[]{generatedKeyName};
    }

    public void setAccessTableColumnMetaData(boolean accessTableColumnMetaData) {
        this.tableMetaDataContext.setAccessTableColumnMetaData(accessTableColumnMetaData);
    }

    public void setOverrideIncludeSynonymsDefault(boolean override) {
        this.tableMetaDataContext.setOverrideIncludeSynonymsDefault(override);
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.tableMetaDataContext.setNativeJdbcExtractor(nativeJdbcExtractor);
    }

    public String getInsertString() {
        return this.insertString;
    }

    public int[] getInsertTypes() {
        return this.insertTypes;
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final synchronized void compile() throws InvalidDataAccessApiUsageException {
        if (!this.isCompiled()) {
            if (this.getTableName() == null) {
                throw new InvalidDataAccessApiUsageException("Table name is required");
            }
            try {
                this.jdbcTemplate.afterPropertiesSet();
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage());
            }
            this.compileInternal();
            this.compiled = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("JdbcInsert for table [" + this.getTableName() + "] compiled"));
            }
        }
    }

    protected void compileInternal() {
        this.tableMetaDataContext.processMetaData(this.getJdbcTemplate().getDataSource(), this.getColumnNames(), this.getGeneratedKeyNames());
        this.insertString = this.tableMetaDataContext.createInsertString(this.getGeneratedKeyNames());
        this.insertTypes = this.tableMetaDataContext.createInsertTypes();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Compiled JdbcInsert. Insert string is [" + this.getInsertString() + "]"));
        }
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    protected void checkCompiled() {
        if (!this.isCompiled()) {
            this.logger.debug((Object)"JdbcInsert not compiled before execution - invoking compile");
            this.compile();
        }
    }

    protected void checkIfConfigurationModificationIsAllowed() {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("Configuration can't be altered once the class has been compiled or used.");
        }
    }

    protected int doExecute(Map<String, Object> args) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(args);
        return this.executeInsertInternal(values);
    }

    protected int doExecute(SqlParameterSource parameterSource) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(parameterSource);
        return this.executeInsertInternal(values);
    }

    private int executeInsertInternal(List<Object> values) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The following parameters are used for insert " + this.getInsertString() + " with: " + values));
        }
        int updateCount = this.jdbcTemplate.update(this.getInsertString(), values.toArray(), this.getInsertTypes());
        return updateCount;
    }

    protected Number doExecuteAndReturnKey(Map<String, Object> args) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(args);
        return this.executeInsertAndReturnKeyInternal(values);
    }

    protected Number doExecuteAndReturnKey(SqlParameterSource parameterSource) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(parameterSource);
        return this.executeInsertAndReturnKeyInternal(values);
    }

    protected KeyHolder doExecuteAndReturnKeyHolder(Map<String, Object> args) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(args);
        return this.executeInsertAndReturnKeyHolderInternal(values);
    }

    protected KeyHolder doExecuteAndReturnKeyHolder(SqlParameterSource parameterSource) {
        this.checkCompiled();
        List<Object> values = this.matchInParameterValuesWithInsertColumns(parameterSource);
        return this.executeInsertAndReturnKeyHolderInternal(values);
    }

    private Number executeInsertAndReturnKeyInternal(List<Object> values) {
        KeyHolder kh = this.executeInsertAndReturnKeyHolderInternal(values);
        if (kh != null && kh.getKey() != null) {
            return kh.getKey();
        }
        throw new DataIntegrityViolationException("Unable to retrieve the generated key for the insert: " + this.getInsertString());
    }

    private KeyHolder executeInsertAndReturnKeyHolderInternal(final List<Object> values) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The following parameters are used for call " + this.getInsertString() + " with: " + values));
        }
        final GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        if (!this.tableMetaDataContext.isGetGeneratedKeysSupported()) {
            if (!this.tableMetaDataContext.isGetGeneratedKeysSimulated()) {
                throw new InvalidDataAccessResourceUsageException("The getGeneratedKeys feature is not supported by this database");
            }
            if (this.getGeneratedKeyNames().length < 1) {
                throw new InvalidDataAccessApiUsageException("Generated Key Name(s) not specificed. Using the generated keys features requires specifying the name(s) of the generated column(s)");
            }
            if (this.getGeneratedKeyNames().length > 1) {
                throw new InvalidDataAccessApiUsageException("Current database only supports retreiving the key for a single column. There are " + this.getGeneratedKeyNames().length + " columns specified: " + Arrays.asList(this.getGeneratedKeyNames()));
            }
            final String keyQuery = this.tableMetaDataContext.getSimulationQueryForGetGeneratedKey(this.tableMetaDataContext.getTableName(), this.getGeneratedKeyNames()[0]);
            Assert.notNull(keyQuery, "Query for simulating get generated keys can't be null");
            if (keyQuery.toUpperCase().startsWith("RETURNING")) {
                Long key = this.jdbcTemplate.queryForLong(this.getInsertString() + " " + keyQuery, values.toArray(new Object[values.size()]));
                HashMap<String, Long> keys = new HashMap<String, Long>(1);
                keys.put(this.getGeneratedKeyNames()[0], key);
                keyHolder.getKeyList().add(keys);
            } else {
                this.jdbcTemplate.execute(new ConnectionCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                        PreparedStatement ps = null;
                        try {
                            ps = con.prepareStatement(AbstractJdbcInsert.this.getInsertString());
                            AbstractJdbcInsert.this.setParameterValues(ps, values, AbstractJdbcInsert.this.getInsertTypes());
                            ps.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeStatement(ps);
                            throw throwable;
                        }
                        JdbcUtils.closeStatement(ps);
                        Statement keyStmt = null;
                        ResultSet rs = null;
                        HashMap<String, Long> keys = new HashMap<String, Long>(1);
                        try {
                            keyStmt = con.createStatement();
                            rs = keyStmt.executeQuery(keyQuery);
                            if (rs.next()) {
                                long key = rs.getLong(1);
                                keys.put(AbstractJdbcInsert.this.getGeneratedKeyNames()[0], key);
                                keyHolder.getKeyList().add(keys);
                            }
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeResultSet(rs);
                            JdbcUtils.closeStatement(keyStmt);
                            throw throwable;
                        }
                        JdbcUtils.closeResultSet(rs);
                        JdbcUtils.closeStatement(keyStmt);
                        return null;
                    }
                });
            }
            return keyHolder;
        }
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            @Override
            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = AbstractJdbcInsert.this.prepareStatementForGeneratedKeys(con);
                AbstractJdbcInsert.this.setParameterValues(ps, values, AbstractJdbcInsert.this.getInsertTypes());
                return ps;
            }
        }, keyHolder);
        return keyHolder;
    }

    private PreparedStatement prepareStatementForGeneratedKeys(Connection con) throws SQLException {
        PreparedStatement ps;
        if (this.getGeneratedKeyNames().length < 1) {
            throw new InvalidDataAccessApiUsageException("Generated Key Name(s) not specificed. Using the generated keys features requires specifying the name(s) of the generated column(s)");
        }
        if (this.tableMetaDataContext.isGeneratedKeysColumnNameArraySupported()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using generated keys support with array of column names.");
            }
            ps = con.prepareStatement(this.getInsertString(), this.getGeneratedKeyNames());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using generated keys support with Statement.RETURN_GENERATED_KEYS.");
            }
            ps = con.prepareStatement(this.getInsertString(), 1);
        }
        return ps;
    }

    protected int[] doExecuteBatch(Map<String, Object>[] batch) {
        this.checkCompiled();
        ArrayList[] batchValues = new ArrayList[batch.length];
        int i = 0;
        for (Map<String, Object> args : batch) {
            List<Object> values = this.matchInParameterValuesWithInsertColumns(args);
            batchValues[i++] = values;
        }
        return this.executeBatchInternal(batchValues);
    }

    protected int[] doExecuteBatch(SqlParameterSource[] batch) {
        this.checkCompiled();
        ArrayList[] batchValues = new ArrayList[batch.length];
        int i = 0;
        for (SqlParameterSource parameterSource : batch) {
            List<Object> values = this.matchInParameterValuesWithInsertColumns(parameterSource);
            batchValues[i++] = values;
        }
        return this.executeBatchInternal(batchValues);
    }

    private int[] executeBatchInternal(final List<Object>[] batchValues) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing statement " + this.getInsertString() + " with batch of size: " + batchValues.length));
        }
        int[] updateCounts = this.jdbcTemplate.batchUpdate(this.getInsertString(), new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                List values = batchValues[i];
                AbstractJdbcInsert.this.setParameterValues(ps, values, AbstractJdbcInsert.this.getInsertTypes());
            }

            @Override
            public int getBatchSize() {
                return batchValues.length;
            }
        });
        return updateCounts;
    }

    private void setParameterValues(PreparedStatement preparedStatement, List<Object> values, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        for (Object value : values) {
            if (columnTypes == null || ++colIndex > columnTypes.length) {
                StatementCreatorUtils.setParameterValue(preparedStatement, colIndex, Integer.MIN_VALUE, value);
                continue;
            }
            StatementCreatorUtils.setParameterValue(preparedStatement, colIndex, columnTypes[colIndex - 1], value);
        }
    }

    protected List<Object> matchInParameterValuesWithInsertColumns(SqlParameterSource parameterSource) {
        return this.tableMetaDataContext.matchInParameterValuesWithInsertColumns(parameterSource);
    }

    protected List<Object> matchInParameterValuesWithInsertColumns(Map<String, Object> args) {
        return this.tableMetaDataContext.matchInParameterValuesWithInsertColumns(args);
    }
}

