/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.JdbcUtils;

public class DatabaseStartupValidator
implements InitializingBean {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private String validationQuery;
    private int interval = 1;
    private int timeout = 60;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (this.validationQuery == null) {
            throw new IllegalArgumentException("validationQuery is required");
        }
        try {
            boolean validated = false;
            long beginTime = System.currentTimeMillis();
            long deadLine = beginTime + (long)(this.timeout * 1000);
            SQLException latestEx = null;
            while (!validated && System.currentTimeMillis() < deadLine) {
                Connection con = null;
                Statement stmt = null;
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.createStatement();
                    stmt.execute(this.validationQuery);
                    validated = true;
                }
                catch (SQLException ex) {
                    block11: {
                        try {
                            latestEx = ex;
                            this.logger.debug((Object)("Validation query [" + this.validationQuery + "] threw exception"), (Throwable)ex);
                            float rest = (float)(deadLine - System.currentTimeMillis()) / 1000.0f;
                            if (!(rest > (float)this.interval)) break block11;
                            this.logger.warn((Object)("Database has not started up yet - retrying in " + this.interval + " seconds (timeout in " + rest + " seconds)"));
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeStatement(stmt);
                            JdbcUtils.closeConnection(con);
                            throw throwable;
                        }
                    }
                    JdbcUtils.closeStatement(stmt);
                    JdbcUtils.closeConnection(con);
                }
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(con);
                if (validated) continue;
                Thread.sleep(this.interval * 1000);
            }
            if (!validated) {
                throw new CannotGetJdbcConnectionException("Database has not started up within " + this.timeout + " seconds", latestEx);
            }
            float duration = (System.currentTimeMillis() - beginTime) / 1000L;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Database startup detected after " + duration + " seconds"));
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

