/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

class SQLErrorCodesParser {
    SQLErrorCodesParser() {
    }

    static Map<String, SQLErrorCodes> fromStream(InputStream is) {
        Beans bs = SQLErrorCodesParser.readBeans(is);
        HashMap<String, SQLErrorCodes> result = new HashMap<String, SQLErrorCodes>();
        if (bs.beans == null) {
            return result;
        }
        for (Bean b : bs.beans) {
            result.put(b.id, b.asErrorCodes());
        }
        return result;
    }

    static Beans readBeans(InputStream is) {
        try {
            return SQLErrorCodesParser.unmarshall(Beans.class, is, true);
        }
        catch (DataBindingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static <T> T unmarshall(Class<T> type, InputStream in, final boolean ignoreErrors) throws SAXException, ParserConfigurationException, JAXBException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                if (ignoreErrors) {
                    return false;
                }
                throw new DataBindingException(validationEvent.getMessage(), validationEvent.getLinkedException());
            }
        });
        NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, new InputSource(in));
        return (T)unmarshaller.unmarshal((Source)source);
    }

    static class Property {
        @XmlAttribute(name="name")
        String name;
        @XmlElement
        String value;
        @XmlElementWrapper(name="list")
        @XmlElements(value={@XmlElement(name="value", type=String.class), @XmlElement(name="bean", type=Bean.class)})
        List<Object> list;

        Property() {
        }

        void apply(BeanInfo bi, Object o) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!this.name.equals(pd.getName())) continue;
                Class<?> type = pd.getPropertyType();
                Object propValue = this.getValue(type);
                pd.getWriteMethod().invoke(o, propValue);
            }
        }

        private Object getValue(Class<?> type) throws ClassNotFoundException {
            if (String.class.equals(type)) {
                return this.value;
            }
            if (type.isArray()) {
                if (String.class.equals(type.getComponentType())) {
                    return this.toArray();
                }
                return this.toArray(type.getComponentType());
            }
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                return Boolean.valueOf(this.value);
            }
            if (Class.class.equals(type)) {
                return Class.forName(this.value);
            }
            throw new IllegalArgumentException("Property type " + type + " not supported");
        }

        private <T> Object toArray(Class<T> componentType) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object def : this.list) {
                if (def instanceof Bean) {
                    result.add(((Bean)def).instantiate());
                    continue;
                }
                result.add(def);
            }
            Object[] resultArray = (Object[])Array.newInstance(componentType, result.size());
            return result.toArray(resultArray);
        }

        String[] toArray() {
            if (this.list != null) {
                return this.list.toArray(new String[0]);
            }
            return this.value.split(",");
        }
    }

    public static class Bean {
        @XmlElement(name="property")
        List<Property> properties;
        @XmlAttribute(name="id")
        String id;
        @XmlAttribute(name="class")
        String className;

        SQLErrorCodes asErrorCodes() {
            return (SQLErrorCodes)this.instantiate();
        }

        Object instantiate() {
            try {
                Class<?> instanceClass = Class.forName(this.className);
                Object o = instanceClass.newInstance();
                BeanInfo bi = Introspector.getBeanInfo(instanceClass);
                for (Property property : this.properties) {
                    property.apply(bi, o);
                }
                return o;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @XmlRootElement
    public static class Beans {
        @XmlElement(name="bean")
        List<Bean> beans;
    }

    static class NamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public NamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

