/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBDriver;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boon.json.JsonFactory;

class CBArray
implements Array {
    private String baseType;
    private Object[] array;
    private String jsonArray;
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    CBArray(List arrayList) {
        if (arrayList == null) {
            this.array = null;
            this.jsonArray = null;
        } else {
            this.array = arrayList.toArray();
            this.jsonArray = JsonFactory.toJson(this.array);
        }
    }

    CBArray(String typeName, Object[] array) {
        this.array = array;
        this.baseType = typeName;
        this.jsonArray = JsonFactory.toJson(array);
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseType;
    }

    @Override
    public int getBaseType() throws SQLException {
        String jsonType = typeMap.get(this.baseType);
        if (jsonType == null) {
            return 2000;
        }
        if (jsonType.compareTo("number") == 0) {
            return 2;
        }
        if (jsonType.compareTo("Boolean") == 0) {
            return 16;
        }
        if (jsonType.compareTo("String") == 0) {
            return 12;
        }
        return 2000;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getArray");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        Object[] newArray = new Object[count];
        int i = (int)index;
        for (int j = 0; j < count; ++j) {
            newArray[j] = this.array[i++];
        }
        return newArray;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getArray");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getResultSet");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getResultSet");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getResultSet");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw CBDriver.notImplemented(CBArray.class, "getResultSet");
    }

    @Override
    public void free() throws SQLException {
        this.baseType = null;
        this.array = null;
        this.jsonArray = null;
    }

    String getJsonArray() {
        return this.jsonArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CBArray cbArray = (CBArray)o;
        return Arrays.equals(this.array, cbArray.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    static {
        typeMap.put("byte", "number");
        typeMap.put("Byte", "number");
        typeMap.put("short", "number");
        typeMap.put("Short", "number");
        typeMap.put("int", "number");
        typeMap.put("Integer", "number");
        typeMap.put("long", "number");
        typeMap.put("Long", "number");
        typeMap.put("BigDecimal", "number");
        typeMap.put("Boolean", "Boolean");
        typeMap.put("String", "string");
    }
}

