/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBArray;
import com.couchbase.CBDatabaseMetaData;
import com.couchbase.CBDriver;
import com.couchbase.CBPreparedStatement;
import com.couchbase.CBStatement;
import com.couchbase.jdbc.Protocol;
import com.couchbase.jdbc.core.ProtocolImpl;
import com.couchbase.jdbc.core.SqlJsonImplementation;
import com.couchbase.json.SQLJSON;
import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(CBConnection.class);
    private AtomicBoolean connected = new AtomicBoolean(false);
    Protocol protocol;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    boolean readOnly = false;

    public CBConnection(String url, Properties props) throws SQLException {
        try {
            String connectionURL;
            if (props.containsKey("EnableSSL") && props.getProperty("EnableSSL").equals("true")) {
                logger.trace("Enabling SSL connection");
                connectionURL = HTTPS + url.substring(14);
            } else {
                logger.trace("Normal http connection");
                connectionURL = HTTP + url.substring(14);
            }
            List<NameValuePair> parameters = URLEncodedUtils.parse(new URI(connectionURL), "UTF-8");
            for (NameValuePair param : parameters) {
                props.put(param.getName(), param.getValue());
            }
            this.protocol = new ProtocolImpl(connectionURL, props);
            this.protocol.connect();
            this.connected.set(true);
        }
        catch (Exception ex) {
            logger.error("Error opening connection for {} exception {}", (Object)url, (Object)ex.getMessage());
            throw new SQLException("Error opening connection", ex.getCause());
        }
    }

    public String getURL() throws SQLException {
        this.checkClosed();
        return this.protocol.getURL();
    }

    public String getUserName() throws SQLException {
        this.checkClosed();
        return this.protocol.getUserName();
    }

    public String getPassword() throws SQLException {
        this.checkClosed();
        return this.protocol.getPassword();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new CBStatement(this, this.protocol);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new CBPreparedStatement(this, this.protocol, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepreCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.protocol.close();
                this.connected.set(false);
                CBDriver.registered.cleanup(this);
            }
            catch (Exception ex) {
                logger.debug("Error closing connection", ex);
                throw new SQLException(ex.getCause());
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.connected.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new CBDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.protocol.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.protocol.getReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.protocol.setSchema(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.protocol.getSchema();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SQLException("transaction level " + level + " not allowed ");
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.protocol.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.protocol.clearWarning();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return this.createStatement();
        }
        throw CBDriver.notImplemented(CBConnection.class, "createStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return this.prepareStatement(sql);
        }
        throw CBDriver.notImplemented(CBConnection.class, "prepareStatement");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "releaseSavepoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepareStatement");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepareCall");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return new CBPreparedStatement(this, this.protocol, sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createSQLXML");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        return this.protocol.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return new CBArray(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.protocol.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.protocol.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor is null");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        throw CBDriver.notImplemented(CBConnection.class, "getNetworkTimeout");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public SQLJSON createSQLJSON() {
        return new SqlJsonImplementation();
    }

    protected void pollCluster() throws SQLException {
        this.protocol.pollCluster();
    }
}

