/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBConnection;
import com.couchbase.CBResultSet;
import com.couchbase.jdbc.core.CouchMetrics;
import com.couchbase.jdbc.core.CouchResponse;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class CBDatabaseMetaData
implements DatabaseMetaData {
    final CBConnection connection;

    public CBDatabaseMetaData(CBConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Couchbase";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        ResultSet rs = this.connection.createStatement().executeQuery("select version()");
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "n1ql_jdbc";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.1";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return null;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "add,div,mod,mult,neg,sub,abs,acos,asin,atan,atan2,ceil,cos,deg,degrees,e,exp,ln,log,floor,inf,nan,neginf,pi,posinf,power,rad,radians,random,round,sign,sin,sqrt,tan,trunc";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "contains,initcap,length,lower,ltrim,position,pos,regex_contains,regex_like,regex_position,regex_pos,regex_replace,repeat,replace,rtrim,split,substr,title,trim,upper";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "clock_millis,clock_str,date_add_millis,date_add_str,date_diff_millis,date_diff_str,date_part_millis,date_part_str,date_trunc_millis,date_trunc_str,millis,millis_to_str,millis_to_utc,millis_to_zone_name,now_millis,now_str,str_to_millis,str_to_utc,str_to_zone_name";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "NAMESPACE";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "namespace";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ":";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 1;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return 1 == level;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sql = "select null as TABLE_CAT, namespace_id as TABLE_SCHEM, name as TABLE_NAME, 'TABLE' as TABLE_TYPE, null as REMARKS, null as TYPE_CAT, null as TYPE_SCHEM,null as TYPE_NAME, null as SELF_REFERENCING_COL_NAME, null as REF_GENERATION from system:keyspaces";
        if (schemaPattern != null || tableNamePattern != null) {
            sql = sql + " where ";
            if (schemaPattern != null) {
                sql = sql + "namespace_id like '" + schemaPattern + "'";
            }
            if (schemaPattern != null && tableNamePattern != null) {
                sql = sql + " and ";
            }
            if (tableNamePattern != null) {
                sql = sql + "name LIKE '" + tableNamePattern + "'";
            }
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String sql = "select name as TABLE_CAT from system:namespaces";
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList catalogs = new ArrayList(2);
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("TABLE_TYPE", "SYSTEM");
        catalogs.add(table);
        table = new HashMap();
        table.put("TABLE_TYPE", "BUCKET");
        catalogs.add(table);
        table = new HashMap();
        table.put("TABLE_TYPE", "GSI INDEX");
        catalogs.add(table);
        table = new HashMap();
        table.put("TABLE_TYPE", "VIEW INDEX");
        catalogs.add(table);
        CouchMetrics metrics = new CouchMetrics();
        metrics.setResultCount(table.size());
        metrics.setResultSize(1);
        HashMap<String, String> signature = new HashMap<String, String>();
        signature.put("TABLE_TYPE", "string");
        CouchResponse couchResponse = new CouchResponse();
        couchResponse.setResults(catalogs);
        couchResponse.setMetrics(metrics);
        couchResponse.setSignature(signature);
        return new CBResultSet(null, couchResponse);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "select null as TABLE_CAT, namespace_id as TABLE_SCHEM, keyspace_id as TABLE_NAME, 'id' as COLUMN_NAME, 1 as KEY_SEQ, name as PK_NAME from system:indexes where is_primary = true";
        if (schema != null) {
            sql = sql + " and namespace_id like " + schema;
        }
        if (table != null) {
            sql = sql + " and keyspace_id like " + table;
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ArrayList types = new ArrayList(2);
        HashMap<String, Object> type = new HashMap<String, Object>(32);
        types.add(type);
        type.put("TYPE_NAME", "NUMERIC");
        type.put("DATA_TYPE", 2);
        type.put("PRECISION", 38);
        type.put("LITERAL_PREFIX", null);
        type.put("LITERAL_SUFFIX", null);
        type.put("CREATE_PARMS", "precision,scale");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", false);
        type.put("SEARCHABLE", 2);
        type.put("UNSIGNED_ATTRIBUTE", false);
        type.put("FIXED_PREC_SCALE", false);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "NUMERIC");
        type.put("MINIMUM_SCALE", 0);
        type.put("MAXIMUM_SCALE", 38);
        type.put("SQL_DATA_TYPE", 2);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", 10);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "NULL");
        type.put("DATA_TYPE", 0);
        type.put("PRECISION", 0);
        type.put("LITERAL_PREFIX", "'");
        type.put("LITERAL_SUFFIX", "'");
        type.put("CREATE_PARMS", "length");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", true);
        type.put("SEARCHABLE", 3);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "NULL");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 0);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "ARRAY");
        type.put("DATA_TYPE", 2003);
        type.put("PRECISION", 65500);
        type.put("LITERAL_PREFIX", "'");
        type.put("LITERAL_SUFFIX", "'");
        type.put("CREATE_PARMS", "max length");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", true);
        type.put("SEARCHABLE", 3);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "ARRAY");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 12);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "MISSING");
        type.put("DATA_TYPE", 12);
        type.put("PRECISION", 255);
        type.put("LITERAL_PREFIX", "'");
        type.put("LITERAL_SUFFIX", "'");
        type.put("CREATE_PARMS", "max length");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", true);
        type.put("SEARCHABLE", 3);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "MISSING");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 12);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "OBJECT");
        type.put("DATA_TYPE", 12);
        type.put("PRECISION", 65500);
        type.put("LITERAL_PREFIX", "'");
        type.put("LITERAL_SUFFIX", "'");
        type.put("CREATE_PARMS", "max length");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", true);
        type.put("SEARCHABLE", 3);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "OBJECT");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 12);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "STRING");
        type.put("DATA_TYPE", 12);
        type.put("PRECISION", 510);
        type.put("LITERAL_PREFIX", "'");
        type.put("LITERAL_SUFFIX", "'");
        type.put("CREATE_PARMS", "max length");
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", true);
        type.put("SEARCHABLE", 3);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "STRING");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 12);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        type = new HashMap(32);
        type.put("TYPE_NAME", "BOOLEAN");
        type.put("DATA_TYPE", 16);
        type.put("PRECISION", 1);
        type.put("LITERAL_PREFIX", null);
        type.put("LITERAL_SUFFIX", null);
        type.put("CREATE_PARMS", null);
        type.put("NULLABLE", 1);
        type.put("CASE_SENSITIVE", false);
        type.put("SEARCHABLE", 2);
        type.put("UNSIGNED_ATTRIBUTE", null);
        type.put("FIXED_PREC_SCALE", 0);
        type.put("AUTO_INCREMENT", null);
        type.put("LOCAL_TYPE_NAME", "BOOLEAN");
        type.put("MINIMUM_SCALE", null);
        type.put("MAXIMUM_SCALE", null);
        type.put("SQL_DATA_TYPE", 16);
        type.put("SQL_DATETIME_SUB", null);
        type.put("NUM_PREC_RADIX", null);
        types.add(type);
        HashMap<String, String> signature = new HashMap<String, String>();
        signature.put("TYPE_NAME", "string");
        signature.put("DATA_TYPE", "numeric");
        signature.put("PRECISION", "numeric");
        signature.put("LITERAL_PREFIX", "string");
        signature.put("LITERAL_SUFFIX", "string");
        signature.put("CREATE_PARMS", "string");
        signature.put("NULLABLE", "numeric");
        signature.put("CASE_SENSITIVE", "boolean");
        signature.put("SEARCHABLE", "numeric");
        signature.put("UNSIGNED_ATTRIBUTE", "boolean");
        signature.put("FIXED_PREC_SCALE", "boolean");
        signature.put("AUTO_INCREMENT", "boolean");
        signature.put("LOCAL_TYPE_NAME", "string");
        signature.put("MINIMUM_SCALE", "numeric");
        signature.put("MAXIMUM_SCALE", "numeric");
        signature.put("SQL_DATA_TYPE", "numeric");
        signature.put("SQL_DATETIME_SUB", "numeric");
        signature.put("NUM_PREC_RADIX", "numeric");
        CouchMetrics metrics = new CouchMetrics();
        metrics.setResultCount(types.size());
        metrics.setResultSize(2);
        CouchResponse couchResponse = new CouchResponse();
        couchResponse.setResults(types);
        couchResponse.setMetrics(metrics);
        couchResponse.setSignature(signature);
        return new CBResultSet(null, couchResponse);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ArrayList udts = new ArrayList(2);
        CouchMetrics metrics = new CouchMetrics();
        metrics.setResultCount(udts.size());
        metrics.setResultSize(1);
        HashMap<String, String> signature = new HashMap<String, String>();
        CouchResponse couchResponse = new CouchResponse();
        couchResponse.setResults(udts);
        couchResponse.setMetrics(metrics);
        couchResponse.setSignature(signature);
        return new CBResultSet(null, couchResponse);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return Integer.parseInt(System.getProperty("java.specification.version").split("\\.")[1]) == 8 ? 2 : 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String sql = "select name as TABLE_SCHEM, 'Couchbase' as TABLE_CATALOG from system:namespaces";
        if (schemaPattern != null) {
            sql = sql + " where name like '" + schemaPattern + "'";
        }
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    private ResultSet getEmptyResultSet() {
        ArrayList types = new ArrayList();
        HashMap<String, String> signature = new HashMap<String, String>();
        CouchMetrics metrics = new CouchMetrics();
        metrics.setResultCount(types.size());
        metrics.setResultSize(2);
        CouchResponse couchResponse = new CouchResponse();
        couchResponse.setResults(types);
        couchResponse.setMetrics(metrics);
        couchResponse.setSignature(signature);
        return new CBResultSet(null, couchResponse);
    }
}

