/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import ch.qos.logback.classic.Level;
import com.couchbase.CBConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBDriver
implements Driver {
    public static final Logger logger = LoggerFactory.getLogger(CBDriver.class.getName());
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    public static final String DRIVER_NAME = "n1ql_jdbc";
    static CBDriver registered;
    final Thread houseKeepingThread;
    final ClusterThread ct;
    private static final MessageFormat mf;
    static boolean runCluster;

    public CBDriver() throws SQLException {
        logger.info("Constructor called");
        this.ct = new ClusterThread();
        this.houseKeepingThread = new Thread((Runnable)this.ct, "Couchbase housekeeping thread");
        this.houseKeepingThread.setDaemon(true);
        this.houseKeepingThread.start();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            CBConnection con = new CBConnection(url, info);
            this.ct.addConnection(con);
            return con;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:couchbase:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class callClass, String functionName) {
        return new SQLFeatureNotSupportedException(mf.format(new Object[]{callClass.getName(), functionName}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(Level logLevel) {
        Class<CBDriver> clazz = CBDriver.class;
        synchronized (CBDriver.class) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("com.couchbase");
            logger.setLevel(logLevel);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Level getLogLevel() {
        Class<CBDriver> clazz = CBDriver.class;
        synchronized (CBDriver.class) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("com.couchbase");
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger.getLevel();
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw CBDriver.notImplemented(CBDriver.class, "getParentLogger");
    }

    public static void cleanup() {
        if (registered != null) {
            try {
                DriverManager.deregisterDriver(registered);
                runCluster = false;
                Thread.currentThread().interrupt();
            }
            catch (SQLException e) {
                logger.warn("Error deregistering driver", e);
            }
        }
    }

    public void cleanup(CBConnection con) {
        this.ct.removeConnection(con);
    }

    static {
        try {
            registered = new CBDriver();
            DriverManager.registerDriver(registered);
        }
        catch (SQLException e) {
            logger.error("Error registering driver", e);
        }
        mf = new MessageFormat("Method {0}.{1} is not yet implemented.");
        runCluster = true;
    }

    private static class ClusterThread
    implements Runnable {
        ConcurrentLinkedQueue<CBConnection> connections = new ConcurrentLinkedQueue();

        ClusterThread() {
        }

        @Override
        public void run() {
            while (runCluster) {
                CBConnection connection = this.connections.poll();
                if (connection != null) {
                    try {
                        connection.pollCluster();
                    }
                    catch (SQLException e) {
                        logger.error("Error polling cluster", e);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void addConnection(CBConnection connection) {
            this.connections.add(connection);
        }

        public void removeConnection(CBConnection connection) {
            this.connections.remove(connection);
        }
    }
}

