/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBDriver;
import com.couchbase.CBResultSet;
import com.couchbase.CBStatement;
import com.couchbase.jdbc.CBParameterMetaData;
import com.couchbase.jdbc.CBPreparedResult;
import com.couchbase.jdbc.Protocol;
import com.couchbase.jdbc.core.CouchResponse;
import com.couchbase.jdbc.util.SqlParser;
import com.couchbase.jdbc.util.TimestampUtils;
import com.couchbase.json.SQLJSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBPreparedStatement
extends CBStatement
implements PreparedStatement {
    private static final Logger logger = LoggerFactory.getLogger(CBPreparedStatement.class);
    private static final String PREPARED = "prepared";
    private static final String ARGS = "args";
    final String sql;
    final CBPreparedResult preparedStatement;
    final SqlParser parser;
    final Object[] fields;
    Map<String, Object> parameters = new HashMap<String, Object>();
    TimestampUtils timestampUtils = new TimestampUtils();
    String[] returning = null;

    public CBPreparedStatement(Connection con, Protocol protocol, String sql) throws SQLException {
        super(con, protocol);
        this.parser = new SqlParser(sql);
        this.parser.parse();
        this.fields = new Object[this.parser.getNumFields()];
        this.sql = this.parser.replaceProcessing(sql, this.escapeProcessing);
        logger.trace("Prepare statement {}", (Object)this.parser.toString());
        CouchResponse ret = protocol.prepareStatement(this.parser.toString(), this.returning);
        this.preparedStatement = new CBPreparedResult((Map)ret.getFirstResult().get("$1"));
    }

    public CBPreparedStatement(Connection con, Protocol protocol, String sql, String[] returning) throws SQLException {
        super(con, protocol);
        this.parser = new SqlParser(sql);
        this.parser.parse();
        this.fields = new Object[this.parser.getNumFields()];
        this.sql = sql;
        this.returning = returning;
        logger.trace("Prepare statement {}", (Object)this.parser.toString());
        CouchResponse ret = protocol.prepareStatement(this.parser.toString(), returning);
        this.preparedStatement = new CBPreparedResult((Map)ret.getFirstResult().get("$1"));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.parameters.put(PREPARED, this.preparedStatement.getName());
        this.parameters.put("encoded_plan", this.preparedStatement.getEncodedPlan());
        if (this.fields != null && this.fields.length > 0) {
            this.parameters.put(ARGS, this.fields);
        }
        CouchResponse couchResponse = this.protocol.doQuery(this.sql, this.parameters);
        return new CBResultSet(this, couchResponse);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.parameters.clear();
        logger.trace("Using {}\n Encoded Plan {}", (Object)this.preparedStatement.getName(), (Object)this.preparedStatement.getEncodedPlan());
        this.parameters.put(PREPARED, this.preparedStatement.getName());
        this.parameters.put("encoded_plan", this.preparedStatement.getEncodedPlan());
        if (this.fields != null && this.fields.length > 0) {
            this.parameters.put(ARGS, this.fields);
        }
        CouchResponse couchResponse = this.protocol.doQuery(this.sql, this.parameters);
        return (int)couchResponse.getMetrics().getMutationCount();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = null;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = Boolean.toString(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = Long.toString(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = Float.valueOf(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = new String(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.setCharacterStream(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.setCharacterStream(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x.toString();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = null;
        }
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = x.toString();
    }

    public void setSQLJSON(int parameterIndex, SQLJSON sqljson) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = sqljson.parameterValue();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 2000);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof SQLJSON) {
            this.setSQLJSON(parameterIndex, (SQLJSON)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else {
            throw new SQLException("Can''t infer the SQL type to use for an instance of " + x + ". Use setObject() with an explicit Types value to specify the type to use.");
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.parameters.clear();
        this.parameters.put(PREPARED, this.preparedStatement.getName());
        this.parameters.put("encoded_plan", this.preparedStatement.getEncodedPlan());
        if (this.fields != null && this.fields.length > 0) {
            this.parameters.put(ARGS, this.fields);
        }
        CouchResponse couchResponse = this.protocol.doQuery(this.sql, this.parameters);
        this.updateCount = (int)couchResponse.getMetrics().getMutationCount();
        if ((int)couchResponse.getMetrics().getResultCount() > 0) {
            this.resultSet = new CBResultSet(this, couchResponse);
            return true;
        }
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (reader == null) {
            this.setNull(parameterIndex, 12);
        } else {
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            try {
                int n;
                while ((n = reader.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new SQLException("Provided Reader failed.");
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead));
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 2003);
        } else {
            this.fields[parameterIndex - 1] = x.getArray();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "getMetaData");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            if (cal != null) {
                cal = (Calendar)cal.clone();
            }
            this.fields[parameterIndex - 1] = this.timestampUtils.toString(cal, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 92);
            return;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        this.fields[parameterIndex - 1] = this.timestampUtils.toString(cal, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            if (cal != null) {
                cal = (Calendar)cal.clone();
            }
            this.fields[parameterIndex - 1] = this.timestampUtils.toString(cal, x);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.fields[parameterIndex - 1] = x.toString();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new CBParameterMetaData(this.preparedStatement);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (value == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.fields[parameterIndex - 1] = value;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setNCharacterStream");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                this.setInt(parameterIndex, CBPreparedStatement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, CBPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, CBPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, CBPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, CBPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, CBPreparedStatement.castToBigDecimal(in, scaleOrLength));
                break;
            }
            case 1: {
                this.setString(parameterIndex, CBPreparedStatement.castToString(in));
                break;
            }
            case -1: 
            case 12: {
                this.setString(parameterIndex, CBPreparedStatement.castToString(in));
                break;
            }
            case 91: {
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                Date tmpd = null;
                if (in instanceof java.util.Date) {
                    tmpd = new Date(((java.util.Date)in).getTime());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                Time tmpt = null;
                if (in instanceof java.util.Date) {
                    tmpt = new Time(((java.util.Date)in).getTime());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                Timestamp tmpts = null;
                if (in instanceof java.util.Date) {
                    tmpts = new Timestamp(((java.util.Date)in).getTime());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                this.setBoolean(parameterIndex, CBPreparedStatement.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                throw new SQLException("Cannot cast an instance of " + in.getClass().getName() + " to type " + 2004);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new SQLException("Cannot cast an instance of " + in.getClass().getName() + " to type " + 2005);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                throw new SQLException("Cannot cast an instance of " + in.getClass().getName() + " to type " + 2003);
            }
            case 2001: {
                this.setString(parameterIndex, in.toString());
                break;
            }
            case 2000: {
                this.setString(parameterIndex, in.toString());
                break;
            }
            default: {
                throw new SQLException("Unsupported Types value: " + targetSqlType);
            }
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            if (in instanceof String) {
                return new BigDecimal((String)in).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof BigDecimal) {
                return ((BigDecimal)in).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof BigInteger) {
                return new BigDecimal((BigInteger)in, scale);
            }
            if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                return BigDecimal.valueOf(((Number)in).longValue(), scale);
            }
            if (in instanceof Double || in instanceof Float) {
                return BigDecimal.valueOf(((Number)in).doubleValue()).setScale(scale, RoundingMode.HALF_UP);
            }
            if (in instanceof java.util.Date) {
                return BigDecimal.valueOf(((java.util.Date)in).getTime(), scale);
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (in instanceof Clob) {
                return new BigDecimal(CBPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return new BigDecimal(new char[]{((Character)in).charValue()}).setScale(scale, RoundingMode.HALF_UP);
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static boolean castToBoolean(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return ((String)in).equalsIgnoreCase("true") || in.equals("1") || ((String)in).equalsIgnoreCase("t");
            }
            if (in instanceof BigDecimal) {
                return ((BigDecimal)in).signum() != 0;
            }
            if (in instanceof Number) {
                return ((Number)in).longValue() != 0L;
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime() != 0L;
            }
            if (in instanceof Boolean) {
                return (Boolean)in;
            }
            if (in instanceof Clob) {
                String asString = CBPreparedStatement.asString((Clob)in);
                return asString.equalsIgnoreCase("true") || asString.equals("1") || asString.equalsIgnoreCase("t");
            }
            if (in instanceof Character) {
                return ((Character)in).charValue() == '1' || ((Character)in).charValue() == 't' || ((Character)in).charValue() == 'T';
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "boolean", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "boolean");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Number || in instanceof Boolean || in instanceof Character || in instanceof java.util.Date) {
                return in.toString();
            }
            if (in instanceof Clob) {
                return CBPreparedStatement.asString((Clob)in);
            }
        }
        catch (Exception e) {
            throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
        throw CBPreparedStatement.cannotCastException(in.getClass().getName(), "String");
    }

    private static SQLException cannotCastException(String fromType, String toType) {
        return CBPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static SQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new SQLException("Cannot convert an instance of " + fromType + " to type " + toType, cause);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Length greater than 2147483647");
        }
        this.setCharacterStream(parameterIndex, x, (int)length, "ASCII");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Length greater than 2147483647");
        }
        this.setCharacterStream(parameterIndex, x, (int)length, "ASCII");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Length greater than 2147483647");
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setCharacterNStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBPreparedStatement.class, "setNClob");
    }

    private void setCharacterStream(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new SQLException("Invalid stream length " + length);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new SQLException("The JVM claims not to support the " + encoding + " encoding.");
        }
        catch (IOException l_ioe) {
            throw new SQLException("Provided InputStream failed.");
        }
    }

    public void setMap(int parameterIndex, Map map) throws SQLException {
        this.checkClosed();
        this.checkFields(parameterIndex);
        this.fields[parameterIndex - 1] = map;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    private void checkFields(int index) throws SQLException {
        if (this.fields == null) {
            throw new SQLException("fields not initialized");
        }
        if (index - 1 > this.fields.length) {
            throw new SQLException("Column number out of bounds");
        }
    }
}

