/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBArray;
import com.couchbase.CBDriver;
import com.couchbase.CBResultSetMetaData;
import com.couchbase.jdbc.core.CouchError;
import com.couchbase.jdbc.core.CouchResponse;
import com.couchbase.jdbc.core.Field;
import com.couchbase.jdbc.core.SqlJsonImplementation;
import com.couchbase.jdbc.util.TimestampUtils;
import com.couchbase.json.SQLJSON;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.boon.json.JsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(CBResultSet.class);
    final CouchResponse response;
    AtomicBoolean closed = new AtomicBoolean(false);
    Statement statement;
    boolean wasNull = false;
    boolean isMissing = false;
    int index = -1;
    List<Field> fields = new ArrayList<Field>();
    private final TimestampUtils timestampUtils = new TimestampUtils();
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
    SimpleDateFormat tsf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CBResultSet(Statement statement, CouchResponse response) {
        this.statement = statement;
        this.response = response;
        if (response.getMetrics().getResultSize() == 0L) {
            return;
        }
        this.fields = response.getFields();
        logger.debug("Loaded result set");
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        ++this.index;
        return this.index < this.response.getResults().size();
    }

    @Override
    public void close() throws SQLException {
        this.closed.set(true);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getStringChecked(field.getName());
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getBooleanChecked(field.getName());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getByteChecked(field.getName());
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getShortChecked(field.getName());
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getIntChecked(field.getName());
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getLongChecked(field.getName());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getFloatChecked(field.getName());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getDoubleChecked(field.getName());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getBigDecimalChecked(field.getName(), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getBytesChecked(field.getName());
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getDateChecked(field.getName(), null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getTimeChecked(field.getName(), null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getTimestampChecked(field.getName(), null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getAsciiStreamChecked(field.getName());
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getUnicodeStreamChecked(field.getName());
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getBinaryStreamChecked(field.getName());
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getStringChecked(columnLabel);
    }

    private String getStringChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object object = jsonObject.get(columnLabel);
        this.wasNull = object == null;
        if (this.wasNull) {
            return null;
        }
        if (object instanceof Map) {
            return JsonFactory.toJson(object);
        }
        if (!(object instanceof String)) {
            return object.toString();
        }
        return (String)object;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getBooleanChecked(columnLabel);
    }

    private boolean getBooleanChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        Object object = jsonObject.get(columnLabel);
        this.wasNull = object == null;
        if (this.wasNull) {
            return false;
        }
        return (Boolean)object;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getByteChecked(columnLabel);
    }

    private byte getByteChecked(String columnLabel) throws SQLException {
        byte value;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        try {
            Object object = jsonObject.get(columnLabel);
            this.wasNull = object == null;
            value = this.wasNull ? (byte)0 : (object instanceof Integer ? ((Integer)object).byteValue() : Byte.parseByte(object.toString()));
        }
        catch (Exception ex) {
            throw new SQLException("value is not a byte");
        }
        logger.info("value {}", (Object)value);
        return value;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getShortChecked(columnLabel);
    }

    private short getShortChecked(String columnLabel) throws SQLException {
        short value;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        try {
            Object object = jsonObject.get(columnLabel);
            this.wasNull = object == null;
            value = this.wasNull ? (short)0 : (object instanceof Integer ? ((Integer)object).shortValue() : Short.parseShort(object.toString()));
        }
        catch (Exception ex) {
            throw new SQLException("value is not a short");
        }
        logger.info("value {}", (Object)value);
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getIntChecked(columnLabel);
    }

    private int getIntChecked(String columnLabel) throws SQLException {
        int value;
        Map<String, Object> jsonObject;
        block6: {
            jsonObject = this.response.getResults().get(this.index);
            if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
                return 0;
            }
            try {
                Object object = jsonObject.get(columnLabel);
                this.wasNull = object == null;
                if (this.wasNull) {
                    value = 0;
                    break block6;
                }
                if (object instanceof Number) {
                    value = ((Number)object).intValue();
                    break block6;
                }
                if (object instanceof String) {
                    value = Integer.parseInt((String)object);
                    break block6;
                }
                throw new SQLException("value {} is not an integer", object.toString());
            }
            catch (NumberFormatException ex) {
                throw new SQLException("value is not an integer");
            }
        }
        logger.info("value {}", jsonObject.get(columnLabel));
        return value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getLongChecked(columnLabel);
    }

    private long getLongChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject;
        long value;
        block5: {
            value = 0L;
            jsonObject = this.response.getResults().get(this.index);
            this.checkColumnLabelMissing(jsonObject, columnLabel);
            try {
                Object object = jsonObject.get(columnLabel);
                if (object == null) {
                    this.wasNull = true;
                    break block5;
                }
                if (object instanceof Number) {
                    value = ((Number)object).intValue();
                    break block5;
                }
                if (object instanceof String) {
                    value = Long.parseLong((String)object);
                    break block5;
                }
                throw new SQLException("value " + object.toString() + " is not a long");
            }
            catch (NumberFormatException ex) {
                throw new SQLException("value is not a long");
            }
        }
        logger.info("value {}", jsonObject.get(columnLabel));
        return value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getFloatChecked(columnLabel);
    }

    private float getFloatChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject;
        float value;
        block5: {
            value = 0.0f;
            jsonObject = this.response.getResults().get(this.index);
            this.checkColumnLabelMissing(jsonObject, columnLabel);
            try {
                Object object = jsonObject.get(columnLabel);
                if (object == null) {
                    this.wasNull = true;
                    break block5;
                }
                if (object instanceof Number) {
                    value = ((Number)object).floatValue();
                    break block5;
                }
                if (object instanceof String) {
                    value = Float.parseFloat((String)object);
                    break block5;
                }
                throw new SQLException("value {} is not a float", object.toString());
            }
            catch (NumberFormatException ex) {
                throw new SQLException("value is not a float");
            }
        }
        logger.info("value {}", jsonObject.get(columnLabel));
        return value;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getDoubleChecked(columnLabel);
    }

    private double getDoubleChecked(String columnLabel) throws SQLException {
        double value;
        block5: {
            value = 0.0;
            Map<String, Object> jsonObject = this.response.getResults().get(this.index);
            this.checkColumnLabelMissing(jsonObject, columnLabel);
            try {
                Object object = jsonObject.get(columnLabel);
                if (object == null) {
                    this.wasNull = true;
                    break block5;
                }
                if (object instanceof Number) {
                    value = ((Number)object).doubleValue();
                    break block5;
                }
                if (object instanceof String) {
                    value = Double.parseDouble((String)object);
                    break block5;
                }
                throw new SQLException("value {} is not a double", object.toString());
            }
            catch (NumberFormatException ex) {
                throw new SQLException("value is not a double");
            }
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getBigDecimalChecked(columnLabel, scale);
    }

    private BigDecimal getBigDecimalChecked(String columnLabel, int scale) throws SQLException {
        BigDecimal value;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        Object json = jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        try {
            value = new BigDecimal((Double)json);
            value = value.setScale(scale, 4);
        }
        catch (Exception ex) {
            throw new SQLException("value is not a Big Decimal");
        }
        logger.info("value {}", (Object)value);
        return value;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getBytesChecked(columnLabel);
    }

    private byte[] getBytesChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        String json = (String)jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        try {
            return json.getBytes();
        }
        catch (Exception ex) {
            throw new SQLException("Error getting bytes ", ex);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(columnLabel, null);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getTimeChecked(columnLabel, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getTimestampChecked(columnLabel, null);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getAsciiStreamChecked(columnLabel);
    }

    private InputStream getAsciiStreamChecked(String columnLabel) throws SQLException {
        ByteArrayInputStream byteArrayInputStream;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        this.checkColumnLabelMissing(jsonObject, columnLabel);
        String json = (String)jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.getStringChecked(columnLabel).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException("data is not ASCII");
        }
        return byteArrayInputStream;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getUnicodeStreamChecked(columnLabel);
    }

    private InputStream getUnicodeStreamChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object json = jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getStringChecked(columnLabel).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new SQLException("The JVM claims not to support the encoding: {0}", "UTF-8", l_uee);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getBinaryStreamChecked(columnLabel);
    }

    private InputStream getBinaryStreamChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object json = jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        return new ByteArrayInputStream(this.getStringChecked(columnLabel).getBytes());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.response == null) {
            throw new SQLException("Result Set is closed");
        }
        SQLWarning sqlWarning = null;
        for (CouchError warning : this.response.getWarnings()) {
            if (sqlWarning != null) {
                sqlWarning = new SQLWarning(warning.getMsg(), null, warning.getCode());
                continue;
            }
            sqlWarning.setNextWarning(new SQLWarning(warning.getMsg(), null, warning.getCode()));
        }
        return sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw CBDriver.notImplemented(this.getClass(), "getCursorName");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new CBResultSetMetaData(this);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getObjectChecked(fieldName);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getObjectChecked(columnLabel);
    }

    private Object getObjectChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object object = jsonObject.get(columnLabel);
        this.wasNull = object == null;
        if (this.wasNull) {
            return null;
        }
        for (Field field : this.fields) {
            if (!field.getName().equals(columnLabel)) continue;
            switch (field.getSqlType()) {
                case 2: {
                    return new Double((String)object);
                }
                case 16: {
                    return Boolean.valueOf((String)object);
                }
                case 12: {
                    if (object instanceof java.util.Date) {
                        return new Date(((java.util.Date)object).getTime());
                    }
                    return object;
                }
                case 2000: 
                case 2003: {
                    return object;
                }
                case 0: {
                    return null;
                }
            }
        }
        return null;
    }

    public SQLJSON getSQLJSON(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getSQLJSONChecked(field.getName());
    }

    public SQLJSON getSQLJSON(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getSQLJSONChecked(columnLabel);
    }

    private SQLJSON getSQLJSONChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object object = jsonObject.get(columnLabel);
        this.wasNull = object == null;
        if (this.wasNull) {
            return null;
        }
        int columnIndex = this.findColumn(columnLabel) - 1;
        return new SqlJsonImplementation(object, this.fields.get(columnIndex));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getName().equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException("column " + columnLabel + " does not exist");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getCharacterStreamChecked(field.getName());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getCharacterStreamChecked(columnLabel);
    }

    private Reader getCharacterStreamChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object object = jsonObject.get(columnLabel);
        this.wasNull = object == null;
        if (this.wasNull) {
            return null;
        }
        return new CharArrayReader(this.getStringChecked(columnLabel).toCharArray());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getBigDecimalChecked(field.getName());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getBigDecimalChecked(columnLabel);
    }

    private BigDecimal getBigDecimalChecked(String columnLabel) throws SQLException {
        BigDecimal value = null;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        try {
            Object object = jsonObject.get(columnLabel);
            this.wasNull = object == null;
            if (this.wasNull) {
                return null;
            }
            if (object instanceof Number) {
                value = new BigDecimal(((Number)object).doubleValue());
            } else if (object instanceof BigDecimal) {
                value = (BigDecimal)object;
            }
        }
        catch (Exception ex) {
            throw new SQLException("value is not a Big Decimal");
        }
        logger.info("value {}", (Object)value);
        return value;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "isBeforeFirst");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "isBeforeFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "isBeforeFirst");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "isBeforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.index = (int)this.response.getMetrics().getResultCount();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.index = 0;
        return this.response.getResults().size() > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.index = this.response.getResults().size();
        return this.response.getResults().size() > 0;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.index + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "absolute");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "relative");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        throw new SQLException("Result set is Type Forward only");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (1001 == direction) {
            throw new SQLException("Cannot change fetch direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNull");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "getRef");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getArrayChecked(fieldName);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getArrayChecked(columnLabel);
    }

    public Array getArrayChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object json = jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        if (!(json instanceof List)) {
            throw new SQLException("Column is not a list ");
        }
        return new CBArray((List)json);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getDateChecked(fieldName, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getDateChecked(columnLabel, cal);
    }

    private Date getDateChecked(String columnLabel, Calendar cal) throws SQLException {
        Date date;
        block8: {
            Map<String, Object> jsonObject = this.response.getResults().get(this.index);
            if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
                return null;
            }
            Object json = jsonObject.get(columnLabel);
            this.wasNull = json == null;
            if (this.wasNull) {
                return null;
            }
            try {
                if (json instanceof java.util.Date) {
                    date = new Date(((java.util.Date)json).getTime());
                    break block8;
                }
                if (json instanceof Date) {
                    return (Date)json;
                }
                if (json instanceof String) {
                    date = new Date(df.parse((String)json).getTime());
                    break block8;
                }
                throw new SQLException("value " + json + " is not a Date");
            }
            catch (ParseException ex) {
                throw new SQLException("value " + json + " is not a Date", ex);
            }
        }
        if (cal != null) {
            date = this.timestampUtils.applyCalendar(cal, date);
        }
        return date;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getTimeChecked(fieldName, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getTimeChecked(columnLabel, cal);
    }

    private Time getTimeChecked(String columnLabel, Calendar cal) throws SQLException {
        Time time;
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        String json = (String)jsonObject.get(columnLabel);
        if (json == null) {
            return null;
        }
        try {
            time = new Time(this.tf.parse(json).getTime());
        }
        catch (Exception ex) {
            throw new SQLException("value " + json + " is not a Time", ex);
        }
        if (cal != null) {
            time = this.timestampUtils.applyCalendar(cal, time);
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getTimestampChecked(fieldName, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getTimestampChecked(columnLabel, cal);
    }

    private Timestamp getTimestampChecked(String columnLabel, Calendar cal) throws SQLException {
        Timestamp ts;
        block7: {
            Map<String, Object> jsonObject = this.response.getResults().get(this.index);
            if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
                return null;
            }
            Object json = jsonObject.get(columnLabel);
            this.wasNull = json == null;
            if (this.wasNull) {
                return null;
            }
            try {
                if (json instanceof java.util.Date || json instanceof Date) {
                    ts = new Timestamp(((java.util.Date)json).getTime());
                    break block7;
                }
                if (json instanceof String) {
                    ts = this.timestampUtils.parseTimestamp((String)json);
                    break block7;
                }
                throw new SQLException("value " + json + " is not a Timestamp");
            }
            catch (Exception ex) {
                throw new SQLException("value " + json + "is not a Timestamp", ex);
            }
        }
        if (cal != null) {
            ts = this.timestampUtils.applyCalendar(cal, ts);
        }
        return ts;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getURLChecked(fieldName);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        return this.getURLChecked(columnLabel);
    }

    private URL getURLChecked(String columnLabel) throws SQLException {
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        Object json = jsonObject.get(columnLabel);
        this.wasNull = json == null;
        if (this.wasNull) {
            return null;
        }
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "getRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getNClob(fieldName);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        String fieldName = field.getName();
        return this.getSQLXML(fieldName);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getNCharacterStream(field.getName());
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Map<String, Object> jsonObject = this.response.getResults().get(this.index);
        if (this.checkColumnLabelMissing(jsonObject, columnLabel)) {
            return null;
        }
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw CBDriver.notImplemented(CBResultSet.class, "updateN        throw CBDriver.notImplemented(CBResultSet.class, \"updateClob\");\ngetClob");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        Field field = this.getField(columnIndex);
        return this.getObject(field.getName(), type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkIndex();
        if (type.getName().equals("java.sql.Timestamp")) {
            return (T)this.getTimestampChecked(columnLabel, null);
        }
        if (type.getName().equals("java.sql.Date")) {
            return (T)this.getDateChecked(columnLabel, null);
        }
        throw new SQLException("Conversion not supported to {}", type.getName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    Field getField(int columnNumber) throws SQLException {
        if (--columnNumber < 0 || columnNumber > this.fields.size()) {
            throw new SQLException("Invalid column Number");
        }
        return this.fields.get(columnNumber);
    }

    void checkIndex() throws SQLException {
        if (this.index < 0) {
            throw new SQLException("Invalid index, call ResultSet.next()??");
        }
        if ((long)this.index > this.response.getMetrics().getResultCount()) {
            throw new SQLException("Invalid index");
        }
    }

    void checkClosed() throws SQLException {
        if (this.closed.get()) {
            throw new SQLException("ResultSet is closed");
        }
    }

    boolean checkColumnLabelMissing(Map<String, Object> jsonObject, String label) throws SQLException {
        boolean fieldExists = this.findField(label) != null;
        boolean existsInResults = jsonObject.containsKey(label);
        boolean bl = this.isMissing = fieldExists && !existsInResults;
        if (!fieldExists && !existsInResults) {
            throw new SQLException("ResultSet does not contain " + label);
        }
        this.wasNull = false;
        return this.isMissing;
    }

    private Field findField(String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public boolean wasMissing() {
        return this.isMissing;
    }
}

