/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase;

import com.couchbase.CBDriver;
import com.couchbase.CBResultSet;
import com.couchbase.jdbc.Protocol;
import com.couchbase.jdbc.util.SqlParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;

public class CBStatement
implements Statement {
    Protocol protocol;
    AtomicBoolean closed = new AtomicBoolean(false);
    protected int updateCount = 0;
    protected CBResultSet resultSet;
    protected Connection connection;
    protected boolean escapeProcessing = true;
    protected int maxRows = -1;
    protected boolean poolable = false;
    protected boolean closeOnCompletion = false;

    public CBStatement(Connection connection, Protocol protocol) {
        this.connection = connection;
        this.protocol = protocol;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        SqlParser sqlParser = new SqlParser("");
        sql = sqlParser.replaceProcessing(sql, this.escapeProcessing);
        return this.protocol.query(this, sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        SqlParser sqlParser = new SqlParser("");
        sql = sqlParser.replaceProcessing(sql, this.escapeProcessing);
        return this.protocol.executeUpdate(this, sql);
    }

    @Override
    public void close() throws SQLException {
        this.closed.getAndSet(true);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0x1400000;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.protocol.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        this.protocol.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        throw CBDriver.notImplemented(CBStatement.class, "cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw CBDriver.notImplemented(CBStatement.class, "setCursorName");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        boolean hasResult = this.protocol.execute(this, sql);
        this.resultSet = this.protocol.getResultSet();
        this.updateCount = (int)this.protocol.getUpdateCount();
        return hasResult;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return Short.MAX_VALUE;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        this.protocol.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.protocol.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        return this.protocol.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw CBDriver.notImplemented(CBStatement.class, "getMoreResults");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw CBDriver.notImplemented(ResultSet.class, "executeUpdate");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
    }
}

