/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc;

import com.couchbase.jdbc.Instance;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    Integer instanceIndex = new Integer(0);
    AtomicInteger numInstances = new AtomicInteger(0);
    List<Instance> endpoints = new ArrayList<Instance>();

    public Cluster(List<Map> jsonArray, boolean ssl) {
        int num = jsonArray.size();
        for (int i = 0; i < num; ++i) {
            try {
                this.endpoints.add(new Instance(jsonArray.get(i)));
                this.numInstances.incrementAndGet();
                continue;
            }
            catch (SQLException ex) {
                logger.debug("Invalid endpoint ", (Object)ex.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance getNextEndpoint() {
        int i;
        Integer n = this.instanceIndex;
        synchronized (n) {
            Integer n2 = this.instanceIndex;
            Integer n3 = this.instanceIndex = Integer.valueOf(this.instanceIndex + 1);
            i = n2;
            if (i >= this.numInstances.get()) {
                this.instanceIndex = 0;
                i = 0;
            }
        }
        logger.trace("Endpoint {} of {}", (Object)i, (Object)this.numInstances);
        return this.endpoints.get(i);
    }

    public void addEndPoint(Map endpoint) {
        try {
            this.endpoints.add(new Instance(endpoint));
            this.numInstances.incrementAndGet();
        }
        catch (SQLException ex) {
            logger.debug("Invalid endpoint ", (Object)ex.getCause().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateEndpoint(Instance instance) {
        logger.trace("Invalidating instance {}", (Object)instance);
        Integer n = this.instanceIndex;
        synchronized (n) {
            this.endpoints.remove(instance);
            this.numInstances.decrementAndGet();
        }
    }
}

