/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Map;

public class Instance {
    String cluster;
    String name;
    String queryEndPoint;
    String adminEndPoint;
    String querySecure;
    String adminSecure;
    String options;

    public Instance(Map<String, String> jsonObject) throws SQLException {
        this.cluster = jsonObject.get("cluster");
        this.name = jsonObject.get("name");
        this.adminEndPoint = jsonObject.get("adminEndpoint");
        this.adminSecure = jsonObject.get("adminSecure");
        this.isValidURI(this.adminEndPoint);
        this.queryEndPoint = jsonObject.get("queryEndpoint");
        this.querySecure = jsonObject.get("querySecure");
        this.isValidURI(this.queryEndPoint);
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQueryEndPoint() {
        return this.queryEndPoint;
    }

    public String getSecureQueryEndPoint() {
        return this.querySecure;
    }

    public void setQueryEndPoint(String queryEndPoint) {
        this.queryEndPoint = queryEndPoint;
    }

    public String getAdminEndPoint() {
        return this.adminEndPoint;
    }

    public void setAdminEndPoint(String adminEndPoint) {
        this.adminEndPoint = adminEndPoint;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    private boolean isValidURI(String uriStr) throws SQLException {
        try {
            URI uri = new URI(uriStr);
            return true;
        }
        catch (URISyntaxException e) {
            throw new SQLException("Endpoint " + uriStr + " is invalid", e);
        }
    }

    public String getEndpointURL(boolean ssl) {
        return ssl ? this.querySecure : this.queryEndPoint;
    }

    public String toString() {
        return this.name;
    }
}

