/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc.core;

import com.couchbase.jdbc.core.CouchBaseSQLException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EscapedFunctions {
    public static final String ABS = "abs";
    public static final String ACOS = "acos";
    public static final String ASIN = "asin";
    public static final String ATAN = "atan";
    public static final String ATAN2 = "atan2";
    public static final String CEILING = "ceiling";
    public static final String COS = "cos";
    public static final String COT = "cot";
    public static final String DEGREES = "degrees";
    public static final String EXP = "exp";
    public static final String FLOOR = "floor";
    public static final String LOG = "log";
    public static final String LOG10 = "log10";
    public static final String MOD = "mod";
    public static final String PI = "pi";
    public static final String POWER = "power";
    public static final String RADIANS = "radians";
    public static final String ROUND = "round";
    public static final String SIGN = "sign";
    public static final String SIN = "sin";
    public static final String SQRT = "sqrt";
    public static final String TAN = "tan";
    public static final String TRUNCATE = "truncate";
    public static final String ASCII = "ascii";
    public static final String CHAR = "char";
    public static final String CONCAT = "concat";
    public static final String INSERT = "insert";
    public static final String LCASE = "lcase";
    public static final String LEFT = "left";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String LTRIM = "ltrim";
    public static final String REPEAT = "repeat";
    public static final String REPLACE = "replace";
    public static final String RIGHT = "right";
    public static final String RTRIM = "rtrim";
    public static final String SPACE = "space";
    public static final String SUBSTRING = "substring";
    public static final String UCASE = "ucase";
    public static final String CURDATE = "curdate";
    public static final String CURTIME = "curtime";
    public static final String DAYNAME = "dayname";
    public static final String DAYOFMONTH = "dayofmonth";
    public static final String DAYOFWEEK = "dayofweek";
    public static final String DAYOFYEAR = "dayofyear";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String MONTH = "month";
    public static final String MONTHNAME = "monthname";
    public static final String NOW = "clock_str";
    public static final String QUARTER = "quarter";
    public static final String SECOND = "second";
    public static final String WEEK = "week";
    public static final String YEAR = "year";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String TIMESTAMPDIFF = "timestampdiff";
    public static final String SQL_TSI_ROOT = "SQL_TSI_";
    public static final String SQL_TSI_DAY = "DAY";
    public static final String SQL_TSI_FRAC_SECOND = "FRAC_SECOND";
    public static final String SQL_TSI_HOUR = "HOUR";
    public static final String SQL_TSI_MINUTE = "MINUTE";
    public static final String SQL_TSI_MONTH = "MONTH";
    public static final String SQL_TSI_QUARTER = "QUARTER";
    public static final String SQL_TSI_SECOND = "SECOND";
    public static final String SQL_TSI_WEEK = "WEEK";
    public static final String SQL_TSI_YEAR = "YEAR";
    public static final String DATABASE = "database";
    public static final String IFNULL = "ifnull";
    public static final String USER = "user";
    private static Map functionMap = EscapedFunctions.createFunctionMap();

    private static Map createFunctionMap() {
        Method[] arrayMeths = EscapedFunctions.class.getDeclaredMethods();
        HashMap<String, Method> functionMap = new HashMap<String, Method>(arrayMeths.length * 2);
        for (Method meth : arrayMeths) {
            if (!meth.getName().startsWith("sql")) continue;
            functionMap.put(meth.getName().toLowerCase(Locale.US), meth);
        }
        return functionMap;
    }

    public static Method getFunction(String functionName) {
        return (Method)functionMap.get("sql" + functionName.toLowerCase(Locale.US));
    }

    public static String sqlceiling(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", CEILING));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ceil(");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqllog(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", LOG));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ln(");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlcot(List<StringBuilder> parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", COT));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("1/tan(");
        buf.append((CharSequence)parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqllog10(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", LOG10));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("log(");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlpower(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new CouchBaseSQLException(String.format("{0} function takes two and only two arguments.", POWER));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("power(");
        buf.append(parsedArgs.get(0)).append(',').append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqltruncate(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new CouchBaseSQLException(String.format("{0} function takes two and only two arguments.", TRUNCATE));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("trunc(");
        buf.append(parsedArgs.get(0)).append(',').append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqlchar(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", CHAR));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("chr(");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlconcat(List parsedArgs) {
        StringBuilder buf = new StringBuilder();
        buf.append("concat(");
        for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
            buf.append(parsedArgs.get(iArg));
            if (iArg == parsedArgs.size() - 1) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }

    public static String sqlinsert(List<StringBuilder> parsedArgs) throws SQLException {
        if (parsedArgs.size() != 4) {
            throw new CouchBaseSQLException(String.format("{0} function takes four and only four argument.", INSERT));
        }
        int startpluslength = Integer.parseInt(parsedArgs.get(1).toString()) + Integer.parseInt(parsedArgs.get(2).toString());
        StringBuilder buf = new StringBuilder();
        buf.append("concat(").append("substr(").append((CharSequence)parsedArgs.get(0)).append(',').append(0).append(',').append((CharSequence)parsedArgs.get(1)).append("-1)").append(',').append((CharSequence)parsedArgs.get(3)).append(',').append("substr(").append((CharSequence)parsedArgs.get(0)).append(',').append(startpluslength - 1).append(')');
        return buf.append(')').toString();
    }

    public static String sqllcase(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", LCASE));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("lower(");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlleft(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new CouchBaseSQLException(String.format("{0} function takes two and only two arguments.", LEFT));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("substr(");
        buf.append(parsedArgs.get(0)).append(",0,").append(parsedArgs.get(1));
        return buf.append(')').toString();
    }

    public static String sqllength(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", LENGTH));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("length( rtrim(");
        buf.append(parsedArgs.get(0));
        return buf.append("))").toString();
    }

    public static String sqllocate(List parsedArgs) throws SQLException {
        if (parsedArgs.size() == 2) {
            return "(position(" + parsedArgs.get(1) + " , " + parsedArgs.get(0) + ")+1)";
        }
        if (parsedArgs.size() == 3) {
            return "(position(" + parsedArgs.get(1) + ", substr(" + parsedArgs.get(0) + " , " + parsedArgs.get(2) + "))+1)";
        }
        throw new CouchBaseSQLException(String.format("{0} function takes two or three arguments.", LOCATE));
    }

    public static String sqlltrim(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", LTRIM));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ltrim( ");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlright(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new CouchBaseSQLException(String.format("{0} function takes two and only two arguments.", RIGHT));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("substr(");
        buf.append(parsedArgs.get(0)).append(',').append("-").append(parsedArgs.get(1));
        return buf.append(")").toString();
    }

    public static String sqlrtrim(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", RTRIM));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("rtrim( ");
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlspace(List parsedArgs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("repeat(' ',");
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", SPACE));
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlsubstring(List parsedArgs) throws SQLException {
        if (parsedArgs.size() == 2) {
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + "-1)";
        }
        if (parsedArgs.size() == 3) {
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + "-1," + parsedArgs.get(2) + ")";
        }
        throw new CouchBaseSQLException(String.format("{0} function takes two or three arguments.", SUBSTRING));
    }

    public static String sqlucase(List parsedArgs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("upper(");
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", UCASE));
        }
        buf.append(parsedArgs.get(0));
        return buf.append(')').toString();
    }

    public static String sqlnow(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new CouchBaseSQLException(String.format("{0} function doesn''t take any argument.", "now"));
        }
        return "clock_str()";
    }

    public static String sqlcurdate(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new CouchBaseSQLException(String.format("{0} function doesn''t take any argument.", CURDATE));
        }
        return "clock_str('2006-01-01')";
    }

    public static String sqlcurtime(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new CouchBaseSQLException(String.format("{0} function doesn''t take any argument.", CURTIME));
        }
        return "clock_str('15:05:05')";
    }

    public static String sqldayname(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", DAYNAME));
        }
        return "(case date_part_str(" + parsedArgs.get(0) + ",'dow') when 0 then 'SUN' WHEN 1 THEN 'MON' WHEN 2 THEN 'TUE' WHEN 3 THEN 'WED' WHEN 4 THEN 'THU' WHEN 5 THEN 'FRI' WHEN 6 THEN 'SAT' END)";
    }

    public static String sqldayofmonth(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", DAYOFMONTH));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'day')";
    }

    public static String sqldayofweek(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", DAYOFWEEK));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'iso_dow') ";
    }

    public static String sqldayofyear(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", DAYOFYEAR));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'doy')";
    }

    public static String sqlhour(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", HOUR));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'hour')";
    }

    public static String sqlminute(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", MINUTE));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'minute')";
    }

    public static String sqlmonth(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", MONTH));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'month')";
    }

    public static String sqlmonthname(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", MONTHNAME));
        }
        return "(case date_part_str(" + parsedArgs.get(0) + ",'month') WHEN 1 THEN 'JAN' WHEN 2 THEN 'FEB' WHEN 3 THEN 'MAR' WHEN 4 THEN 'APR' WHEN 5 THEN 'MAY' WHEN 6 THEN 'JUN'" + " WHEN 7 THEN 'JUL' WHEN 8 THEN 'AUG' WHEN 9 THEN 'SEP' WHEN 10 THEN 'OCT' WHEN 11 THEN 'NOV' WHEN 12 THEN 'DEC' END)";
    }

    public static String sqlquarter(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", QUARTER));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'quarter')";
    }

    public static String sqlsecond(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", SECOND));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'second')";
    }

    public static String sqlweek(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", WEEK));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'week')";
    }

    public static String sqlyear(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new CouchBaseSQLException(String.format("{0} function takes one and only one argument.", YEAR));
        }
        return "date_part_str(" + parsedArgs.get(0) + ",'year')";
    }

    public static String sqltimestampadd(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 3) {
            throw new CouchBaseSQLException(String.format("{0} function takes three and only three arguments.", TIMESTAMPADD));
        }
        String interval = EscapedFunctions.constantToInterval(parsedArgs.get(0).toString());
        StringBuilder buf = new StringBuilder("DATE_ADD_STR(");
        buf.append(parsedArgs.get(2)).append(',').append(parsedArgs.get(1)).append(',');
        buf.append(interval).append(")");
        return buf.toString();
    }

    private static final String constantToInterval(String type) throws SQLException {
        if (!type.startsWith(SQL_TSI_ROOT)) {
            throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", type));
        }
        String shortType = type.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(shortType)) {
            return "'day'";
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(shortType)) {
            return "'second'";
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(shortType)) {
            return "'hour'";
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(shortType)) {
            return "'minute'";
        }
        if (SQL_TSI_MONTH.equalsIgnoreCase(shortType)) {
            return "'month'";
        }
        if (SQL_TSI_QUARTER.equalsIgnoreCase(shortType)) {
            return "'quarter'";
        }
        if (SQL_TSI_WEEK.equalsIgnoreCase(shortType)) {
            return "'week'";
        }
        if (SQL_TSI_YEAR.equalsIgnoreCase(shortType)) {
            return "'year'";
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(shortType)) {
            throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"));
        }
        throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", type));
    }

    public static String sqltimestampdiff(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 3) {
            throw new CouchBaseSQLException(String.format("{0} function takes three and only three arguments.", TIMESTAMPDIFF));
        }
        String datePart = EscapedFunctions.constantToDatePart(parsedArgs.get(0).toString());
        StringBuilder buf = new StringBuilder();
        buf.append("date_diff_str( ").append(parsedArgs.get(2)).append(',').append(parsedArgs.get(1)).append(',').append(datePart).append(")");
        return buf.toString();
    }

    private static final String constantToDatePart(String type) throws SQLException {
        if (!type.startsWith(SQL_TSI_ROOT)) {
            throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", type));
        }
        String shortType = type.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(shortType)) {
            return "'day'";
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(shortType)) {
            return "'second'";
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(shortType)) {
            return "'hour'";
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(shortType)) {
            return "'minute'";
        }
        if (SQL_TSI_MONTH.equalsIgnoreCase(shortType)) {
            return "'month'";
        }
        if (SQL_TSI_QUARTER.equalsIgnoreCase(shortType)) {
            return "'quarter'";
        }
        if (SQL_TSI_WEEK.equalsIgnoreCase(shortType)) {
            return "'week'";
        }
        if (SQL_TSI_YEAR.equalsIgnoreCase(shortType)) {
            return "'year'";
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(shortType)) {
            throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"));
        }
        throw new CouchBaseSQLException(String.format("Interval {0} not yet implemented", type));
    }

    public static String sqldatabase(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new CouchBaseSQLException(String.format("{0} function doesn''t take any argument.", DATABASE));
        }
        return "current_database()";
    }

    public static String sqlifnull(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 2) {
            throw new CouchBaseSQLException(String.format("{0} function takes two and only two arguments.", IFNULL));
        }
        return "coalesce(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + ")";
    }

    public static String sqluser(List parsedArgs) throws SQLException {
        if (parsedArgs.size() != 0) {
            throw new CouchBaseSQLException(String.format("{0} function doesn''t take any argument.", USER));
        }
        return USER;
    }
}

