/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc.core;

import com.couchbase.CBResultSet;
import com.couchbase.CBStatement;
import com.couchbase.jdbc.Cluster;
import com.couchbase.jdbc.Instance;
import com.couchbase.jdbc.Protocol;
import com.couchbase.jdbc.core.CouchError;
import com.couchbase.jdbc.core.CouchMetrics;
import com.couchbase.jdbc.core.CouchResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.json.JsonFactory;
import org.boon.json.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolImpl
implements Protocol {
    private static final String STATEMENT = "statement";
    private static final String ENCODING = "encoding";
    private static final String NAMESPACE = "namespace";
    private static final String READ_ONLY = "readonly";
    private static final String TIMEOUT = "timeout";
    private static final String CREDENTIALS = "creds";
    private static final String SCAN_CONSITENCY = "scan_consistency";
    private static final int N1QL_ERROR = -1;
    private static final int N1QL_SUCCESS = 0;
    private static final int N1QL_RUNNING = 1;
    private static final int N1QL_COMPLETED = 2;
    private static final int N1QL_STOPPED = 3;
    private static final int N1QL_TIMEOUT = 4;
    private static final int N1QL_FATAL = 5;
    static final Map<String, Integer> statusStrings = new HashMap<String, Integer>();
    String schema;
    String url;
    String user;
    String password;
    String credentials;
    String scanConsistency = "not_bounded";
    SQLWarning sqlWarning;
    Cluster cluster;
    boolean ssl = false;
    int connectTimeout = 0;
    int queryTimeout = 75;
    boolean readOnly = false;
    long updateCount;
    CBResultSet resultSet;
    List<String> batchStatements = new ArrayList<String>();
    private static final Logger logger;
    CloseableHttpClient httpClient;
    RequestConfig requestConfig;
    AtomicBoolean clusterSynch = new AtomicBoolean(true);

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getCredentials() {
        return this.credentials;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    public ProtocolImpl(String url, Properties props) {
        if (props.containsKey("user")) {
            this.user = props.getProperty("user");
        }
        if (props.containsKey("password")) {
            this.password = props.getProperty("password");
        }
        if (props.containsKey("credentials")) {
            this.credentials = props.getProperty("credentials");
        }
        this.url = url;
        this.setConnectionTimeout(props.getProperty("connectionTimeout"));
        if (props.containsKey("ScanConsistency")) {
            this.scanConsistency = props.getProperty("ScanConsistency");
        }
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(0).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.connectTimeout).build();
        if (props.containsKey("EnableSSL") && props.getProperty("EnableSSL").equals("true")) {
            SSLContextBuilder builder = SSLContexts.custom();
            try {
                builder.loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
                SSLContext sslContext = builder.build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                    @Override
                    public void verify(String host, SSLSocket ssl) throws IOException {
                    }

                    @Override
                    public void verify(String host, X509Certificate cert) throws SSLException {
                    }

                    @Override
                    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                    }

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
                Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).build();
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                this.httpClient = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(this.requestConfig).build();
                this.ssl = true;
            }
            catch (Exception ex) {
                logger.error("Error creating ssl client", ex);
            }
        } else {
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.requestConfig).build();
        }
    }

    @Override
    public void connect() throws Exception {
        this.pollCluster();
    }

    public Cluster handleClusterResponse(CloseableHttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = EntityUtils.toString(entity);
        logger.trace("Cluster response {}", (Object)string);
        ObjectMapper mapper = JsonFactory.create();
        Object jsonArray = mapper.fromJson(string);
        String message = "";
        switch (status) {
            case 200: {
                return new Cluster((List)jsonArray, this.ssl);
            }
            case 400: {
                message = "Bad Request";
                break;
            }
            case 401: {
                message = "Unauthorized Request credentials are missing or invalid";
                break;
            }
            case 403: {
                message = "Forbidden Request: read only violation or client unauthorized to modify";
                break;
            }
            case 404: {
                message = "Not found: Check the URL";
                break;
            }
            case 405: {
                message = "Method not allowed: The REST method type in request is supported";
                break;
            }
            case 409: {
                message = "Conflict: attempt to create a keyspace or index that already exists";
                break;
            }
            case 410: {
                message = "Gone: The server is doing a graceful shutdown";
                break;
            }
            case 500: {
                message = "Internal server error: unforeseen problem processing the request";
                break;
            }
            case 503: {
                message = "Service Unavailable: there is an issue preventing the request from being serv serviced";
            }
        }
        throw new ClientProtocolException(message + ": " + status);
    }

    @Override
    public CBResultSet query(CBStatement statement, String sql) throws SQLException {
        Instance instance = this.getNextEndpoint();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(STATEMENT, sql);
        this.addOptions(parameters);
        ArrayList<NameValuePair> parms = new ArrayList<NameValuePair>();
        for (String parameter : parameters.keySet()) {
            parms.add(new BasicNameValuePair(parameter, (String)parameters.get(parameter)));
        }
        while (true) {
            String url = instance.getEndpointURL(this.ssl);
            logger.trace("Using endpoint {}", (Object)url);
            URI uri = null;
            try {
                uri = new URIBuilder(url).addParameters(parms).build();
            }
            catch (URISyntaxException ex) {
                logger.error("Invalid request {}", (Object)url);
            }
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Accept", "application/json");
            logger.trace("Get request {}", (Object)httpGet.toString());
            try {
                CloseableHttpResponse response = this.httpClient.execute(httpGet);
                return new CBResultSet(statement, this.handleResponse(sql, response));
            }
            catch (ConnectTimeoutException cte) {
                logger.trace(cte.getLocalizedMessage());
                this.invalidateEndpoint(instance);
                if ((instance = this.getNextEndpoint()) != null) continue;
                throw new SQLException("All endpoints have failed, giving up");
            }
            catch (IOException ex) {
                logger.error("Error executing query [{}] {}", (Object)sql, (Object)ex.getMessage());
                throw new SQLException("Error executing update", ex.getCause());
            }
            break;
        }
    }

    @Override
    public int executeUpdate(CBStatement statement, String query) throws SQLException {
        boolean hasResultSet = this.execute(statement, query);
        if (!hasResultSet) {
            return (int)this.getUpdateCount();
        }
        return 0;
    }

    public CouchResponse handleResponse(String sql, CloseableHttpResponse response) throws SQLException, IOException {
        List warningList;
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        ObjectMapper mapper = JsonFactory.create();
        CouchResponse couchResponse = new CouchResponse();
        String strResponse = EntityUtils.toString(entity);
        Map foo = mapper.readValue(strResponse, Map.class);
        Map rootAsMap = null;
        if (foo instanceof Map) {
            rootAsMap = foo;
        } else {
            logger.debug("error");
        }
        couchResponse.status = (String)rootAsMap.get("status");
        couchResponse.requestId = (String)rootAsMap.get("requestID");
        Object signature = rootAsMap.get("signature");
        if (signature instanceof Map) {
            couchResponse.signature = (Map)signature;
            couchResponse.results = (List)rootAsMap.get("results");
        } else if (signature instanceof String) {
            couchResponse.signature = new HashMap<String, String>();
            couchResponse.signature.put("$1", (String)signature);
            Iterator iterator = ((List)rootAsMap.get("results")).iterator();
            couchResponse.results = new ArrayList<Map<String, Object>>();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                HashMap entry = new HashMap();
                entry.put("$1", object);
                couchResponse.results.add(entry);
            }
        } else if (signature != null) {
            throw new SQLException("Error reading signature" + signature);
        }
        couchResponse.metrics = MapObjectConversion.fromMap((Map)rootAsMap.get("metrics"), CouchMetrics.class);
        List errorList = (List)rootAsMap.get("errors");
        if (errorList != null) {
            couchResponse.errors = MapObjectConversion.convertListOfMapsToObjects(CouchError.class, errorList);
        }
        if ((warningList = (List)rootAsMap.get("warnings")) != null) {
            couchResponse.warnings = MapObjectConversion.convertListOfMapsToObjects(CouchError.class, warningList);
            for (CouchError warning : couchResponse.warnings) {
                if (this.sqlWarning != null) {
                    this.sqlWarning = new SQLWarning(warning.msg, null, warning.code);
                    continue;
                }
                this.sqlWarning.setNextWarning(new SQLWarning(warning.msg, null, warning.code));
            }
        }
        Integer iStatus = statusStrings.get(couchResponse.status);
        switch (status) {
            case 200: {
                String message;
                switch (iStatus) {
                    case -1: {
                        List<CouchError> errors = couchResponse.errors;
                        throw new SQLException(errors.get((int)0).msg);
                    }
                    case 0: {
                        return couchResponse;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        message = "Invalid Status";
                        this.fillSQLException(message, couchResponse);
                    }
                }
                logger.error("Unexpected status string {} for query {}", (Object)couchResponse.status, (Object)sql);
                throw new SQLException("Unexpected status: " + couchResponse.status);
            }
            case 400: {
                String message = "Bad Request";
                this.fillSQLException(message, couchResponse);
            }
            case 401: {
                String message = "Unauthorized Request credentials are missing or invalid";
                this.fillSQLException(message, couchResponse);
            }
            case 403: {
                String message = "Forbidden Request: read only violation or client unauthorized to modify";
                this.fillSQLException(message, couchResponse);
            }
            case 404: {
                String message = "Not found: Request references an invalid keyspace or there is no primary key";
                this.fillSQLException(message, couchResponse);
            }
            case 405: {
                String message = "Method not allowed: The REST method type in request is supported";
                this.fillSQLException(message, couchResponse);
            }
            case 409: {
                String message = "Conflict: attempt to create a keyspace or index that already exists";
                this.fillSQLException(message, couchResponse);
            }
            case 410: {
                String message = "Gone: The server is doing a graceful shutdown";
                this.fillSQLException(message, couchResponse);
            }
            case 500: {
                String message = "Internal server error: unforeseen problem processing the request";
                this.fillSQLException(message, couchResponse);
            }
            case 503: {
                String message = "Service Unavailable: there is an issue preventing the request from being serviced";
                logger.debug("Error with the request {}", (Object)message);
                if (couchResponse.metrics.errorCount > 0L) {
                    CouchError errors = couchResponse.errors.get(0);
                    logger.error("Error Code: {} Message: {} for query {} ", errors.code, errors.msg, sql);
                }
                if (couchResponse.metrics.warningCount > 0L) {
                    CouchError warnings = couchResponse.warnings.get(0);
                    logger.error("Warning Code: {} Message: {} for query {}", warnings.code, warnings.msg, sql);
                }
                this.fillSQLException(message, couchResponse);
            }
        }
        throw new ClientProtocolException("Unexpected response status: " + status);
    }

    private void fillSQLException(String msg, CouchResponse response) throws SQLException {
        CouchError error;
        if (response.metrics.errorCount > 0L) {
            error = response.errors.get(0);
        } else if (response.metrics.warningCount > 0L) {
            error = response.errors.get(0);
        } else {
            throw new SQLException(msg);
        }
        throw new SQLException(error.msg, null, error.code);
    }

    @Override
    public CouchResponse doQuery(String query, Map queryParameters) throws SQLException {
        Instance endPoint = this.getNextEndpoint();
        while (true) {
            try {
                String url = endPoint.getEndpointURL(this.ssl);
                logger.trace("Using endpoint {}", (Object)url);
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Accept", "application/json");
                logger.trace("do query {}", (Object)httpPost.toString());
                this.addOptions(queryParameters);
                String jsonParameters = JsonFactory.toJson(queryParameters);
                StringEntity entity = new StringEntity(jsonParameters, ContentType.APPLICATION_JSON);
                httpPost.setEntity(entity);
                CloseableHttpResponse response = this.httpClient.execute(httpPost);
                return this.handleResponse(query, response);
            }
            catch (ConnectTimeoutException cte) {
                logger.trace(cte.getLocalizedMessage());
                this.invalidateEndpoint(endPoint);
                if ((endPoint = this.getNextEndpoint()) != null) continue;
                throw new SQLException("All endpoints have failed, giving up");
            }
            catch (Exception ex) {
                logger.error("Error executing query [{}] {}", (Object)query, (Object)ex.getMessage());
                throw new SQLException("Error executing update", ex);
            }
            break;
        }
    }

    @Override
    public boolean execute(CBStatement statement, String query) throws SQLException {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(STATEMENT, query);
            CouchResponse response = this.doQuery(query, parameters);
            this.updateCount = response.metrics.mutationCount;
            if (this.updateCount > 0L) {
                return false;
            }
            if (response.metrics.resultCount == 0L) {
                return false;
            }
            this.resultSet = new CBResultSet(statement, response);
            return true;
        }
        catch (Exception ex) {
            logger.error("Error executing update query {} {}", (Object)query, (Object)ex.getMessage());
            throw new SQLException("Error executing update", ex.getCause());
        }
    }

    @Override
    public CouchResponse prepareStatement(String sql, String[] returning) throws SQLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (returning != null) {
            sql = sql + " RETURNING ";
            int i = 0;
            while (i < returning.length) {
                sql = sql + returning[i++];
                if (i >= returning.length) continue;
                sql = sql + ',';
            }
        }
        parameters.put(STATEMENT, "prepare " + sql);
        return this.doQuery(sql, parameters);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        block13: {
            try {
                Instance instance = this.getNextEndpoint();
                String url = instance.getEndpointURL(this.ssl);
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Accept", "application/json");
                HashMap<String, String> parameters = new HashMap<String, String>();
                this.addOptions(parameters);
                for (String query : this.batchStatements) {
                    parameters.put(STATEMENT, query);
                }
                CloseableHttpResponse response = this.httpClient.execute(httpPost);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    ObjectMapper mapper = JsonFactory.create();
                    Map jsonObject = (Map)mapper.fromJson(EntityUtils.toString(entity));
                    String statusString = (String)jsonObject.get("status");
                    if (statusString.equals("errors")) {
                        List errors = (List)jsonObject.get("errors");
                        Map error = (Map)errors.get(0);
                        throw new SQLException((String)error.get("msg"));
                    }
                    if (statusString.equals("success")) {
                        Map metrics = (Map)jsonObject.get("metrics");
                        if (metrics.containsKey("mutationCount")) {
                            this.updateCount = ((Integer)metrics.get("mutationCount")).intValue();
                            return new int[0];
                        }
                        if (metrics.containsKey("resultCount")) {
                            return new int[0];
                        }
                        break block13;
                    }
                    if (statusString.equals("running")) {
                        return new int[0];
                    }
                    if (statusString.equals("completed")) {
                        return new int[0];
                    }
                    if (statusString.equals("stopped")) {
                        return new int[0];
                    }
                    if (statusString.equals(TIMEOUT)) {
                        return new int[0];
                    }
                    if (statusString.equals("fatal")) {
                        return new int[0];
                    }
                    throw new SQLException("Unexpected status: " + statusString);
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
            catch (Exception ex) {
                throw new SQLException("Error executing update", ex.getCause());
            }
        }
        return new int[0];
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.batchStatements.add(query);
    }

    @Override
    public void clearBatch() {
        this.batchStatements.clear();
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public CBResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void setConnectionTimeout(String timeout) {
        if (timeout != null) {
            this.connectTimeout = Integer.parseInt(timeout);
        }
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarning() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (schema != null && schema.compareToIgnoreCase("system") == 0) {
            schema = '#' + schema;
        }
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.schema != null && this.schema.startsWith("#")) {
            return this.schema.substring(1);
        }
        return this.schema;
    }

    private void addOptions(Map parameters) {
        parameters.put(ENCODING, "UTF-8");
        if (this.schema != null) {
            parameters.put(NAMESPACE, this.schema);
        }
        if (this.readOnly) {
            parameters.put(READ_ONLY, true);
        }
        if (this.queryTimeout != 0) {
            parameters.put(TIMEOUT, "" + this.queryTimeout + 's');
        }
        if (this.credentials != null) {
            parameters.put(CREDENTIALS, this.credentials);
        }
        parameters.put(SCAN_CONSITENCY, this.scanConsistency);
    }

    @Override
    public boolean isValid(int timeout) {
        String query = "select 1";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(STATEMENT, query);
        try {
            CouchResponse response = this.doQuery(query, parameters);
            return response.getMetrics().getResultCount() == 1L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Cluster getCluster() {
        Cluster ret = null;
        while (this.clusterSynch.getAndSet(false)) {
        }
        ret = this.cluster;
        this.clusterSynch.set(true);
        return ret;
    }

    public void setCluster(Cluster cluster) {
        while (this.clusterSynch.getAndSet(false)) {
        }
        this.cluster = cluster;
        this.clusterSynch.set(true);
    }

    public Instance getNextEndpoint() {
        Instance instance = null;
        while (this.clusterSynch.getAndSet(false)) {
        }
        instance = this.cluster.getNextEndpoint();
        this.clusterSynch.set(true);
        return instance;
    }

    public void invalidateEndpoint(Instance instance) {
        while (this.clusterSynch.getAndSet(false)) {
        }
        this.cluster.invalidateEndpoint(instance);
        this.clusterSynch.set(true);
    }

    @Override
    public void pollCluster() throws SQLException {
        HttpGet httpGet = new HttpGet(this.url + "/admin/clusters/default/nodes");
        httpGet.setHeader("Accept", "application/json");
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute(httpGet);
            this.setCluster(this.handleClusterResponse(httpResponse));
        }
        catch (Exception ex) {
            logger.error("Error opening connection {}", (Object)ex.getMessage());
            throw new SQLException("Error getting cluster response", ex);
        }
    }

    static {
        statusStrings.put("errors", -1);
        statusStrings.put("success", 0);
        statusStrings.put("running", 1);
        statusStrings.put("completed", 2);
        statusStrings.put("stopped", 3);
        statusStrings.put(TIMEOUT, 4);
        statusStrings.put("fatal", 5);
        logger = LoggerFactory.getLogger(ProtocolImpl.class);
    }
}

