/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc.core;

import com.couchbase.jdbc.core.Field;
import com.couchbase.jdbc.util.JSONTypes;
import com.couchbase.jdbc.util.TimestampUtils;
import com.couchbase.json.SQLJSON;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.core.reflection.MapperSimple;
import org.boon.core.value.ValueList;
import org.boon.json.JsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlJsonImplementation
implements SQLJSON {
    private static final Logger logger = LoggerFactory.getLogger(SqlJsonImplementation.class);
    Field field;
    Object jsonObject;
    String sqlJson;
    boolean isNull = false;
    TimestampUtils timestampUtils = new TimestampUtils();

    public SqlJsonImplementation() {
    }

    public SqlJsonImplementation(Object jsonObject, Field field) {
        this.jsonObject = jsonObject;
        if (jsonObject instanceof String) {
            field.setType("string");
        } else if (jsonObject instanceof Number) {
            field.setType("number");
        } else if (jsonObject instanceof Boolean) {
            field.setType("boolean");
        } else if (jsonObject instanceof List) {
            field.setType("array");
        } else {
            field.setType("json");
        }
        this.field = field;
    }

    @Override
    public void free() {
    }

    private synchronized void toJson() {
        if (this.sqlJson == null) {
            this.sqlJson = JsonFactory.toJson(this.jsonObject);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.toJson();
        try {
            return new ByteArrayInputStream(this.sqlJson.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Error Encoding", ex);
            return null;
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.toJson();
        return new StringReader(this.sqlJson);
    }

    @Override
    public String getString() throws SQLException {
        int type = JSONTypes.jsonTypes.get(this.field.getType());
        switch (type) {
            case 3: 
            case 4: 
            case 5: {
                this.toJson();
                return this.sqlJson;
            }
            case 6: {
                return null;
            }
            case 1: {
                if (this.sqlJson != null) {
                    return this.sqlJson;
                }
                if (this.jsonObject != null) {
                    return (String)this.jsonObject;
                }
                this.isNull = true;
                return null;
            }
            case 0: 
            case 2: {
                return this.jsonObject.toString();
            }
        }
        return "";
    }

    @Override
    public void setString(String str) throws SQLException {
        this.field = new Field(null, "string");
        if (str == null) {
            this.isNull = true;
        }
        this.jsonObject = str;
    }

    @Override
    public void setBinaryStream() throws SQLException {
    }

    @Override
    public void setCharacterStream(Reader stream) throws SQLException {
    }

    @Override
    public boolean getBoolean() throws SQLException {
        int type = JSONTypes.jsonTypes.get(this.field.getType());
        switch (type) {
            case 2: {
                return (Boolean)this.jsonObject;
            }
            case 0: {
                Number number = (Number)this.jsonObject;
                return !number.equals(0);
            }
            case 1: {
                String string = (String)this.jsonObject;
                return !string.isEmpty();
            }
            case 4: 
            case 5: {
                Map map = (Map)this.jsonObject;
                return !map.isEmpty();
            }
            case 3: {
                List list = (List)this.jsonObject;
                return !list.isEmpty();
            }
        }
        return false;
    }

    @Override
    public void setBoolean(boolean val) throws SQLException {
        this.field = new Field(null, "boolean");
        this.jsonObject = val;
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0;
        }
        if (this.jsonObject instanceof Integer) {
            return ((Integer)this.jsonObject).byteValue();
        }
        if (this.jsonObject instanceof Long) {
            return ((Long)this.jsonObject).byteValue();
        }
        if (this.jsonObject instanceof Short) {
            return ((Short)this.jsonObject).byteValue();
        }
        if (this.jsonObject instanceof Byte) {
            return (Byte)this.jsonObject;
        }
        if (this.jsonObject instanceof Double) {
            return ((Double)this.jsonObject).byteValue();
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0;
    }

    @Override
    public void setByte(byte val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = (long)val;
    }

    @Override
    public short getShort() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0;
        }
        if (this.jsonObject instanceof Integer) {
            return ((Integer)this.jsonObject).shortValue();
        }
        if (this.jsonObject instanceof Long) {
            return ((Long)this.jsonObject).shortValue();
        }
        if (this.jsonObject instanceof Short) {
            return (Short)this.jsonObject;
        }
        if (this.jsonObject instanceof Byte) {
            return ((Byte)this.jsonObject).shortValue();
        }
        if (this.jsonObject instanceof Double) {
            return ((Double)this.jsonObject).shortValue();
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0;
    }

    @Override
    public void setShort(short val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = (long)val;
    }

    @Override
    public int getInt() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0;
        }
        if (this.jsonObject instanceof Integer) {
            return (Integer)this.jsonObject;
        }
        if (this.jsonObject instanceof Long) {
            return ((Long)this.jsonObject).intValue();
        }
        if (this.jsonObject instanceof Short) {
            return ((Short)this.jsonObject).intValue();
        }
        if (this.jsonObject instanceof Byte) {
            return ((Byte)this.jsonObject).intValue();
        }
        if (this.jsonObject instanceof Double) {
            return ((Double)this.jsonObject).intValue();
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0;
    }

    @Override
    public void setInt(int val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = (long)val;
    }

    @Override
    public long getLong() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0L;
        }
        if (this.jsonObject instanceof Integer) {
            return ((Integer)this.jsonObject).longValue();
        }
        if (this.jsonObject instanceof Long) {
            return (Long)this.jsonObject;
        }
        if (this.jsonObject instanceof Short) {
            return ((Short)this.jsonObject).longValue();
        }
        if (this.jsonObject instanceof Byte) {
            return ((Byte)this.jsonObject).longValue();
        }
        if (this.jsonObject instanceof Double) {
            return ((Double)this.jsonObject).longValue();
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0L;
    }

    @Override
    public void setLong(long val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = val;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return null;
        }
        if (this.jsonObject instanceof Integer) {
            return new BigDecimal((Integer)this.jsonObject);
        }
        if (this.jsonObject instanceof Long) {
            return new BigDecimal((Long)this.jsonObject);
        }
        if (this.jsonObject instanceof Short) {
            return new BigDecimal(((Short)this.jsonObject).shortValue());
        }
        if (this.jsonObject instanceof Byte) {
            return new BigDecimal(((Byte)this.jsonObject).byteValue());
        }
        if (this.jsonObject instanceof Double) {
            return BigDecimal.valueOf((Double)this.jsonObject);
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return null;
    }

    @Override
    public void setBigDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.field = new Field(null, "null");
            this.isNull = true;
        } else {
            this.field = new Field(null, "number");
        }
        this.jsonObject = val;
    }

    @Override
    public void setFloat(float val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = Float.valueOf(val);
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0.0f;
        }
        if (this.jsonObject instanceof Integer) {
            return ((Integer)this.jsonObject).intValue();
        }
        if (this.jsonObject instanceof Long) {
            return ((Long)this.jsonObject).longValue();
        }
        if (this.jsonObject instanceof Short) {
            return new Float(((Short)this.jsonObject).shortValue()).floatValue();
        }
        if (this.jsonObject instanceof Byte) {
            return ((Byte)this.jsonObject).byteValue();
        }
        if (this.jsonObject instanceof Double) {
            return ((Double)this.jsonObject).floatValue();
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0.0f;
    }

    @Override
    public void setDouble(double val) throws SQLException {
        this.field = new Field(null, "number");
        this.jsonObject = val;
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return 0.0;
        }
        if (this.jsonObject instanceof Integer) {
            return ((Integer)this.jsonObject).intValue();
        }
        if (this.jsonObject instanceof Long) {
            return ((Long)this.jsonObject).longValue();
        }
        if (this.jsonObject instanceof Short) {
            return new Double(((Short)this.jsonObject).shortValue());
        }
        if (this.jsonObject instanceof Byte) {
            return ((Byte)this.jsonObject).byteValue();
        }
        if (this.jsonObject instanceof Double) {
            return (Double)this.jsonObject;
        }
        if (!(this.jsonObject instanceof Number)) {
            throw new SQLException("value " + this.jsonObject + " not a number");
        }
        return 0.0;
    }

    @Override
    public void setBytes(byte[] val) throws SQLException {
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return new byte[0];
    }

    @Override
    public void setDate(Date val, Calendar cal) throws SQLException {
        this.field = new Field(null, "string");
        if (val == null) {
            this.jsonObject = null;
            this.isNull = true;
        } else {
            if (cal != null) {
                cal = (Calendar)cal.clone();
            }
            this.jsonObject = this.timestampUtils.toString(cal, val);
        }
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        Date date = null;
        if (this.jsonObject == null) {
            this.isNull = true;
            return null;
        }
        try {
            if (this.jsonObject instanceof String) {
                date = this.timestampUtils.parse((String)this.jsonObject);
            }
            if (this.jsonObject instanceof Date) {
                date = (Date)this.jsonObject;
            }
            if (this.jsonObject instanceof java.util.Date) {
                date = new Date(((java.util.Date)this.jsonObject).getTime());
            }
        }
        catch (Exception ex) {
            throw new SQLException("value " + this.jsonObject + " is not a date");
        }
        if (cal != null) {
            date = this.timestampUtils.applyCalendar(cal, date);
        }
        return date;
    }

    @Override
    public void setTime(Time val, Calendar cal) throws SQLException {
        this.field = new Field(null, "string");
        if (val == null) {
            this.jsonObject = null;
            this.isNull = true;
        } else {
            if (cal != null) {
                cal = (Calendar)cal.clone();
            }
            this.jsonObject = this.timestampUtils.toString(cal, val);
        }
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        Time time;
        if (this.jsonObject == null) {
            return null;
        }
        try {
            time = this.timestampUtils.parseTime((String)this.jsonObject);
        }
        catch (Exception ex) {
            throw new SQLException("value " + this.jsonObject + " is not a Time", ex);
        }
        if (cal != null) {
            time = this.timestampUtils.applyCalendar(cal, time);
        }
        return time;
    }

    @Override
    public void setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        this.field = new Field(null, "string");
        if (val == null) {
            this.jsonObject = null;
            this.isNull = true;
        } else {
            if (cal != null) {
                cal = (Calendar)cal.clone();
            }
            this.jsonObject = this.timestampUtils.toString(cal, val);
        }
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        Timestamp ts;
        block6: {
            if (this.jsonObject == null) {
                this.isNull = true;
                return null;
            }
            try {
                if (this.jsonObject instanceof java.util.Date || this.jsonObject instanceof Date) {
                    ts = new Timestamp(((java.util.Date)this.jsonObject).getTime());
                    break block6;
                }
                if (this.jsonObject instanceof String) {
                    ts = this.timestampUtils.parseTimestamp((String)this.jsonObject);
                    break block6;
                }
                throw new SQLException("value " + this.jsonObject + " is not a Timestamp");
            }
            catch (Exception ex) {
                throw new SQLException("value " + this.jsonObject + "is not a Timestamp", ex);
            }
        }
        if (cal != null) {
            ts = this.timestampUtils.applyCalendar(cal, ts);
        }
        return ts;
    }

    @Override
    public Map getMap() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return null;
        }
        if (this.jsonObject instanceof Map) {
            return (Map)this.jsonObject;
        }
        throw new SQLException("Value " + this.jsonObject + " is not a map");
    }

    @Override
    public void setMap(Map map) throws SQLException {
        if (map == null) {
            this.field = new Field(null, "null");
            this.isNull = true;
        } else {
            this.field = new Field(null, "map");
        }
        this.jsonObject = map;
    }

    @Override
    public List getArray() throws SQLException {
        if (this.jsonObject == null) {
            this.isNull = true;
            return null;
        }
        if (this.jsonObject instanceof List) {
            return (List)this.jsonObject;
        }
        return null;
    }

    @Override
    public void setArray(List array) throws SQLException {
        if (array == null) {
            this.field = new Field(null, "null");
            this.isNull = true;
        } else {
            this.field = new Field(null, "array");
        }
        this.jsonObject = array;
    }

    @Override
    public void setArray(Object[] array) throws SQLException {
        if (array == null) {
            this.field = new Field(null, "null");
            this.isNull = true;
        } else {
            this.field = new Field(null, "array");
        }
        this.jsonObject = array;
    }

    @Override
    public Object getObject() throws SQLException {
        switch (this.field.getSqlType()) {
            case 2: 
            case 16: {
                return this.jsonObject;
            }
            case 12: {
                Object object = this.jsonObject;
                if (object instanceof java.util.Date) {
                    return new Date(((java.util.Date)object).getTime());
                }
                return object;
            }
            case 2000: 
            case 2003: {
                return this.jsonObject;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void setObject(Object x) throws SQLException {
        if (x == null) {
            this.field = new Field(null, "null");
            this.isNull = true;
        } else if (x instanceof String) {
            this.setString((String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal((BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort((Short)x);
        } else if (x instanceof Integer) {
            this.setInt((Integer)x);
        } else if (x instanceof Long) {
            this.setLong((Long)x);
        } else if (x instanceof Float) {
            this.setFloat(((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble((Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes((byte[])x);
        } else if (x instanceof Date) {
            this.setDate((Date)x, null);
        } else if (x instanceof Time) {
            this.setTime((Time)x, null);
        } else if (x instanceof Timestamp) {
            this.setTimestamp((Timestamp)x, null);
        } else if (x instanceof Boolean) {
            this.setBoolean((Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte((Byte)x);
        } else if (x instanceof Character) {
            this.setString(x.toString());
        } else if (x instanceof List) {
            this.setArray((List)x);
        } else if (x instanceof Object[]) {
            this.setArray((Object[])x);
        } else if (x.getClass().isArray()) {
            List list = SqlJsonImplementation.asList(x);
            this.setArray(list);
        } else if (x instanceof Map) {
            this.setMap((Map)x);
        } else {
            throw new SQLException("Can''t infer the SQL type to use for an instance of " + x + ". Use setObject() with an explicit Types value to specify the type to use.");
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        if (!(this.jsonObject instanceof Map)) {
            throw new SQLException("Object is not a json object");
        }
        return ((Map)this.jsonObject).get(columnName);
    }

    @Override
    public void setObject(String columnName, Object val) throws SQLException {
        if (!(this.jsonObject instanceof Map)) {
            throw new SQLException("Object is not a json object");
        }
        ((Map)this.jsonObject).put(columnName, val);
    }

    @Override
    public Object get(int index) {
        if (!(this.jsonObject instanceof List)) {
            return null;
        }
        return ((List)this.jsonObject).get(index);
    }

    @Override
    public void set(int index, Object object) throws SQLException {
        if (!(this.jsonObject instanceof List)) {
            throw new SQLException("SQLJSON object is not a list");
        }
        List<Object> backingList = ((ValueList)this.jsonObject).list();
        backingList.set(index, object);
    }

    @Override
    public boolean isNull() throws SQLException {
        return this.isNull;
    }

    public static <T> List<T> asList(final Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return Array.get(array, index);
            }

            @Override
            public int size() {
                return Array.getLength(array);
            }
        };
    }

    @Override
    public int getJDBCType() {
        return JSONTypes.jdbcTypes.get(this.field.getType());
    }

    @Override
    public Object parse(Class clazz) {
        MapperSimple mapper = new MapperSimple();
        mapper.fromMap((Map)this.jsonObject, clazz);
        return null;
    }

    @Override
    public Map parse() {
        if (this.field.getType().compareTo("json") == 0 || this.field.getType().startsWith("{")) {
            if (this.jsonObject instanceof String) {
                logger.debug("json object is string " + this.jsonObject);
                return null;
            }
            return (Map)this.jsonObject;
        }
        return null;
    }

    @Override
    public Object parameterValue() {
        return this.jsonObject;
    }

    public int getLength() {
        return this.sqlJson.length();
    }

    @Override
    public int compareTo(SQLJSON obj) {
        int i;
        SqlJsonImplementation sqljson = (SqlJsonImplementation)obj;
        int deltaLength = this.getLength() - sqljson.getLength();
        if (deltaLength != 0) {
            return deltaLength;
        }
        if (this.jsonObject instanceof Map && sqljson.jsonObject instanceof Map) {
            Set combinedKeys = ((Map)this.jsonObject).keySet();
            combinedKeys.addAll(((Map)sqljson.jsonObject).keySet());
            ArrayList sorted = new ArrayList(combinedKeys);
            Collections.sort(sorted);
            Iterator iterator = sorted.iterator();
            if (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (!((Map)this.jsonObject).containsKey(name)) {
                    return 1;
                }
                if (!((Map)sqljson.jsonObject).containsKey(name)) {
                    return -1;
                }
                Object obj1 = ((Map)this.jsonObject).get(name);
                Object obj2 = ((Map)sqljson.jsonObject).get(name);
                return this.compare(obj1, obj2);
            }
            return 0;
        }
        if (this.jsonObject instanceof List && sqljson.jsonObject instanceof List && (i = 0) < ((List)this.jsonObject).size()) {
            Object obj1 = ((List)this.jsonObject).get(i);
            Object obj2 = ((List)sqljson.jsonObject).get(i);
            return this.compare(obj1, obj2);
        }
        return 0;
    }

    private int compare(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1.getClass().isInstance(obj2)) {
            if (obj1 instanceof String) {
                return ((String)obj1).compareTo((String)obj2);
            }
            if (obj1 instanceof Boolean) {
                if (obj1 == obj2) {
                    return 0;
                }
                if (obj1 == Boolean.TRUE) {
                    return 1;
                }
                return -1;
            }
            if (obj1 instanceof java.util.Date) {
                return ((java.util.Date)obj1).compareTo((Date)obj2);
            }
            if (obj1 instanceof Number) {
                double number2;
                double number1 = ((Number)obj1).doubleValue();
                if (number1 == (number2 = ((Number)obj2).doubleValue())) {
                    return 0;
                }
                return number1 > number2 ? 1 : -1;
            }
        }
        logger.debug("should not get here");
        return 0;
    }
}

