/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc.util;

import com.couchbase.jdbc.core.CouchBaseSQLException;
import com.couchbase.jdbc.core.EscapedFunctions;
import com.couchbase.jdbc.core.Parser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlParser {
    final ArrayList statementList = new ArrayList();
    final ArrayList<String> fragmentList = new ArrayList(15);
    String query;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short IN_IDENTIFIER = 6;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private static final short ESC_ESCAPECHAR = 7;

    public SqlParser(String sql) {
        this.query = sql;
    }

    public int getNumFields() {
        return this.fragmentList.size() - 1;
    }

    public void parse() {
        int parameterIndex = 1;
        int fragmentStart = 0;
        int inParen = 0;
        char[] aChars = this.query.toCharArray();
        block11: for (int i = 0; i < aChars.length; ++i) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i);
                    continue block11;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    continue block11;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    continue block11;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    continue block11;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    continue block11;
                }
                case '(': {
                    ++inParen;
                    continue block11;
                }
                case ')': {
                    --inParen;
                    continue block11;
                }
                case '?': {
                    this.fragmentList.add(this.query.substring(fragmentStart, i) + "$" + parameterIndex++);
                    fragmentStart = i + 1;
                    continue block11;
                }
                case ';': {
                    if (inParen != 0) continue block11;
                    this.fragmentList.add(this.query.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    if (this.fragmentList.size() > 1 || this.fragmentList.get(0).trim().length() > 0) {
                        this.statementList.add(this.fragmentList.toArray(new String[this.fragmentList.size()]));
                    }
                    this.fragmentList.clear();
                    continue block11;
                }
            }
        }
        this.fragmentList.add(this.query.substring(fragmentStart));
    }

    public String replaceProcessing(String p_sql, boolean replaceProcessingEnabled) throws SQLException {
        if (replaceProcessingEnabled) {
            int len = p_sql.length();
            StringBuilder newsql = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                if ((i = this.parseSql(p_sql, i, newsql, false)) >= len) continue;
                newsql.append(p_sql.charAt(i));
                ++i;
            }
            return newsql.toString();
        }
        return p_sql;
    }

    protected int parseSql(String p_sql, int i, StringBuilder newsql, boolean stopOnComma) throws SQLException {
        int state = 0;
        int len = p_sql.length();
        int nestedParenthesis = 0;
        boolean endOfNested = false;
        --i;
        while (!endOfNested && ++i < len) {
            char c = p_sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                    } else if (c == '\"') {
                        state = 6;
                    } else if (c == '(') {
                        ++nestedParenthesis;
                    } else if (c == ')') {
                        if (--nestedParenthesis < 0) {
                            endOfNested = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && c == ',' && nestedParenthesis == 0) {
                            endOfNested = true;
                            break;
                        }
                        if (c == '{' && i + 1 < len) {
                            char nextnext;
                            char next = p_sql.charAt(i + 1);
                            char c2 = nextnext = i + 2 < len ? p_sql.charAt(i + 2) : (char)'\u0000';
                            if (next == 'd' || next == 'D') {
                                state = 3;
                                ++i;
                                newsql.append("DATE ");
                                break;
                            }
                            if (next == 't' || next == 'T') {
                                state = 3;
                                if (nextnext == 's' || nextnext == 'S') {
                                    i += 2;
                                    break;
                                }
                                ++i;
                                break;
                            }
                            if (next == 'f' || next == 'F') {
                                state = 4;
                                i += nextnext == 'n' || nextnext == 'N' ? 2 : 1;
                                break;
                            }
                            if (next == 'o' || next == 'O') {
                                state = 5;
                                i += nextnext == 'j' || nextnext == 'J' ? 2 : 1;
                                break;
                            }
                            if (next == 'e' || next == 'E') {
                                state = 7;
                                break;
                            }
                        }
                    }
                    newsql.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        state = 0;
                    } else if (c == '\\') {
                        state = 2;
                    }
                    newsql.append(c);
                    break;
                }
                case 6: {
                    if (c == '\"') {
                        state = 0;
                    }
                    newsql.append(c);
                    break;
                }
                case 2: {
                    state = 1;
                    newsql.append(c);
                    break;
                }
                case 4: {
                    int posArgs = p_sql.indexOf(40, i);
                    if (posArgs != -1) {
                        String functionName = p_sql.substring(i, posArgs).trim();
                        i = posArgs + 1;
                        StringBuilder args = new StringBuilder();
                        i = this.parseSql(p_sql, i, args, false);
                        newsql.append(this.escapeFunction(functionName, args.toString()));
                    }
                    ++i;
                    while (i < len && p_sql.charAt(i) != '}') {
                        newsql.append(p_sql.charAt(i++));
                    }
                    state = 0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (c == '}') {
                        state = 0;
                        break;
                    }
                    newsql.append(c);
                }
            }
        }
        return i;
    }

    protected String escapeFunction(String functionName, String args) throws SQLException {
        int len = args.length();
        ArrayList<StringBuilder> parsedArgs = new ArrayList<StringBuilder>();
        for (int i = 0; i < len; ++i) {
            int lastPos = i;
            StringBuilder arg = new StringBuilder();
            if (lastPos == (i = this.parseSql(args, i, arg, true))) continue;
            parsedArgs.add(arg);
        }
        try {
            Method escapeMethod = EscapedFunctions.getFunction(functionName);
            return (String)escapeMethod.invoke(null, parsedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new CouchBaseSQLException(e.getTargetException().getMessage());
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            buf.append(functionName).append('(');
            for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
                buf.append(parsedArgs.get(iArg));
                if (iArg == parsedArgs.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.fragmentList == null) {
            return "";
        }
        for (String fragment : this.fragmentList) {
            sbuf.append(fragment);
        }
        return sbuf.toString();
    }
}

