/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jdbc.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimestampUtils {
    private StringBuffer sbuf = new StringBuffer();
    private Calendar defaultCal = new GregorianCalendar();
    private final TimeZone defaultTz = this.defaultCal.getTimeZone();
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat tsf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public synchronized String toString(Calendar cal, Timestamp x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        TimestampUtils.appendDate(this.sbuf, cal);
        this.sbuf.append(' ');
        TimestampUtils.appendTime(this.sbuf, cal, x.getNanos());
        this.appendTimeZone(this.sbuf, cal);
        TimestampUtils.appendEra(this.sbuf, cal);
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar cal, Time x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        TimestampUtils.appendTime(this.sbuf, cal, cal.get(14) * 1000000);
        this.appendTimeZone(this.sbuf, cal);
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar cal, Date x) {
        if (cal == null) {
            cal = this.defaultCal;
        }
        cal.setTime(x);
        this.sbuf.setLength(0);
        TimestampUtils.appendDate(this.sbuf, cal);
        TimestampUtils.appendEra(this.sbuf, cal);
        this.appendTimeZone(this.sbuf, cal);
        return this.sbuf.toString();
    }

    public synchronized Date parse(String string) throws Exception {
        return new Date(df.parse(string).getTime());
    }

    public synchronized Time parseTime(String string) throws Exception {
        return new Time(tf.parse(string).getTime());
    }

    public synchronized Timestamp parseTimestamp(String json) throws Exception {
        Timestamp ts = new Timestamp(tsf.parse(json).getTime());
        String[] parts = json.split("(\\.)|( )");
        if (parts.length > 2) {
            int nanos = Integer.parseInt(parts[2]);
            for (int numlength = parts[2].length(); numlength < 9; ++numlength) {
                nanos *= 10;
            }
            ts.setNanos(nanos);
        }
        return ts;
    }

    public Time applyCalendar(Calendar cal, Time time) {
        if (!cal.getTimeZone().hasSameRules(tf.getTimeZone())) {
            Calendar convertCal = Calendar.getInstance();
            convertCal.setTime(time);
            TimeZone toTimeZone = cal.getTimeZone();
            TimeZone fromTimeZone = tf.getTimeZone();
            convertCal.setTimeZone(fromTimeZone);
            convertCal.add(14, fromTimeZone.getRawOffset() * -1);
            if (fromTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, convertCal.getTimeZone().getDSTSavings() * -1);
            }
            convertCal.add(14, toTimeZone.getRawOffset());
            if (toTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, toTimeZone.getDSTSavings());
            }
            return new Time(convertCal.getTime().getTime());
        }
        return time;
    }

    public Date applyCalendar(Calendar cal, Date date) {
        if (!cal.getTimeZone().hasSameRules(df.getTimeZone())) {
            Calendar convertCal = Calendar.getInstance();
            convertCal.setTime(date);
            TimeZone toTimeZone = cal.getTimeZone();
            TimeZone fromTimeZone = df.getTimeZone();
            convertCal.setTimeZone(fromTimeZone);
            convertCal.add(14, fromTimeZone.getRawOffset() * -1);
            if (fromTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, convertCal.getTimeZone().getDSTSavings() * -1);
            }
            convertCal.add(14, toTimeZone.getRawOffset());
            if (toTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, toTimeZone.getDSTSavings());
            }
            return new Date(convertCal.getTime().getTime());
        }
        return date;
    }

    public Timestamp applyCalendar(Calendar cal, Timestamp timestamp) {
        if (!cal.getTimeZone().hasSameRules(tsf.getTimeZone())) {
            Calendar convertCal = Calendar.getInstance();
            convertCal.setTime(timestamp);
            TimeZone toTimeZone = cal.getTimeZone();
            TimeZone fromTimeZone = tsf.getTimeZone();
            convertCal.setTimeZone(fromTimeZone);
            convertCal.add(14, fromTimeZone.getRawOffset() * -1);
            if (fromTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, convertCal.getTimeZone().getDSTSavings() * -1);
            }
            convertCal.add(14, toTimeZone.getRawOffset());
            if (toTimeZone.inDaylightTime(convertCal.getTime())) {
                convertCal.add(14, toTimeZone.getDSTSavings());
            }
            return new Timestamp(convertCal.getTime().getTime());
        }
        return timestamp;
    }

    private static void appendDate(StringBuffer sb, Calendar cal) {
        int l_year = cal.get(1);
        int l_yearlen = String.valueOf(l_year).length();
        for (int i = 4; i > l_yearlen; --i) {
            sb.append("0");
        }
        sb.append(l_year);
        sb.append('-');
        int l_month = cal.get(2) + 1;
        if (l_month < 10) {
            sb.append('0');
        }
        sb.append(l_month);
        sb.append('-');
        int l_day = cal.get(5);
        if (l_day < 10) {
            sb.append('0');
        }
        sb.append(l_day);
    }

    private static void appendTime(StringBuffer sb, Calendar cal, int nanos) {
        int hours = cal.get(11);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int minutes = cal.get(12);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        int seconds = cal.get(13);
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
        char[] decimalStr = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        char[] nanoStr = Integer.toString(nanos).toCharArray();
        System.arraycopy(nanoStr, 0, decimalStr, decimalStr.length - nanoStr.length, nanoStr.length);
        sb.append('.');
        sb.append(decimalStr, 0, 6);
    }

    private void appendTimeZone(StringBuffer sb, Calendar cal) {
        int offset = (cal.get(15) + cal.get(16)) / 1000;
        int absoff = Math.abs(offset);
        int hours = absoff / 60 / 60;
        int mins = (absoff - hours * 60 * 60) / 60;
        int secs = absoff - hours * 60 * 60 - mins * 60;
        sb.append(offset >= 0 ? " +" : " -");
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (mins < 10) {
            sb.append('0');
        }
        sb.append(mins);
        sb.append(':');
        if (secs < 10) {
            sb.append('0');
        }
        sb.append(secs);
    }

    private static void appendEra(StringBuffer sb, Calendar cal) {
        if (cal.get(0) == 0) {
            sb.append(" BC");
        }
    }
}

