/*
 * Decompiled with CFR 0.152.
 */
package org.boon.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.Pair;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MethodAccess;
import org.boon.expression.ExpressionContext;
import org.boon.expression.StandardFunctions;
import org.boon.json.JsonFactory;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.boon.primitive.Arry;

public class BoonExpressionContext
implements ExpressionContext {
    private LinkedList<Object> context;
    private BoonExpressionContext parent;
    private final JsonParserAndMapper jsonParser = new JsonParserFactory().lax().create();
    protected Map<String, MethodAccess> staticMethodMap = new HashMap<String, MethodAccess>(100);

    public BoonExpressionContext(List<Object> root) {
        this.context = new LinkedList();
        if (root != null) {
            this.context.add(root);
        }
        this.addFunctions("fn", StandardFunctions.class);
        this.parent = this;
    }

    @Override
    public void addFunctions(String prefix, Class<?> functions) {
        ClassMeta<?> funcs = ClassMeta.classMeta(functions);
        for (MethodAccess m : funcs.methods()) {
            if (!m.isStatic()) continue;
            String funcName = Str.add(prefix, ":", m.name());
            this.staticMethodMap.put(funcName, m);
        }
    }

    @Override
    public void initContext(Object ... array) {
        this.context = new LinkedList();
        if (array == null) {
            return;
        }
        for (Object root : array) {
            if (root == null) continue;
            if (root instanceof CharSequence) {
                String str = root.toString().trim();
                if (str.startsWith("[") || str.startsWith("{")) {
                    this.context.add(JsonFactory.fromJson(root.toString()));
                }
            } else {
                this.context.add(root);
            }
            this.parent = this;
        }
    }

    @Override
    public void addFunctions(Class<?> functionsClass) {
        ClassMeta<?> standardFunctionsClassMeta = ClassMeta.classMeta(functionsClass);
        for (MethodAccess m : standardFunctionsClassMeta.methods()) {
            if (!m.isStatic()) continue;
            String funcName = Str.add(m.name());
            this.staticMethodMap.put(funcName, m);
        }
    }

    public BoonExpressionContext(Object ... array) {
        this.context = new LinkedList();
        this.initContext(array);
        this.addFunctions("fn", StandardFunctions.class);
    }

    @Override
    public char idxChar(String property) {
        return Conversions.toChar(this.lookup(property));
    }

    Object findProperty(String propertyPath, boolean searchChildren) {
        String defaultValue;
        String formatRule = null;
        Object outputValue = null;
        if (propertyPath.indexOf(124) != -1) {
            String[] splitByPipe = Str.splitByPipe(propertyPath);
            defaultValue = splitByPipe[1];
            propertyPath = splitByPipe[0];
        } else {
            defaultValue = null;
        }
        if (propertyPath.indexOf(37) != -1) {
            String[] splitByPercentSign = StringScanner.split(propertyPath, '%', 1);
            formatRule = splitByPercentSign[1];
            propertyPath = splitByPercentSign[0];
        }
        for (Object e : this.context) {
            if (searchChildren && e instanceof BoonExpressionContext) {
                BoonExpressionContext basicContext = (BoonExpressionContext)e;
                outputValue = basicContext.findProperty(propertyPath, true);
                if (outputValue == null) continue;
                break;
            }
            if (e instanceof Pair) {
                Pair pair = (Pair)e;
                if (((String)pair.getKey()).equals(propertyPath)) {
                    outputValue = pair.getValue();
                    break;
                }
                if (!propertyPath.startsWith((String)pair.getKey())) continue;
                String subPath = StringScanner.substringAfter(propertyPath, (String)pair.getKey());
                Object o = pair.getValue();
                outputValue = BeanUtils.idx(o, subPath);
                break;
            }
            outputValue = BeanUtils.idx(e, propertyPath);
            if (outputValue == null) continue;
            break;
        }
        if (outputValue == null) {
            outputValue = defaultValue;
        }
        if (formatRule != null) {
            outputValue = this.applyFormatRule(formatRule, outputValue);
        }
        return outputValue;
    }

    private Object applyFormatRule(String formatRule, Object outputValue) {
        return String.format(Str.add("%", formatRule), outputValue);
    }

    @Override
    public byte idxByte(String property) {
        return Conversions.toByte(this.lookup(property));
    }

    @Override
    public short idxShort(String property) {
        return Conversions.toShort(this.lookup(property));
    }

    @Override
    public String idxString(String property) {
        return Conversions.toString(this.lookup(property));
    }

    @Override
    public int idxInt(String property) {
        return Conversions.toInt(this.lookup(property));
    }

    @Override
    public float idxFloat(String property) {
        return Conversions.toFloat(this.lookup(property));
    }

    @Override
    public double idxDouble(String property) {
        return Conversions.toDouble(this.lookup(property));
    }

    @Override
    public long idxLong(String property) {
        return Conversions.toLong(this.lookup(property));
    }

    @Override
    public Object idx(String property) {
        return this.lookup(property);
    }

    @Override
    public <T> T idx(Class<T> type, String property) {
        return (T)this.lookup(property);
    }

    public int size() {
        return this.context.size();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public Object get(Object key) {
        return this.lookup(key.toString());
    }

    @Override
    public void put(String key, Object value) {
        Pair<String, Object> pair = new Pair<String, Object>(key, value);
        this.context.add(0, pair);
    }

    @Override
    public Object lookup(String objectName) {
        return this.lookupWithDefault(objectName, objectName);
    }

    private Object doLookup(String objectExpression, Object defaultValue, boolean searchChildren) {
        Object value;
        if (Str.isEmpty(objectExpression)) {
            return defaultValue;
        }
        char firstChar = Str.idx(objectExpression, 0);
        char secondChar = Str.idx(objectExpression, 1);
        char lastChar = Str.idx(objectExpression, -1);
        boolean escape = false;
        switch (firstChar) {
            case '$': {
                if (lastChar == '}') {
                    objectExpression = Str.slc(objectExpression, 2, -1);
                    break;
                }
                objectExpression = Str.slc(objectExpression, 1);
                break;
            }
            case '{': {
                if (secondChar == '{' && lastChar == '}') {
                    char thirdChar = Str.idx(objectExpression, 2);
                    if (thirdChar == '{') {
                        escape = true;
                        objectExpression = Str.slc(objectExpression, 3, -3);
                        break;
                    }
                    objectExpression = Str.slc(objectExpression, 2, -2);
                    break;
                }
                if (lastChar == '}') {
                    return this.jsonParser.parse(objectExpression);
                }
                escape = true;
                objectExpression = Str.slc(objectExpression, 1);
                break;
            }
            case '[': {
                return this.jsonParser.parse(objectExpression);
            }
            case '.': {
                if (secondChar != '.') break;
                String newExp = Str.slc(objectExpression, 2);
                return this.parent.doLookup(newExp, newExp, false);
            }
        }
        lastChar = Str.idx(objectExpression, -1);
        if (lastChar == ')') {
            value = this.handleFunction(objectExpression, searchChildren);
        } else {
            value = this.findProperty(objectExpression, searchChildren);
            Object object = value = value == null ? defaultValue : value;
        }
        if (!escape) {
            return value;
        }
        return StandardFunctions.escapeXml(value);
    }

    @Override
    public Object lookupWithDefault(String objectExpression, Object defaultValue) {
        return this.doLookup(objectExpression, defaultValue, true);
    }

    private Object handleFunction(String functionCall, boolean searchChildren) {
        String[] split = StringScanner.split(functionCall, '(', 1);
        String methodName = split[0];
        String arguments = Str.slc(split[1], 0, -1);
        List<Object> args = this.getObjectFromArguments(arguments, searchChildren);
        MethodAccess method = this.staticMethodMap.get(methodName);
        if (method != null) {
            return method.invokeDynamic(null, Arry.objectArray(args));
        }
        return this.handleMethodCall(methodName, args);
    }

    private Object handleMethodCall(String objectPath, List<Object> args) {
        int lastIndexOf = objectPath.lastIndexOf(46);
        String beanPath = objectPath.substring(0, lastIndexOf);
        String methodName = objectPath.substring(lastIndexOf + 1, objectPath.length());
        Object bean = this.lookup(beanPath);
        if (bean == null) {
            return null;
        }
        Class<?> cls = Boon.cls(bean);
        if (cls == null) {
            return null;
        }
        ClassMeta<?> classMeta = ClassMeta.classMeta(cls);
        MethodAccess method = classMeta.method(methodName);
        if (method == null) {
            return null;
        }
        return method.invokeDynamic(bean, Arry.array(args));
    }

    protected List<Object> getObjectFromArguments(String arguments, boolean searchChildren) {
        String[] strings = StringScanner.splitByChars(arguments, ',');
        ArrayList<Object> list = new ArrayList<Object>();
        for (String string : strings) {
            Object object = this.doLookup(string, string, searchChildren);
            list.add(object);
        }
        return list;
    }

    @Override
    public void pushContext(Object value) {
        BoonExpressionContext child = new BoonExpressionContext(value);
        child.parent = this;
        this.context.add(0, child);
    }

    @Override
    public void removeLastContext() {
        this.context.remove(0);
    }
}

