/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeanmerelis.jeanson.ext.typehandler;

import com.github.jeanmerelis.jeanson.typehandler.DefaultStringHandler;
import com.github.jeanmerelis.jeanson.typehandler.TypeHandler;
import java.io.IOException;
import java.io.Writer;
import org.joda.time.DateTime;

public class JodaDateTimeHandler
implements TypeHandler<DateTime> {
    protected String pattern;
    protected static String patternDefault = "yyyy-MM-dd'T'HH:mm:ssZZ";
    protected static String patternDefaultForDate = "yyyy-MM-dd";
    protected static String patternDefaultForTime = "HH:mm:ss";
    protected static String patternDefaultForDateTime = patternDefault;
    protected static boolean usesMills = true;

    public JodaDateTimeHandler() {
        this.setDefaultValues();
    }

    public void write(Writer w, DateTime obj) throws IOException {
        if (obj == null) {
            w.write("null");
            return;
        }
        if (!usesMills) {
            DefaultStringHandler.escapeAndQuote((Writer)w, (String)obj.toString(this.pattern));
        } else {
            w.write(String.valueOf(obj.getMillis()));
        }
    }

    public void setConfig(String[] params) {
        if (params == null || params.length == 0) {
            this.setDefaultValues();
            return;
        }
        block14: for (String s : params) {
            String[] param = s.split("=");
            String key = param[0].trim();
            String value = param.length > 1 ? param[1] : key;
            switch (key) {
                case "date": {
                    this.pattern = patternDefaultForDate;
                    usesMills = false;
                    continue block14;
                }
                case "time": {
                    this.pattern = patternDefaultForTime;
                    usesMills = false;
                    continue block14;
                }
                case "datetime": {
                    this.pattern = patternDefaultForDateTime;
                    usesMills = false;
                    continue block14;
                }
                case "pattern": {
                    this.pattern = value;
                    usesMills = false;
                }
                case "usesMills": {
                    usesMills = true;
                    continue block14;
                }
                default: {
                    this.pattern = value;
                }
            }
        }
    }

    private void setDefaultValues() {
        this.pattern = patternDefault;
        usesMills = true;
    }

    public static String getPatternDefault() {
        return patternDefault;
    }

    public static void setPatternDefault(String patternDefault) {
        JodaDateTimeHandler.patternDefault = patternDefault;
    }

    public static String getPatternDefaultForDate() {
        return patternDefaultForDate;
    }

    public static void setPatternDefaultForDate(String patternDefaultForDate) {
        JodaDateTimeHandler.patternDefaultForDate = patternDefaultForDate;
    }

    public static String getPatternDefaultForTime() {
        return patternDefaultForTime;
    }

    public static void setPatternDefaultForTime(String patternDefaultForTime) {
        JodaDateTimeHandler.patternDefaultForTime = patternDefaultForTime;
    }

    public static String getPatternDefaultForDateTime() {
        return patternDefaultForDateTime;
    }

    public static void setPatternDefaultForDateTime(String patternDefaultForDateTime) {
        JodaDateTimeHandler.patternDefaultForDateTime = patternDefaultForDateTime;
    }

    public static boolean isUsesMills() {
        return usesMills;
    }

    public static void setUsesMills(boolean usesMills) {
        JodaDateTimeHandler.usesMills = usesMills;
    }
}

