package com.github.jelmerk.knn.examples;

import com.github.jelmerk.knn.Item;

import java.util.Arrays;

public class Word implements Item<String, float[]> {

    private static final long serialVersionUID = 1L;

    private final String id;
    private final float[] vector;

    public Word(String id, float[] vector) {
        this.id = id;
        this.vector = vector;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public float[] vector() {
        return vector;
    }

    @Override
    public String toString() {
        return "Word{" +
                "id='" + id + '\'' +
                ", vector=" + Arrays.toString(vector) +
                '}';
    }
}