/*
 * Decompiled with CFR 0.152.
 */
package com.github.jelmerk.knn.util;

public final class VectorUtils {
    private VectorUtils() {
    }

    public static double magnitude(double[] vector) {
        double magnitude = 0.0;
        for (double aDouble : vector) {
            magnitude += aDouble * aDouble;
        }
        return Math.sqrt(magnitude);
    }

    public static double[] normalize(double[] vector) {
        double[] result = new double[vector.length];
        double normFactor = 1.0 / VectorUtils.magnitude(vector);
        for (int i = 0; i < vector.length; ++i) {
            result[i] = vector[i] * normFactor;
        }
        return result;
    }

    public static float magnitude(float[] vector) {
        float magnitude = 0.0f;
        for (float aFloat : vector) {
            magnitude += aFloat * aFloat;
        }
        return (float)Math.sqrt(magnitude);
    }

    public static float[] normalize(float[] vector) {
        float[] result = new float[vector.length];
        float normFactor = 1.0f / VectorUtils.magnitude(vector);
        for (int i = 0; i < vector.length; ++i) {
            result[i] = vector[i] * normFactor;
        }
        return result;
    }
}

