/*
 * Decompiled with CFR 0.152.
 */
package com.github.jelmerk.knn.util;

public final class VectorUtils {
    private VectorUtils() {
    }

    public static double magnitude(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double[] normalize(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 1.0 / VectorUtils.magnitude(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public static float magnitude(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2 * f2;
        }
        return (float)Math.sqrt(f);
    }

    public static float[] normalize(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        float f = 1.0f / VectorUtils.magnitude(fArray);
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i] * f;
        }
        return fArray2;
    }
}

