/*
 * Decompiled with CFR 0.152.
 */
package com.king.libyuv;

import androidx.annotation.NonNull;

public enum FourCC {
    FOURCC_YUY2("YUY2"),
    FOURCC_UYVY("UYVY"),
    FOURCC_RGBP("RGBP"),
    FOURCC_RGBO("RGBO"),
    FOURCC_R444("R444"),
    FOURCC_24BG("24BG"),
    FOURCC_RAW("RAW "),
    FOURCC_ARGB("ARGB"),
    FOURCC_BGRA("BGRA"),
    FOURCC_ABGR("ABGR"),
    FOURCC_RGBA("RGBA"),
    FOURCC_AR30("AR30"),
    FOURCC_I400("I400"),
    FOURCC_NV12("NV12"),
    FOURCC_NV21("NV21"),
    FOURCC_I420("I420"),
    FOURCC_YV12("YV12"),
    FOURCC_I422("I422"),
    FOURCC_YV16("YV16"),
    FOURCC_I444("I444"),
    FOURCC_YV24("YV24");

    private final String format;
    private final long code;

    private FourCC(String format) {
        this.format = format;
        this.code = this.obtainFourccCode(format);
    }

    private long obtainFourccCode(@NonNull String format) {
        char[] chars = format.toCharArray();
        return (long)(chars[0] | chars[1] << 8) | (long)chars[2] << 16 | (long)chars[3] << 24;
    }

    @NonNull
    public String toString() {
        return this.format;
    }

    long getCode() {
        return this.code;
    }

    int getTotalBppSize(int width, int height) {
        int size;
        switch (this) {
            case FOURCC_YUY2: 
            case FOURCC_UYVY: 
            case FOURCC_I422: 
            case FOURCC_RGBP: 
            case FOURCC_RGBO: 
            case FOURCC_R444: 
            case FOURCC_YV16: {
                size = width * height << 1;
                break;
            }
            case FOURCC_24BG: 
            case FOURCC_RAW: 
            case FOURCC_YV24: {
                size = width * height * 3;
                break;
            }
            case FOURCC_ARGB: 
            case FOURCC_BGRA: 
            case FOURCC_ABGR: 
            case FOURCC_RGBA: 
            case FOURCC_I444: 
            case FOURCC_AR30: {
                size = width * height << 2;
                break;
            }
            case FOURCC_I400: {
                size = width * height;
                break;
            }
            case FOURCC_NV12: 
            case FOURCC_NV21: 
            case FOURCC_I420: 
            case FOURCC_YV12: {
                size = width * height * 3 >> 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return size;
    }
}

