/*
 * Decompiled with CFR 0.152.
 */
package com.king.logx.logger;

import android.util.Log;
import com.king.logx.LogX;
import com.king.logx.logger.Logger;
import com.king.logx.util.Utils;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0014J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001a\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002J*\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/king/logx/logger/DefaultLogger;", "Lcom/king/logx/logger/Logger;", "showThreadInfo", "", "methodCount", "", "methodOffset", "(ZII)V", "getSimpleClassName", "", "name", "isLoggable", "priority", "tag", "log", "", "message", "t", "", "logBottomBorder", "logContent", "chunk", "logDivider", "logHeaderContent", "logTopBorder", "println", "logx_release"})
public class DefaultLogger
extends Logger {
    private final boolean showThreadInfo;
    private final int methodCount;
    private final int methodOffset;

    @JvmOverloads
    public DefaultLogger(boolean showThreadInfo, int methodCount, int methodOffset) {
        super(methodOffset);
        this.showThreadInfo = showThreadInfo;
        this.methodCount = methodCount;
        this.methodOffset = methodOffset;
    }

    public /* synthetic */ DefaultLogger(boolean bl, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = true;
        }
        if ((n3 & 2) != 0) {
            n = 2;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(bl, n, n2);
    }

    @Override
    protected boolean isLoggable(int priority, @Nullable String tag) {
        return LogX.Companion.isDebug$logx_release();
    }

    @Override
    public void log(int priority, @Nullable String tag, @Nullable String message, @Nullable Throwable t) {
        String logMessage = String.valueOf(message);
        CharSequence charSequence = message;
        if (charSequence == null || charSequence.length() == 0) {
            if (t != null) {
                logMessage = Utils.Companion.getStackTraceString(t);
            }
        } else if (t != null) {
            logMessage = logMessage + '\n' + Utils.Companion.getStackTraceString(t);
        }
        this.logTopBorder(priority, tag);
        this.logHeaderContent(priority, tag, this.methodCount, this.getLastOffset$logx_release());
        String string = logMessage;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        int length = bytes.length;
        if (length <= 4000) {
            if (this.methodCount > 0) {
                this.logDivider(priority, tag);
            }
            this.logContent(priority, tag, logMessage);
            this.logBottomBorder(priority, tag);
            return;
        }
        if (this.methodCount > 0) {
            this.logDivider(priority, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = RangesKt.coerceAtMost((int)(length - i), (int)4000);
            this.logContent(priority, tag, new String(bytes, i, count, Charsets.UTF_8));
        }
        this.logBottomBorder(priority, tag);
    }

    private final void logTopBorder(int priority, String tag) {
        this.println(priority, tag, "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }

    private final void logHeaderContent(int priority, String tag, int methodCount, int methodOffset) {
        if (this.showThreadInfo) {
            this.println(priority, tag, "\u2502 Thread: " + Thread.currentThread().getName());
            this.logDivider(priority, tag);
        }
        StackTraceElement[] stackTrace = this.getStackTrace();
        String level = "";
        int showMethodCount = methodCount;
        int stackOffset = this.getStackOffset(stackTrace) + methodOffset;
        if (showMethodCount + stackOffset > stackTrace.length) {
            showMethodCount = stackTrace.length - stackOffset - 1;
        }
        for (int i = showMethodCount; 0 < i; --i) {
            int stackIndex = i + stackOffset;
            if (stackIndex >= stackTrace.length) continue;
            StringBuilder builder = new StringBuilder();
            StringBuilder stringBuilder = builder.append('\u2502').append(' ').append(level);
            String string = stackTrace[stackIndex].getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stackTrace[stackIndex].className");
            stringBuilder.append(this.getSimpleClassName(string)).append(".").append(stackTrace[stackIndex].getMethodName()).append("(").append(stackTrace[stackIndex].getFileName()).append(":").append(stackTrace[stackIndex].getLineNumber()).append(")");
            level = level + "    ";
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
            this.println(priority, tag, string2);
        }
    }

    private final String getSimpleClassName(String name) {
        return StringsKt.substringAfterLast$default((String)name, (char)'.', null, (int)2, null);
    }

    private final void logBottomBorder(int priority, String tag) {
        this.println(priority, tag, "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }

    private final void logDivider(int priority, String tag) {
        this.println(priority, tag, "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504");
    }

    /*
     * WARNING - void declaration
     */
    private final void logContent(int priority, String tag, String chunk) {
        void $this$forEach$iv;
        List list;
        Iterable $this$dropLastWhile$iv;
        Object object = chunk;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String string2 = string;
        string2 = new Regex(string2);
        int n = 0;
        object = string2.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.println(priority, tag, "\u2502 " + it);
        }
    }

    protected void println(int priority, @Nullable String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Log.println((int)priority, (String)tag, (String)message);
    }

    @JvmOverloads
    public DefaultLogger(boolean showThreadInfo, int methodCount) {
        this(showThreadInfo, methodCount, 0, 4, null);
    }

    @JvmOverloads
    public DefaultLogger(boolean showThreadInfo) {
        this(showThreadInfo, 0, 0, 6, null);
    }

    @JvmOverloads
    public DefaultLogger() {
        this(false, 0, 0, 7, null);
    }
}

