/*
 * Decompiled with CFR 0.152.
 */
package com.king.view.viewfinderview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.king.view.viewfinderview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class ViewfinderView
extends View {
    private static final float DEFAULT_RANGE_RATIO = 1.2f;
    private static final float MAX_ZOOM_RATIO = 1.2f;
    private static final int POINT_ANIMATION_INTERVAL = 3000;
    private Paint paint;
    private TextPaint textPaint;
    private int maskColor;
    private int frameColor;
    private int laserColor;
    private int frameCornerColor;
    private float labelTextPadding;
    private int labelTextWidth;
    private TextLocation labelTextLocation;
    private String labelText;
    private int labelTextColor;
    private float labelTextSize;
    private int scannerStart = 0;
    private int scannerEnd = 0;
    private int frameWidth;
    private int frameHeight;
    private LaserStyle laserStyle;
    private int laserGridColumn;
    private int laserGridHeight;
    private Rect frame;
    private int frameCornerStrokeWidth;
    private int frameCornerSize;
    private int laserMovementSpeed;
    private int laserLineHeight;
    private int laserAnimationInterval;
    private int frameLineStrokeWidth;
    private float frameRatio;
    private float framePaddingLeft;
    private float framePaddingTop;
    private float framePaddingRight;
    private float framePaddingBottom;
    private FrameGravity frameGravity;
    private Bitmap frameBitmap;
    private int pointColor;
    private int pointStrokeColor;
    private Bitmap pointBitmap;
    private boolean isPointAnimation = true;
    private int pointAnimationInterval;
    private float pointRadius;
    private float pointStrokeRatio;
    private float pointStrokeRadius;
    private float currentZoomRatio = 1.0f;
    private float lastZoomRatio;
    private float zoomSpeed = 0.02f;
    private int zoomCount;
    private float pointRangeRadius;
    private Bitmap laserBitmap;
    private float laserBitmapRatio;
    private float laserBitmapWidth;
    private int viewfinderStyle = 0;
    private List<Point> pointList;
    private boolean isShowPoints = false;
    private int minDimension;
    private OnItemClickListener onItemClickListener;
    private GestureDetector gestureDetector;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.viewfinderStyle = array.getInt(R.styleable.ViewfinderView_vvViewfinderStyle, 0);
        this.maskColor = array.getColor(R.styleable.ViewfinderView_vvMaskColor, this.getColor(context, R.color.viewfinder_mask));
        this.frameColor = array.getColor(R.styleable.ViewfinderView_vvFrameColor, this.getColor(context, R.color.viewfinder_frame));
        this.frameWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_vvFrameWidth, 0);
        this.frameHeight = array.getDimensionPixelSize(R.styleable.ViewfinderView_vvFrameHeight, 0);
        this.frameRatio = array.getFloat(R.styleable.ViewfinderView_vvFrameRatio, 0.625f);
        this.frameLineStrokeWidth = (int)array.getDimension(R.styleable.ViewfinderView_vvFrameLineStrokeWidth, TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics));
        this.framePaddingLeft = array.getDimension(R.styleable.ViewfinderView_vvFramePaddingLeft, 0.0f);
        this.framePaddingTop = array.getDimension(R.styleable.ViewfinderView_vvFramePaddingTop, 0.0f);
        this.framePaddingRight = array.getDimension(R.styleable.ViewfinderView_vvFramePaddingRight, 0.0f);
        this.framePaddingBottom = array.getDimension(R.styleable.ViewfinderView_vvFramePaddingBottom, 0.0f);
        this.frameGravity = FrameGravity.getFromInt(array.getInt(R.styleable.ViewfinderView_vvFrameGravity, FrameGravity.CENTER.mValue));
        this.frameCornerColor = array.getColor(R.styleable.ViewfinderView_vvFrameCornerColor, this.getColor(context, R.color.viewfinder_corner));
        this.frameCornerSize = (int)array.getDimension(R.styleable.ViewfinderView_vvFrameCornerSize, TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)displayMetrics));
        this.frameCornerStrokeWidth = (int)array.getDimension(R.styleable.ViewfinderView_vvFrameCornerStrokeWidth, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics));
        Drawable frameDrawable = array.getDrawable(R.styleable.ViewfinderView_vvFrameDrawable);
        this.laserLineHeight = (int)array.getDimension(R.styleable.ViewfinderView_vvLaserLineHeight, TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)displayMetrics));
        this.laserMovementSpeed = (int)array.getDimension(R.styleable.ViewfinderView_vvLaserMovementSpeed, TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics));
        this.laserAnimationInterval = array.getInteger(R.styleable.ViewfinderView_vvLaserAnimationInterval, 20);
        this.laserGridColumn = array.getInt(R.styleable.ViewfinderView_vvLaserGridColumn, 20);
        this.laserGridHeight = (int)array.getDimension(R.styleable.ViewfinderView_vvLaserGridHeight, TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics));
        this.laserColor = array.getColor(R.styleable.ViewfinderView_vvLaserColor, this.getColor(context, R.color.viewfinder_laser));
        this.laserStyle = LaserStyle.getFromInt(array.getInt(R.styleable.ViewfinderView_vvLaserStyle, LaserStyle.LINE.mValue));
        this.laserBitmapRatio = array.getFloat(R.styleable.ViewfinderView_vvLaserDrawableRatio, 0.625f);
        Drawable laserDrawable = array.getDrawable(R.styleable.ViewfinderView_vvLaserDrawable);
        this.labelText = array.getString(R.styleable.ViewfinderView_vvLabelText);
        this.labelTextColor = array.getColor(R.styleable.ViewfinderView_vvLabelTextColor, this.getColor(context, R.color.viewfinder_label_text));
        this.labelTextSize = array.getDimension(R.styleable.ViewfinderView_vvLabelTextSize, TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)displayMetrics));
        this.labelTextPadding = array.getDimension(R.styleable.ViewfinderView_vvLabelTextPadding, TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)displayMetrics));
        this.labelTextWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_vvLabelTextWidth, 0);
        this.labelTextLocation = TextLocation.getFromInt(array.getInt(R.styleable.ViewfinderView_vvLabelTextLocation, 0));
        this.pointColor = array.getColor(R.styleable.ViewfinderView_vvPointColor, this.getColor(context, R.color.viewfinder_point));
        this.pointStrokeColor = array.getColor(R.styleable.ViewfinderView_vvPointStrokeColor, this.getColor(context, R.color.viewfinder_point_stroke));
        this.pointRadius = array.getDimension(R.styleable.ViewfinderView_vvPointRadius, TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)displayMetrics));
        this.pointStrokeRatio = array.getFloat(R.styleable.ViewfinderView_vvPointStrokeRatio, 1.2f);
        Drawable pointDrawable = array.getDrawable(R.styleable.ViewfinderView_vvPointDrawable);
        this.isPointAnimation = array.getBoolean(R.styleable.ViewfinderView_vvPointAnimation, true);
        this.pointAnimationInterval = array.getInt(R.styleable.ViewfinderView_vvPointAnimationInterval, 3000);
        array.recycle();
        if (frameDrawable != null) {
            this.frameBitmap = this.getBitmapFormDrawable(frameDrawable);
        }
        if (laserDrawable != null) {
            this.laserBitmap = this.getBitmapFormDrawable(laserDrawable);
        }
        if (pointDrawable != null) {
            this.pointBitmap = this.getBitmapFormDrawable(pointDrawable);
            this.pointRangeRadius = (float)(this.pointBitmap.getWidth() + this.pointBitmap.getHeight()) / 4.0f * 1.2f;
        } else {
            this.pointStrokeRadius = this.pointRadius * this.pointStrokeRatio;
            this.pointRangeRadius = this.pointStrokeRadius * 1.2f;
        }
        this.paint = new Paint(1);
        this.paint.setAntiAlias(true);
        this.textPaint = new TextPaint(1);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(@NonNull MotionEvent event) {
                if (ViewfinderView.this.isShowPoints && ViewfinderView.this.checkSingleTap(event.getX(), event.getY())) {
                    return true;
                }
                return super.onSingleTapUp(event);
            }
        });
    }

    private int getColor(@NonNull Context context, @ColorRes int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColor(id);
        }
        return context.getResources().getColor(id);
    }

    private Bitmap getBitmapFormDrawable(@NonNull Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initFrame(this.getWidth(), this.getHeight());
    }

    private void scaleLaserBitmap() {
        if (this.laserBitmap != null && this.laserBitmapWidth > 0.0f) {
            float ratio = this.laserBitmapWidth / (float)this.laserBitmap.getWidth();
            Matrix matrix = new Matrix();
            matrix.postScale(ratio, ratio);
            int w = this.laserBitmap.getWidth();
            int h = this.laserBitmap.getHeight();
            this.laserBitmap = Bitmap.createBitmap((Bitmap)this.laserBitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        }
    }

    private void initFrame(int width, int height) {
        this.minDimension = Math.min(width, height);
        int size = (int)((float)this.minDimension * this.frameRatio);
        if (this.laserBitmapWidth <= 0.0f) {
            this.laserBitmapWidth = (float)this.minDimension * this.laserBitmapRatio;
            this.scaleLaserBitmap();
        }
        if (this.frameWidth <= 0 || this.frameWidth > width) {
            this.frameWidth = size;
        }
        if (this.frameHeight <= 0 || this.frameHeight > height) {
            this.frameHeight = size;
        }
        if (this.labelTextWidth <= 0) {
            this.labelTextWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        }
        float leftOffsets = (float)(width - this.frameWidth) / 2.0f + this.framePaddingLeft - this.framePaddingRight;
        float topOffsets = (float)(height - this.frameHeight) / 2.0f + this.framePaddingTop - this.framePaddingBottom;
        switch (this.frameGravity) {
            case LEFT: {
                leftOffsets = this.framePaddingLeft;
                break;
            }
            case TOP: {
                topOffsets = this.framePaddingTop;
                break;
            }
            case RIGHT: {
                leftOffsets = (float)(width - this.frameWidth) + this.framePaddingRight;
                break;
            }
            case BOTTOM: {
                topOffsets = (float)(height - this.frameHeight) + this.framePaddingBottom;
            }
        }
        this.frame = new Rect((int)leftOffsets, (int)topOffsets, (int)leftOffsets + this.frameWidth, (int)topOffsets + this.frameHeight);
    }

    public void onDraw(Canvas canvas) {
        if (this.isShowPoints) {
            this.drawMask(canvas, this.getWidth(), this.getHeight());
            this.drawResultPoints(canvas, this.pointList);
            if (this.isPointAnimation) {
                this.calcPointZoomAnimation();
            }
            return;
        }
        if (this.frame == null) {
            return;
        }
        if (this.scannerStart == 0 || this.scannerEnd == 0) {
            this.scannerStart = this.frame.top;
            this.scannerEnd = this.frame.bottom - this.laserLineHeight;
        }
        if (this.viewfinderStyle == 0) {
            this.drawExterior(canvas, this.frame, this.getWidth(), this.getHeight());
            this.drawLaserScanner(canvas, this.frame);
            this.drawFrame(canvas, this.frame);
            this.drawTextInfo(canvas, this.frame);
            this.postInvalidateDelayed(this.laserAnimationInterval, this.frame.left, this.frame.top, this.frame.right, this.frame.bottom);
        } else if (this.viewfinderStyle == 1) {
            this.drawLaserScanner(canvas, this.frame);
            this.drawTextInfo(canvas, this.frame);
            this.postInvalidateDelayed(this.laserAnimationInterval);
        }
    }

    private void drawTextInfo(Canvas canvas, Rect frame) {
        if (!TextUtils.isEmpty((CharSequence)this.labelText)) {
            this.textPaint.setColor(this.labelTextColor);
            this.textPaint.setTextSize(this.labelTextSize);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            StaticLayout staticLayout = new StaticLayout((CharSequence)this.labelText, this.textPaint, this.labelTextWidth, Layout.Alignment.ALIGN_NORMAL, 1.2f, 0.0f, true);
            if (this.labelTextLocation == TextLocation.BOTTOM) {
                canvas.translate((float)frame.left + (float)frame.width() / 2.0f, (float)frame.bottom + this.labelTextPadding);
            } else {
                canvas.translate((float)frame.left + (float)frame.width() / 2.0f, (float)frame.top - this.labelTextPadding - (float)staticLayout.getHeight());
            }
            staticLayout.draw(canvas);
        }
    }

    private void drawCorner(Canvas canvas, Rect frame) {
        this.paint.setColor(this.frameCornerColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.frameCornerStrokeWidth), (float)(frame.top + this.frameCornerSize), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.frameCornerSize), (float)(frame.top + this.frameCornerStrokeWidth), this.paint);
        canvas.drawRect((float)(frame.right - this.frameCornerStrokeWidth), (float)frame.top, (float)frame.right, (float)(frame.top + this.frameCornerSize), this.paint);
        canvas.drawRect((float)(frame.right - this.frameCornerSize), (float)frame.top, (float)frame.right, (float)(frame.top + this.frameCornerStrokeWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.frameCornerStrokeWidth), (float)(frame.left + this.frameCornerSize), (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.frameCornerSize), (float)(frame.left + this.frameCornerStrokeWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.frameCornerStrokeWidth), (float)(frame.bottom - this.frameCornerSize), (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.frameCornerSize), (float)(frame.bottom - this.frameCornerStrokeWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawImageScanner(Canvas canvas, Rect frame) {
        if (this.laserBitmap != null) {
            canvas.drawBitmap(this.laserBitmap, (float)(this.getWidth() - this.laserBitmap.getWidth()) / 2.0f, (float)this.scannerStart, this.paint);
            this.scannerStart = this.scannerStart < this.scannerEnd ? (this.scannerStart += this.laserMovementSpeed) : frame.top;
        } else {
            this.drawLineScanner(canvas, frame);
        }
    }

    private void drawLaserScanner(Canvas canvas, Rect frame) {
        if (this.laserStyle != null) {
            this.paint.setColor(this.laserColor);
            switch (this.laserStyle) {
                case LINE: {
                    this.drawLineScanner(canvas, frame);
                    break;
                }
                case GRID: {
                    this.drawGridScanner(canvas, frame);
                    break;
                }
                case IMAGE: {
                    this.drawImageScanner(canvas, frame);
                }
            }
            this.paint.setShader(null);
        }
    }

    private void drawLineScanner(Canvas canvas, Rect frame) {
        LinearGradient linearGradient = new LinearGradient((float)frame.centerX(), (float)this.scannerStart, (float)frame.centerX(), (float)(this.scannerStart + this.laserLineHeight), this.shadeColor(this.laserColor), this.laserColor, Shader.TileMode.MIRROR);
        this.paint.setShader((Shader)linearGradient);
        if (this.scannerStart < this.scannerEnd) {
            RectF rectF = new RectF((float)(frame.left + this.frameCornerSize), (float)this.scannerStart, (float)(frame.right - this.frameCornerSize), (float)(this.scannerStart + this.laserLineHeight));
            canvas.drawOval(rectF, this.paint);
            this.scannerStart += this.laserMovementSpeed;
        } else {
            this.scannerStart = frame.top;
        }
    }

    private void drawGridScanner(Canvas canvas, Rect frame) {
        int stroke = 2;
        this.paint.setStrokeWidth((float)stroke);
        int startY = this.laserGridHeight > 0 && this.scannerStart - frame.top > this.laserGridHeight ? this.scannerStart - this.laserGridHeight : frame.top;
        LinearGradient linearGradient = new LinearGradient((float)frame.centerX(), (float)startY, (float)frame.centerX(), (float)this.scannerStart, new int[]{this.shadeColor(this.laserColor), this.laserColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)linearGradient);
        float gridItemSize = (float)frame.width() * 1.0f / (float)this.laserGridColumn;
        for (int i = 1; i < this.laserGridColumn; ++i) {
            canvas.drawLine((float)frame.left + (float)i * gridItemSize, (float)startY, (float)frame.left + (float)i * gridItemSize, (float)this.scannerStart, this.paint);
        }
        int height = this.laserGridHeight > 0 && this.scannerStart - frame.top > this.laserGridHeight ? this.laserGridHeight : this.scannerStart - frame.top;
        int i = 0;
        while ((float)i <= (float)height / gridItemSize) {
            canvas.drawLine((float)(frame.left + this.frameLineStrokeWidth), (float)this.scannerStart - (float)i * gridItemSize, (float)(frame.right - this.frameLineStrokeWidth), (float)this.scannerStart - (float)i * gridItemSize, this.paint);
            ++i;
        }
        this.scannerStart = this.scannerStart < this.scannerEnd ? (this.scannerStart += this.laserMovementSpeed) : frame.top;
    }

    private int shadeColor(@ColorInt int color2) {
        String hax = Integer.toHexString(color2);
        String result = "01" + hax.substring(2);
        return Integer.valueOf(result, 16);
    }

    private void drawFrame(Canvas canvas, Rect frame) {
        this.paint.setColor(this.frameColor);
        if (this.frameBitmap != null) {
            canvas.drawBitmap(this.frameBitmap, null, frame, this.paint);
        } else {
            canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.right, (float)(frame.top + this.frameLineStrokeWidth), this.paint);
            canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.frameLineStrokeWidth), (float)frame.bottom, this.paint);
            canvas.drawRect((float)(frame.right - this.frameLineStrokeWidth), (float)frame.top, (float)frame.right, (float)frame.bottom, this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.bottom - this.frameLineStrokeWidth), (float)frame.right, (float)frame.bottom, this.paint);
            this.drawCorner(canvas, frame);
        }
    }

    private void drawExterior(Canvas canvas, Rect frame, int width, int height) {
        if (this.maskColor != 0) {
            this.paint.setColor(this.maskColor);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
            canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)frame.bottom, this.paint);
            canvas.drawRect((float)frame.right, (float)frame.top, (float)width, (float)frame.bottom, this.paint);
            canvas.drawRect(0.0f, (float)frame.bottom, (float)width, (float)height, this.paint);
        }
    }

    private void drawMask(Canvas canvas, int width, int height) {
        if (this.maskColor != 0) {
            this.paint.setColor(this.maskColor);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.paint);
        }
    }

    private void drawResultPoints(Canvas canvas, List<Point> points) {
        this.paint.setColor(-1);
        if (points != null) {
            for (Point point : points) {
                this.drawResultPoint(canvas, point, this.currentZoomRatio);
            }
        }
    }

    private void calcPointZoomAnimation() {
        if (this.currentZoomRatio <= 1.0f) {
            this.lastZoomRatio = this.currentZoomRatio;
            this.currentZoomRatio += this.zoomSpeed;
            this.zoomCount = this.zoomCount < 2 ? ++this.zoomCount : 0;
        } else if (this.currentZoomRatio >= 1.2f) {
            this.lastZoomRatio = this.currentZoomRatio;
            this.currentZoomRatio -= this.zoomSpeed;
        } else if (this.lastZoomRatio > this.currentZoomRatio) {
            this.lastZoomRatio = this.currentZoomRatio;
            this.currentZoomRatio -= this.zoomSpeed;
        } else {
            this.lastZoomRatio = this.currentZoomRatio;
            this.currentZoomRatio += this.zoomSpeed;
        }
        this.postInvalidateDelayed(this.zoomCount == 0 && this.lastZoomRatio == 1.0f ? (long)this.pointAnimationInterval : (long)this.laserAnimationInterval * 2L);
    }

    private void drawResultPoint(Canvas canvas, Point point, float currentZoomRatio) {
        if (this.pointBitmap != null) {
            float left = (float)point.x - (float)this.pointBitmap.getWidth() / 2.0f;
            float top = (float)point.y - (float)this.pointBitmap.getHeight() / 2.0f;
            if (this.isPointAnimation) {
                int dstW = Math.round((float)this.pointBitmap.getWidth() * currentZoomRatio);
                int dstH = Math.round((float)this.pointBitmap.getHeight() * currentZoomRatio);
                int dstLeft = point.x - Math.round((float)dstW / 2.0f);
                int dstTop = point.y - Math.round((float)dstH / 2.0f);
                Rect dstRect = new Rect(dstLeft, dstTop, dstLeft + dstW, dstTop + dstH);
                canvas.drawBitmap(this.pointBitmap, null, dstRect, this.paint);
            } else {
                canvas.drawBitmap(this.pointBitmap, left, top, this.paint);
            }
        } else {
            this.paint.setColor(this.pointStrokeColor);
            canvas.drawCircle((float)point.x, (float)point.y, this.pointStrokeRadius * currentZoomRatio, this.paint);
            this.paint.setColor(this.pointColor);
            canvas.drawCircle((float)point.x, (float)point.y, this.pointRadius * currentZoomRatio, this.paint);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        return this.isShowPoints || super.onTouchEvent(event);
    }

    private boolean checkSingleTap(float x, float y) {
        if (this.pointList != null) {
            for (int i = 0; i < this.pointList.size(); ++i) {
                Point point = this.pointList.get(i);
                float distance = this.getDistance(x, y, point.x, point.y);
                if (!(distance <= this.pointRangeRadius)) continue;
                if (this.onItemClickListener != null) {
                    this.onItemClickListener.onItemClick(i);
                }
                return true;
            }
        }
        return false;
    }

    private float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public boolean isShowPoints() {
        return this.isShowPoints;
    }

    public void showScanner() {
        this.isShowPoints = false;
        this.invalidate();
    }

    public void showResultPoints(List<Point> points) {
        this.pointList = points;
        this.isShowPoints = true;
        this.zoomCount = 0;
        this.lastZoomRatio = 0.0f;
        this.currentZoomRatio = 1.0f;
        this.invalidate();
    }

    public void setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
    }

    public void setFrameColor(@ColorInt int frameColor) {
        this.frameColor = frameColor;
    }

    public void setLaserColor(@ColorInt int laserColor) {
        this.laserColor = laserColor;
    }

    public void setFrameCornerColor(@ColorInt int frameCornerColor) {
        this.frameCornerColor = frameCornerColor;
    }

    public void setLabelTextPadding(float labelTextPadding) {
        this.labelTextPadding = labelTextPadding;
    }

    public void setLabelTextPadding(float labelTextPadding, int unit) {
        this.labelTextPadding = TypedValue.applyDimension((int)unit, (float)labelTextPadding, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setLabelTextWidth(int labelTextWidth) {
        this.labelTextWidth = labelTextWidth;
    }

    public void setLabelTextLocation(TextLocation labelTextLocation) {
        this.labelTextLocation = labelTextLocation;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public void setLabelTextColor(@ColorInt int color2) {
        this.labelTextColor = color2;
    }

    public void setLabelTextColorResource(@ColorRes int id) {
        this.labelTextColor = this.getColor(this.getContext(), id);
    }

    public void setLabelTextSize(float textSize) {
        this.labelTextSize = textSize;
    }

    public void setLabelTextSize(float textSize, int unit) {
        this.labelTextSize = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setLaserStyle(LaserStyle laserStyle) {
        this.laserStyle = laserStyle;
    }

    public void setLaserGridColumn(int laserGridColumn) {
        this.laserGridColumn = laserGridColumn;
    }

    public void setLaserGridHeight(int laserGridHeight) {
        this.laserGridHeight = laserGridHeight;
    }

    public void setFrameCornerStrokeWidth(int frameCornerStrokeWidth) {
        this.frameCornerStrokeWidth = frameCornerStrokeWidth;
    }

    public void setFrameCornerSize(int frameCornerSize) {
        this.frameCornerSize = frameCornerSize;
    }

    public void setFrameCornerSize(int frameCornerSize, int unit) {
        this.frameCornerSize = (int)TypedValue.applyDimension((int)unit, (float)frameCornerSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setLaserMovementSpeed(int laserMovementSpeed) {
        this.laserMovementSpeed = laserMovementSpeed;
    }

    public void setLaserLineHeight(int laserLineHeight) {
        this.laserLineHeight = laserLineHeight;
    }

    public void setFrameLineStrokeWidth(int frameLineStrokeWidth) {
        this.frameLineStrokeWidth = frameLineStrokeWidth;
    }

    public void setFrameDrawable(@DrawableRes int drawableResId) {
        this.setFrameBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawableResId));
    }

    public void setFrameBitmap(Bitmap frameBitmap) {
        this.frameBitmap = frameBitmap;
    }

    public void setLaserAnimationInterval(int laserAnimationInterval) {
        this.laserAnimationInterval = laserAnimationInterval;
    }

    public void setPointColor(@ColorInt int pointColor) {
        this.pointColor = pointColor;
    }

    public void setPointStrokeColor(@ColorInt int pointStrokeColor) {
        this.pointStrokeColor = pointStrokeColor;
    }

    public void setPointRadius(float pointRadius) {
        this.pointRadius = pointRadius;
    }

    public void setPointRadius(float pointRadius, int unit) {
        this.pointRadius = TypedValue.applyDimension((int)unit, (float)pointRadius, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setLaserDrawable(@DrawableRes int drawableResId) {
        this.setLaserBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawableResId));
    }

    public void setLaserBitmap(Bitmap laserBitmap) {
        this.laserBitmap = laserBitmap;
        this.scaleLaserBitmap();
    }

    public void setPointDrawable(@DrawableRes int drawableResId) {
        this.setPointBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawableResId));
    }

    public void setPointBitmap(Bitmap bitmap) {
        this.pointBitmap = bitmap;
        this.pointRangeRadius = (float)(this.pointBitmap.getWidth() + this.pointBitmap.getHeight()) / 4.0f * 1.2f;
    }

    public void setPointAnimationInterval(int pointAnimationInterval) {
        this.pointAnimationInterval = pointAnimationInterval;
    }

    public void setViewfinderStyle(int viewfinderStyle) {
        this.viewfinderStyle = viewfinderStyle;
    }

    public void setFrameWidth(int frameWidth) {
        this.frameWidth = frameWidth;
    }

    public void setFrameHeight(int frameHeight) {
        this.frameHeight = frameHeight;
    }

    public void setFrameRatio(float frameRatio) {
        this.frameRatio = frameRatio;
    }

    public void setFramePaddingLeft(float framePaddingLeft) {
        this.framePaddingLeft = framePaddingLeft;
    }

    public void setFramePaddingTop(float framePaddingTop) {
        this.framePaddingTop = framePaddingTop;
    }

    public void setFramePaddingRight(float framePaddingRight) {
        this.framePaddingRight = framePaddingRight;
    }

    public void setFramePadding(float left, float top, float right, float bottom) {
        this.framePaddingLeft = left;
        this.framePaddingTop = top;
        this.framePaddingRight = right;
        this.framePaddingBottom = bottom;
    }

    public void setFramePaddingBottom(float framePaddingBottom) {
        this.framePaddingBottom = framePaddingBottom;
    }

    public void setFrameGravity(FrameGravity frameGravity) {
        this.frameGravity = frameGravity;
    }

    public void setPointAnimation(boolean pointAnimation) {
        this.isPointAnimation = pointAnimation;
    }

    public void setPointStrokeRadius(float pointStrokeRadius) {
        this.pointStrokeRadius = pointStrokeRadius;
    }

    public void setZoomSpeed(float zoomSpeed) {
        this.zoomSpeed = zoomSpeed;
    }

    public void setPointRangeRadius(float pointRangeRadius) {
        this.pointRangeRadius = pointRangeRadius;
    }

    public void setLaserBitmapRatio(float laserBitmapRatio) {
        this.laserBitmapRatio = laserBitmapRatio;
        if (this.minDimension > 0) {
            this.laserBitmapWidth = (float)this.minDimension * laserBitmapRatio;
            this.scaleLaserBitmap();
        }
    }

    public void setLaserBitmapWidth(float laserBitmapWidth) {
        this.laserBitmapWidth = laserBitmapWidth;
        this.scaleLaserBitmap();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewfinderStyle {
        public static final int CLASSIC = 0;
        public static final int POPULAR = 1;
    }

    public static enum FrameGravity {
        CENTER(0),
        LEFT(1),
        TOP(2),
        RIGHT(3),
        BOTTOM(4);

        private final int mValue;

        private FrameGravity(int value) {
            this.mValue = value;
        }

        private static FrameGravity getFromInt(int value) {
            for (FrameGravity gravity : FrameGravity.values()) {
                if (gravity.mValue != value) continue;
                return gravity;
            }
            return CENTER;
        }
    }

    public static enum LaserStyle {
        NONE(0),
        LINE(1),
        GRID(2),
        IMAGE(3);

        private final int mValue;

        private LaserStyle(int value) {
            this.mValue = value;
        }

        private static LaserStyle getFromInt(int value) {
            for (LaserStyle style : LaserStyle.values()) {
                if (style.mValue != value) continue;
                return style;
            }
            return LINE;
        }
    }

    public static enum TextLocation {
        TOP(0),
        BOTTOM(1);

        private final int mValue;

        private TextLocation(int value) {
            this.mValue = value;
        }

        private static TextLocation getFromInt(int value) {
            for (TextLocation location : TextLocation.values()) {
                if (location.mValue != value) continue;
                return location;
            }
            return TOP;
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

