/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.Nullable;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.king.zxing.DecodeConfig;
import com.king.zxing.analyze.AreaRectAnalyzer;
import com.king.zxing.util.LogUtils;
import java.util.Map;

public abstract class BarcodeFormatAnalyzer
extends AreaRectAnalyzer {
    private Reader mReader;

    public BarcodeFormatAnalyzer(@Nullable Map<DecodeHintType, Object> hints) {
        this(new DecodeConfig().setHints(hints));
    }

    public BarcodeFormatAnalyzer(@Nullable DecodeConfig config) {
        super(config);
        this.initReader();
    }

    private void initReader() {
        this.mReader = this.createReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Result analyze(byte[] data, int dataWidth, int dataHeight, int left, int top, int width, int height) {
        Result rawResult = null;
        if (this.mReader != null) {
            try {
                long start = System.currentTimeMillis();
                PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(data, dataWidth, dataHeight, left, top, width, height, false);
                rawResult = this.decodeInternal((LuminanceSource)source, this.isMultiDecode);
                if (rawResult == null && this.mDecodeConfig != null) {
                    if (rawResult == null && this.mDecodeConfig.isSupportVerticalCode()) {
                        byte[] rotatedData = new byte[data.length];
                        for (int y = 0; y < dataHeight; ++y) {
                            for (int x = 0; x < dataWidth; ++x) {
                                rotatedData[x * dataHeight + dataHeight - y - 1] = data[x + y * dataWidth];
                            }
                        }
                        rawResult = this.decodeInternal((LuminanceSource)new PlanarYUVLuminanceSource(rotatedData, dataHeight, dataWidth, top, left, height, width, false), this.mDecodeConfig.isSupportVerticalCodeMultiDecode());
                    }
                    if (this.mDecodeConfig.isSupportLuminanceInvert()) {
                        rawResult = this.decodeInternal(source.invert(), this.mDecodeConfig.isSupportLuminanceInvertMultiDecode());
                    }
                }
                if (rawResult != null) {
                    long end = System.currentTimeMillis();
                    LogUtils.d("Found barcode in " + (end - start) + " ms");
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.mReader.reset();
            }
        }
        return rawResult;
    }

    private Result decodeInternal(LuminanceSource source, boolean isMultiDecode) {
        Result result = null;
        try {
            try {
                result = this.mReader.decode(new BinaryBitmap((Binarizer)new HybridBinarizer(source)), this.mHints);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isMultiDecode && result == null) {
                result = this.mReader.decode(new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer(source)), this.mHints);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public abstract Reader createReader();
}

