/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.camera.view.PreviewView;
import androidx.fragment.app.Fragment;
import com.google.zxing.Result;
import com.king.zxing.CameraScan;
import com.king.zxing.DefaultCameraScan;
import com.king.zxing.R;
import com.king.zxing.ViewfinderView;
import com.king.zxing.util.LogUtils;
import com.king.zxing.util.PermissionUtils;

public class CaptureFragment
extends Fragment
implements CameraScan.OnScanResultCallback {
    private static final int CAMERA_PERMISSION_REQUEST_CODE = 134;
    private View mRootView;
    protected PreviewView previewView;
    protected ViewfinderView viewfinderView;
    protected View ivFlashlight;
    private CameraScan mCameraScan;

    public static CaptureFragment newInstance() {
        Bundle args = new Bundle();
        CaptureFragment fragment = new CaptureFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutId = this.getLayoutId();
        if (this.isContentView(layoutId)) {
            this.mRootView = this.createRootView(inflater, container);
        }
        this.initUI();
        return this.mRootView;
    }

    public void initUI() {
        int ivFlashlightId;
        this.previewView = (PreviewView)this.mRootView.findViewById(this.getPreviewViewId());
        int viewfinderViewId = this.getViewfinderViewId();
        if (viewfinderViewId != 0) {
            this.viewfinderView = (ViewfinderView)this.mRootView.findViewById(viewfinderViewId);
        }
        if ((ivFlashlightId = this.getFlashlightId()) != 0) {
            this.ivFlashlight = this.mRootView.findViewById(ivFlashlightId);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setOnClickListener(v -> this.onClickFlashlight());
            }
        }
        this.initCameraScan();
        this.startCamera();
    }

    protected void onClickFlashlight() {
        this.toggleTorchState();
    }

    public void initCameraScan() {
        this.mCameraScan = new DefaultCameraScan(this, this.previewView);
        this.mCameraScan.setOnScanResultCallback(this);
    }

    public void startCamera() {
        if (this.mCameraScan != null) {
            if (PermissionUtils.checkPermission(this.getContext(), "android.permission.CAMERA")) {
                this.mCameraScan.startCamera();
            } else {
                LogUtils.d("checkPermissionResult != PERMISSION_GRANTED");
                PermissionUtils.requestPermission(this, "android.permission.CAMERA", 134);
            }
        }
    }

    private void releaseCamera() {
        if (this.mCameraScan != null) {
            this.mCameraScan.release();
        }
    }

    protected void toggleTorchState() {
        if (this.mCameraScan != null) {
            boolean isTorch = this.mCameraScan.isTorchEnabled();
            this.mCameraScan.enableTorch(!isTorch);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setSelected(!isTorch);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 134) {
            this.requestCameraPermissionResult(permissions, grantResults);
        }
    }

    public void requestCameraPermissionResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionUtils.requestPermissionsResult("android.permission.CAMERA", permissions, grantResults)) {
            this.startCamera();
        } else {
            this.getActivity().finish();
        }
    }

    public void onDestroy() {
        this.releaseCamera();
        super.onDestroy();
    }

    public boolean isContentView(@LayoutRes int layoutId) {
        return true;
    }

    @NonNull
    public View createRootView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(this.getLayoutId(), container, false);
    }

    public int getLayoutId() {
        return R.layout.zxl_capture;
    }

    public int getViewfinderViewId() {
        return R.id.viewfinderView;
    }

    public int getPreviewViewId() {
        return R.id.previewView;
    }

    public int getFlashlightId() {
        return R.id.ivFlashlight;
    }

    public CameraScan getCameraScan() {
        return this.mCameraScan;
    }

    @Override
    public boolean onScanResultCallback(Result result) {
        return false;
    }

    public View getRootView() {
        return this.mRootView;
    }
}

