/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.config;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import com.king.zxing.config.CameraConfig;
import com.king.zxing.util.LogUtils;

public final class AspectRatioCameraConfig
extends CameraConfig {
    private int mAspectRatio;

    public AspectRatioCameraConfig(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        this.mAspectRatio = this.aspectRatio(width, height);
        LogUtils.d("aspectRatio:" + this.mAspectRatio);
    }

    private int aspectRatio(float width, float height) {
        float ratio = Math.max(width, height) / Math.min(width, height);
        if (Math.abs(ratio - 1.3333334f) < Math.abs(ratio - 1.7777778f)) {
            return 0;
        }
        return 1;
    }

    @Override
    @NonNull
    public Preview options(@NonNull Preview.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public CameraSelector options(@NonNull CameraSelector.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public ImageAnalysis options(@NonNull ImageAnalysis.Builder builder) {
        builder.setTargetAspectRatio(this.mAspectRatio);
        return super.options(builder);
    }
}

