/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing;

import android.content.Context;
import android.content.Intent;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.detector.MathUtils;
import com.king.zxing.CameraScan;
import com.king.zxing.analyze.Analyzer;
import com.king.zxing.analyze.MultiFormatAnalyzer;
import com.king.zxing.config.CameraConfig;
import com.king.zxing.manager.AmbientLightManager;
import com.king.zxing.manager.BeepManager;
import com.king.zxing.util.LogUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DefaultCameraScan
extends CameraScan {
    private static final int HOVER_TAP_TIMEOUT = 150;
    private static final int HOVER_TAP_SLOP = 20;
    private FragmentActivity mFragmentActivity;
    private Context mContext;
    private LifecycleOwner mLifecycleOwner;
    private PreviewView mPreviewView;
    private ListenableFuture<ProcessCameraProvider> mCameraProviderFuture;
    private Camera mCamera;
    private CameraConfig mCameraConfig;
    private Analyzer mAnalyzer;
    private volatile boolean isAnalyze = true;
    private volatile boolean isAnalyzeResult;
    private View flashlightView;
    private MutableLiveData<Result> mResultLiveData;
    private CameraScan.OnScanResultCallback mOnScanResultCallback;
    private BeepManager mBeepManager;
    private AmbientLightManager mAmbientLightManager;
    private int mOrientation;
    private int mScreenWidth;
    private int mScreenHeight;
    private long mLastAutoZoomTime;
    private long mLastHoveTapTime;
    private boolean isClickTap;
    private float mDownX;
    private float mDownY;
    private ScaleGestureDetector.OnScaleGestureListener mOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            if (DefaultCameraScan.this.mCamera != null) {
                float ratio = ((ZoomState)DefaultCameraScan.this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio();
                DefaultCameraScan.this.zoomTo(ratio * scale);
            }
            return true;
        }
    };

    public DefaultCameraScan(@NonNull FragmentActivity activity, @NonNull PreviewView previewView) {
        this.mFragmentActivity = activity;
        this.mLifecycleOwner = activity;
        this.mContext = activity;
        this.mPreviewView = previewView;
        this.initData();
    }

    public DefaultCameraScan(@NonNull Fragment fragment, @NonNull PreviewView previewView) {
        this.mFragmentActivity = fragment.getActivity();
        this.mLifecycleOwner = fragment;
        this.mContext = fragment.getContext();
        this.mPreviewView = previewView;
        this.initData();
    }

    private void initData() {
        this.mResultLiveData = new MutableLiveData();
        this.mResultLiveData.observe(this.mLifecycleOwner, result -> {
            if (result != null) {
                this.handleAnalyzeResult((Result)result);
            } else if (this.mOnScanResultCallback != null) {
                this.mOnScanResultCallback.onScanResultFailure();
            }
        });
        this.mOrientation = this.mContext.getResources().getConfiguration().orientation;
        ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(this.mContext, this.mOnScaleGestureListener);
        this.mPreviewView.setOnTouchListener((v, event) -> {
            this.handlePreviewViewClickTap(event);
            if (this.isNeedTouchZoom()) {
                return scaleGestureDetector.onTouchEvent(event);
            }
            return false;
        });
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        this.mScreenWidth = displayMetrics.widthPixels;
        this.mScreenHeight = displayMetrics.heightPixels;
        LogUtils.d(String.format("displayMetrics:%dx%d", this.mScreenWidth, this.mScreenHeight));
        this.mBeepManager = new BeepManager(this.mContext);
        this.mAmbientLightManager = new AmbientLightManager(this.mContext);
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.register();
            this.mAmbientLightManager.setOnLightSensorEventListener((dark, lightLux) -> {
                if (this.flashlightView != null) {
                    if (dark) {
                        if (this.flashlightView.getVisibility() != 0) {
                            this.flashlightView.setVisibility(0);
                            this.flashlightView.setSelected(this.isTorchEnabled());
                        }
                    } else if (this.flashlightView.getVisibility() == 0 && !this.isTorchEnabled()) {
                        this.flashlightView.setVisibility(4);
                        this.flashlightView.setSelected(false);
                    }
                }
            });
        }
    }

    private void handlePreviewViewClickTap(MotionEvent event) {
        if (event.getPointerCount() == 1) {
            switch (event.getAction()) {
                case 0: {
                    this.isClickTap = true;
                    this.mDownX = event.getX();
                    this.mDownY = event.getY();
                    this.mLastHoveTapTime = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    this.isClickTap = MathUtils.distance((float)this.mDownX, (float)this.mDownY, (float)event.getX(), (float)event.getY()) < 20.0f;
                    break;
                }
                case 1: {
                    if (!this.isClickTap || this.mLastHoveTapTime + 150L <= System.currentTimeMillis()) break;
                    this.startFocusAndMetering(event.getX(), event.getY());
                }
            }
        }
    }

    private void startFocusAndMetering(float x, float y) {
        if (this.mCamera != null) {
            MeteringPoint point = this.mPreviewView.getMeteringPointFactory().createPoint(x, y);
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point).build();
            if (this.mCamera.getCameraInfo().isFocusMeteringSupported(focusMeteringAction)) {
                this.mCamera.getCameraControl().startFocusAndMetering(focusMeteringAction);
                LogUtils.d("startFocusAndMetering:" + x + "," + y);
            }
        }
    }

    private void initConfig() {
        if (this.mCameraConfig == null) {
            this.mCameraConfig = new CameraConfig();
        }
        if (this.mAnalyzer == null) {
            this.mAnalyzer = new MultiFormatAnalyzer();
        }
    }

    @Override
    public CameraScan setCameraConfig(CameraConfig cameraConfig) {
        if (cameraConfig != null) {
            this.mCameraConfig = cameraConfig;
        }
        return this;
    }

    @Override
    public void startCamera() {
        this.initConfig();
        this.mCameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.mContext);
        this.mCameraProviderFuture.addListener(() -> {
            try {
                Preview preview = this.mCameraConfig.options(new Preview.Builder());
                CameraSelector cameraSelector = this.mCameraConfig.options(new CameraSelector.Builder());
                preview.setSurfaceProvider(this.mPreviewView.getSurfaceProvider());
                ImageAnalysis imageAnalysis = this.mCameraConfig.options(new ImageAnalysis.Builder().setOutputImageFormat(1).setBackpressureStrategy(0));
                imageAnalysis.setAnalyzer((Executor)Executors.newSingleThreadExecutor(), image -> {
                    if (this.isAnalyze && !this.isAnalyzeResult && this.mAnalyzer != null) {
                        Result result = this.mAnalyzer.analyze(image, this.mOrientation);
                        this.mResultLiveData.postValue((Object)result);
                    }
                    image.close();
                });
                if (this.mCamera != null) {
                    ((ProcessCameraProvider)this.mCameraProviderFuture.get()).unbindAll();
                }
                this.mCamera = ((ProcessCameraProvider)this.mCameraProviderFuture.get()).bindToLifecycle(this.mLifecycleOwner, cameraSelector, new UseCase[]{preview, imageAnalysis});
            }
            catch (Exception e) {
                LogUtils.e(e);
            }
        }, ContextCompat.getMainExecutor((Context)this.mContext));
    }

    private synchronized void handleAnalyzeResult(Result result) {
        ResultPoint[] points;
        if (this.isAnalyzeResult || !this.isAnalyze) {
            return;
        }
        this.isAnalyzeResult = true;
        if (this.mBeepManager != null) {
            this.mBeepManager.playBeepSoundAndVibrate();
        }
        if (result.getBarcodeFormat() == BarcodeFormat.QR_CODE && this.isNeedAutoZoom() && this.mLastAutoZoomTime + 100L < System.currentTimeMillis() && (points = result.getResultPoints()) != null && points.length >= 2) {
            float distance1;
            float maxDistance = distance1 = ResultPoint.distance((ResultPoint)points[0], (ResultPoint)points[1]);
            if (points.length >= 3) {
                float distance2 = ResultPoint.distance((ResultPoint)points[1], (ResultPoint)points[2]);
                float distance3 = ResultPoint.distance((ResultPoint)points[0], (ResultPoint)points[2]);
                maxDistance = Math.max(Math.max(distance1, distance2), distance3);
            }
            if (this.handleAutoZoom((int)maxDistance, result)) {
                return;
            }
        }
        this.scanResultCallback(result);
    }

    private boolean handleAutoZoom(int distance, Result result) {
        int size = Math.min(this.mScreenWidth, this.mScreenHeight);
        if (distance * 4 < size) {
            this.mLastAutoZoomTime = System.currentTimeMillis();
            this.zoomIn();
            this.scanResultCallback(result);
            return true;
        }
        return false;
    }

    private void scanResultCallback(Result result) {
        if (this.mOnScanResultCallback != null && this.mOnScanResultCallback.onScanResultCallback(result)) {
            this.isAnalyzeResult = false;
            return;
        }
        if (this.mFragmentActivity != null) {
            Intent intent = new Intent();
            intent.putExtra(SCAN_RESULT, result.getText());
            this.mFragmentActivity.setResult(-1, intent);
            this.mFragmentActivity.finish();
        }
    }

    @Override
    public void stopCamera() {
        if (this.mCameraProviderFuture != null) {
            try {
                ((ProcessCameraProvider)this.mCameraProviderFuture.get()).unbindAll();
            }
            catch (Exception e) {
                LogUtils.e(e);
            }
        }
    }

    @Override
    public CameraScan setAnalyzeImage(boolean analyze) {
        this.isAnalyze = analyze;
        return this;
    }

    @Override
    public CameraScan setAnalyzer(Analyzer analyzer) {
        this.mAnalyzer = analyzer;
        return this;
    }

    @Override
    public void zoomIn() {
        float maxRatio;
        float ratio;
        if (this.mCamera != null && (ratio = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio() + 0.1f) <= (maxRatio = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getMaxZoomRatio())) {
            this.mCamera.getCameraControl().setZoomRatio(ratio);
        }
    }

    @Override
    public void zoomOut() {
        float minRatio;
        float ratio;
        if (this.mCamera != null && (ratio = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio() - 0.1f) >= (minRatio = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getMinZoomRatio())) {
            this.mCamera.getCameraControl().setZoomRatio(ratio);
        }
    }

    @Override
    public void zoomTo(float ratio) {
        if (this.mCamera != null) {
            ZoomState zoomState = (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue();
            float maxRatio = zoomState.getMaxZoomRatio();
            float minRatio = zoomState.getMinZoomRatio();
            float zoom = Math.max(Math.min(ratio, maxRatio), minRatio);
            this.mCamera.getCameraControl().setZoomRatio(zoom);
        }
    }

    @Override
    public void lineZoomIn() {
        float zoom;
        if (this.mCamera != null && (zoom = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getLinearZoom() + 0.1f) <= 1.0f) {
            this.mCamera.getCameraControl().setLinearZoom(zoom);
        }
    }

    @Override
    public void lineZoomOut() {
        float zoom;
        if (this.mCamera != null && (zoom = ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getLinearZoom() - 0.1f) >= 0.0f) {
            this.mCamera.getCameraControl().setLinearZoom(zoom);
        }
    }

    @Override
    public void lineZoomTo(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().setLinearZoom(linearZoom);
        }
    }

    @Override
    public void enableTorch(boolean torch) {
        if (this.mCamera != null && this.hasFlashUnit()) {
            this.mCamera.getCameraControl().enableTorch(torch);
        }
    }

    @Override
    public boolean isTorchEnabled() {
        if (this.mCamera != null) {
            return (Integer)this.mCamera.getCameraInfo().getTorchState().getValue() == 1;
        }
        return false;
    }

    @Override
    public boolean hasFlashUnit() {
        if (this.mCamera != null) {
            return this.mCamera.getCameraInfo().hasFlashUnit();
        }
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    @Override
    public CameraScan setVibrate(boolean vibrate) {
        if (this.mBeepManager != null) {
            this.mBeepManager.setVibrate(vibrate);
        }
        return this;
    }

    @Override
    public CameraScan setPlayBeep(boolean playBeep) {
        if (this.mBeepManager != null) {
            this.mBeepManager.setPlayBeep(playBeep);
        }
        return this;
    }

    @Override
    public CameraScan setOnScanResultCallback(CameraScan.OnScanResultCallback callback) {
        this.mOnScanResultCallback = callback;
        return this;
    }

    @Override
    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    @Override
    public void release() {
        this.isAnalyze = false;
        this.flashlightView = null;
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.unregister();
        }
        if (this.mBeepManager != null) {
            this.mBeepManager.close();
        }
        this.stopCamera();
    }

    @Override
    public CameraScan bindFlashlightView(@Nullable View v) {
        this.flashlightView = v;
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setLightSensorEnabled(v != null);
        }
        return this;
    }

    @Override
    public CameraScan setDarkLightLux(float lightLux) {
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setDarkLightLux(lightLux);
        }
        return this;
    }

    @Override
    public CameraScan setBrightLightLux(float lightLux) {
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setBrightLightLux(lightLux);
        }
        return this;
    }
}

