/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.view.PreviewView;
import androidx.fragment.app.FragmentActivity;
import com.google.zxing.Result;
import com.king.zxing.CameraScan;
import com.king.zxing.DefaultCameraScan;
import com.king.zxing.R;
import com.king.zxing.ViewfinderView;
import com.king.zxing.util.LogUtils;
import com.king.zxing.util.PermissionUtils;

public class CaptureActivity
extends AppCompatActivity
implements CameraScan.OnScanResultCallback {
    private static final int CAMERA_PERMISSION_REQUEST_CODE = 134;
    protected PreviewView previewView;
    protected ViewfinderView viewfinderView;
    protected View ivFlashlight;
    private CameraScan mCameraScan;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isContentView()) {
            this.setContentView(this.getLayoutId());
        }
        this.initUI();
    }

    public void initUI() {
        int ivFlashlightId;
        this.previewView = (PreviewView)this.findViewById(this.getPreviewViewId());
        int viewfinderViewId = this.getViewfinderViewId();
        if (viewfinderViewId != 0 && viewfinderViewId != -1) {
            this.viewfinderView = (ViewfinderView)this.findViewById(viewfinderViewId);
        }
        if ((ivFlashlightId = this.getFlashlightId()) != 0 && ivFlashlightId != -1) {
            this.ivFlashlight = this.findViewById(ivFlashlightId);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setOnClickListener(v -> this.onClickFlashlight());
            }
        }
        this.initCameraScan();
        this.startCamera();
    }

    protected void onClickFlashlight() {
        this.toggleTorchState();
    }

    public void initCameraScan() {
        this.mCameraScan = new DefaultCameraScan((FragmentActivity)this, this.previewView);
        this.mCameraScan.setOnScanResultCallback(this);
    }

    public void startCamera() {
        if (this.mCameraScan != null) {
            if (PermissionUtils.checkPermission((Context)this, "android.permission.CAMERA")) {
                this.mCameraScan.startCamera();
            } else {
                LogUtils.d("checkPermissionResult != PERMISSION_GRANTED");
                PermissionUtils.requestPermission((Activity)this, "android.permission.CAMERA", 134);
            }
        }
    }

    private void releaseCamera() {
        if (this.mCameraScan != null) {
            this.mCameraScan.release();
        }
    }

    protected void toggleTorchState() {
        if (this.mCameraScan != null) {
            boolean isTorch = this.mCameraScan.isTorchEnabled();
            this.mCameraScan.enableTorch(!isTorch);
            if (this.ivFlashlight != null) {
                this.ivFlashlight.setSelected(!isTorch);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 134) {
            this.requestCameraPermissionResult(permissions, grantResults);
        }
    }

    public void requestCameraPermissionResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionUtils.requestPermissionsResult("android.permission.CAMERA", permissions, grantResults)) {
            this.startCamera();
        } else {
            this.finish();
        }
    }

    protected void onDestroy() {
        this.releaseCamera();
        super.onDestroy();
    }

    public boolean isContentView() {
        return true;
    }

    public int getLayoutId() {
        return R.layout.zxl_capture;
    }

    public int getViewfinderViewId() {
        return R.id.viewfinderView;
    }

    public int getPreviewViewId() {
        return R.id.previewView;
    }

    public int getFlashlightId() {
        return R.id.ivFlashlight;
    }

    public CameraScan getCameraScan() {
        return this.mCameraScan;
    }

    @Override
    public boolean onScanResultCallback(Result result) {
        return false;
    }
}

