/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing;

import androidx.annotation.NonNull;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class DecodeFormatManager {
    public static final Map<DecodeHintType, Object> ALL_HINTS = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
    public static final Map<DecodeHintType, Object> CODE_128_HINTS = DecodeFormatManager.createDecodeHint(BarcodeFormat.CODE_128);
    public static final Map<DecodeHintType, Object> QR_CODE_HINTS = DecodeFormatManager.createDecodeHint(BarcodeFormat.QR_CODE);
    public static final Map<DecodeHintType, Object> ONE_DIMENSIONAL_HINTS = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
    public static final Map<DecodeHintType, Object> TWO_DIMENSIONAL_HINTS = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
    public static final Map<DecodeHintType, Object> DEFAULT_HINTS = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);

    private static List<BarcodeFormat> getAllFormats() {
        ArrayList<BarcodeFormat> list = new ArrayList<BarcodeFormat>();
        list.add(BarcodeFormat.AZTEC);
        list.add(BarcodeFormat.CODABAR);
        list.add(BarcodeFormat.CODE_39);
        list.add(BarcodeFormat.CODE_93);
        list.add(BarcodeFormat.CODE_128);
        list.add(BarcodeFormat.DATA_MATRIX);
        list.add(BarcodeFormat.EAN_8);
        list.add(BarcodeFormat.EAN_13);
        list.add(BarcodeFormat.ITF);
        list.add(BarcodeFormat.MAXICODE);
        list.add(BarcodeFormat.PDF_417);
        list.add(BarcodeFormat.QR_CODE);
        list.add(BarcodeFormat.RSS_14);
        list.add(BarcodeFormat.RSS_EXPANDED);
        list.add(BarcodeFormat.UPC_A);
        list.add(BarcodeFormat.UPC_E);
        list.add(BarcodeFormat.UPC_EAN_EXTENSION);
        return list;
    }

    private static List<BarcodeFormat> getOneDimensionalFormats() {
        ArrayList<BarcodeFormat> list = new ArrayList<BarcodeFormat>();
        list.add(BarcodeFormat.CODABAR);
        list.add(BarcodeFormat.CODE_39);
        list.add(BarcodeFormat.CODE_93);
        list.add(BarcodeFormat.CODE_128);
        list.add(BarcodeFormat.EAN_8);
        list.add(BarcodeFormat.EAN_13);
        list.add(BarcodeFormat.ITF);
        list.add(BarcodeFormat.RSS_14);
        list.add(BarcodeFormat.RSS_EXPANDED);
        list.add(BarcodeFormat.UPC_A);
        list.add(BarcodeFormat.UPC_E);
        list.add(BarcodeFormat.UPC_EAN_EXTENSION);
        return list;
    }

    private static List<BarcodeFormat> getTwoDimensionalFormats() {
        ArrayList<BarcodeFormat> list = new ArrayList<BarcodeFormat>();
        list.add(BarcodeFormat.AZTEC);
        list.add(BarcodeFormat.DATA_MATRIX);
        list.add(BarcodeFormat.MAXICODE);
        list.add(BarcodeFormat.PDF_417);
        list.add(BarcodeFormat.QR_CODE);
        return list;
    }

    private static List<BarcodeFormat> getDefaultFormats() {
        ArrayList<BarcodeFormat> list = new ArrayList<BarcodeFormat>();
        list.add(BarcodeFormat.QR_CODE);
        list.add(BarcodeFormat.UPC_A);
        list.add(BarcodeFormat.EAN_13);
        list.add(BarcodeFormat.CODE_128);
        return list;
    }

    public static Map<DecodeHintType, Object> createDecodeHints(BarcodeFormat ... barcodeFormats) {
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        DecodeFormatManager.addDecodeHintTypes(hints, Arrays.asList(barcodeFormats));
        return hints;
    }

    public static Map<DecodeHintType, Object> createDecodeHint(@NonNull BarcodeFormat barcodeFormat) {
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        DecodeFormatManager.addDecodeHintTypes(hints, Collections.singletonList(barcodeFormat));
        return hints;
    }

    private static void addDecodeHintTypes(Map<DecodeHintType, Object> hints, List<BarcodeFormat> formats) {
        hints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
    }

    static {
        DecodeFormatManager.addDecodeHintTypes(ALL_HINTS, DecodeFormatManager.getAllFormats());
        DecodeFormatManager.addDecodeHintTypes(ONE_DIMENSIONAL_HINTS, DecodeFormatManager.getOneDimensionalFormats());
        DecodeFormatManager.addDecodeHintTypes(TWO_DIMENSIONAL_HINTS, DecodeFormatManager.getTwoDimensionalFormats());
        DecodeFormatManager.addDecodeHintTypes(DEFAULT_HINTS, DecodeFormatManager.getDefaultFormats());
    }
}

