/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import com.google.zxing.Result;
import com.king.zxing.analyze.Analyzer;
import com.king.zxing.util.BitmapUtils;
import com.king.zxing.util.LogUtils;

public abstract class ImageAnalyzer
implements Analyzer {
    @Nullable
    public abstract Result analyze(byte[] var1, int var2, int var3);

    @Override
    public Result analyze(@NonNull ImageProxy image, int orientation) {
        if (image.getFormat() == 35) {
            int width = image.getWidth();
            int height = image.getHeight();
            byte[] data = BitmapUtils.yuv420ThreePlanesToNV21(image.getImage().getPlanes(), width, height).array();
            if (orientation == 1) {
                byte[] rotatedData = new byte[data.length];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotatedData[x * height + height - y - 1] = data[x + y * width];
                    }
                }
                return this.analyze(rotatedData, height, width);
            }
            return this.analyze(data, width, height);
        }
        LogUtils.w("imageFormat: " + image.getFormat());
        return null;
    }
}

