/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.config;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import com.king.zxing.config.CameraConfig;
import com.king.zxing.util.LogUtils;
import java.util.Locale;

public final class AspectRatioCameraConfig
extends CameraConfig {
    private int mAspectRatio;

    public AspectRatioCameraConfig(Context context) {
        this.initTargetAspectRatio(context);
    }

    private void initTargetAspectRatio(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        LogUtils.d(String.format(Locale.getDefault(), "displayMetrics: %dx%d", width, height));
        float ratio = (float)Math.max(width, height) / (float)Math.min(width, height);
        this.mAspectRatio = Math.abs(ratio - 1.3333334f) < Math.abs(ratio - 1.7777778f) ? 0 : 1;
        LogUtils.d("aspectRatio: " + this.mAspectRatio);
    }

    @Override
    @NonNull
    public Preview options(@NonNull Preview.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public CameraSelector options(@NonNull CameraSelector.Builder builder) {
        return super.options(builder);
    }

    @Override
    @NonNull
    public ImageAnalysis options(@NonNull ImageAnalysis.Builder builder) {
        builder.setTargetAspectRatio(this.mAspectRatio);
        return super.options(builder);
    }
}

