/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import com.google.zxing.Result;
import com.king.camera.scan.AnalyzeResult;
import com.king.camera.scan.FrameMetadata;
import com.king.camera.scan.analyze.Analyzer;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ImageAnalyzer
implements Analyzer<Result> {
    private final Queue<byte[]> queue = new ConcurrentLinkedQueue<byte[]>();
    private final AtomicBoolean joinQueue = new AtomicBoolean(false);

    @Nullable
    public abstract Result analyze(byte[] var1, int var2, int var3);

    public void analyze(@NonNull ImageProxy imageProxy, @NonNull Analyzer.OnAnalyzeListener<AnalyzeResult<Result>> listener) {
        if (!this.joinQueue.get()) {
            int imageSize = imageProxy.getWidth() * imageProxy.getHeight();
            byte[] bytes = new byte[imageSize + 2 * (imageSize / 4)];
            this.queue.add(bytes);
            this.joinQueue.set(true);
        }
        if (this.queue.isEmpty()) {
            return;
        }
        byte[] nv21Data = this.queue.poll();
        try {
            Result result;
            int rotation = imageProxy.getImageInfo().getRotationDegrees();
            int width = imageProxy.getWidth();
            int height = imageProxy.getHeight();
            this.yuv_420_888toNv21(imageProxy, nv21Data);
            if (rotation == 90 || rotation == 270) {
                byte[] rotatedData = new byte[nv21Data.length];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotatedData[x * height + height - y - 1] = nv21Data[x + y * width];
                    }
                }
                result = this.analyze(rotatedData, height, width);
            } else {
                result = this.analyze(nv21Data, width, height);
            }
            if (result != null) {
                FrameMetadata frameMetadata = new FrameMetadata(width, height, rotation);
                this.joinQueue.set(false);
                listener.onSuccess((Object)new AnalyzeResult(nv21Data, 17, frameMetadata, (Object)result));
            } else {
                this.queue.add(nv21Data);
                listener.onFailure(null);
            }
        }
        catch (Exception e) {
            this.queue.add(nv21Data);
            listener.onFailure(null);
        }
    }

    private void yuv_420_888toNv21(@NonNull ImageProxy image, byte[] nv21) {
        ImageProxy.PlaneProxy yPlane = image.getPlanes()[0];
        ImageProxy.PlaneProxy uPlane = image.getPlanes()[1];
        ImageProxy.PlaneProxy vPlane = image.getPlanes()[2];
        ByteBuffer yBuffer = yPlane.getBuffer();
        ByteBuffer uBuffer = uPlane.getBuffer();
        ByteBuffer vBuffer = vPlane.getBuffer();
        yBuffer.rewind();
        uBuffer.rewind();
        vBuffer.rewind();
        int ySize = yBuffer.remaining();
        int position = 0;
        for (int row = 0; row < image.getHeight(); ++row) {
            yBuffer.get(nv21, position, image.getWidth());
            position += image.getWidth();
            yBuffer.position(Math.min(ySize, yBuffer.position() - image.getWidth() + yPlane.getRowStride()));
        }
        int chromaHeight = image.getHeight() / 2;
        int chromaWidth = image.getWidth() / 2;
        int vRowStride = vPlane.getRowStride();
        int uRowStride = uPlane.getRowStride();
        int vPixelStride = vPlane.getPixelStride();
        int uPixelStride = uPlane.getPixelStride();
        byte[] vLineBuffer = new byte[vRowStride];
        byte[] uLineBuffer = new byte[uRowStride];
        for (int row = 0; row < chromaHeight; ++row) {
            vBuffer.get(vLineBuffer, 0, Math.min(vRowStride, vBuffer.remaining()));
            uBuffer.get(uLineBuffer, 0, Math.min(uRowStride, uBuffer.remaining()));
            int vLineBufferPosition = 0;
            int uLineBufferPosition = 0;
            for (int col = 0; col < chromaWidth; ++col) {
                nv21[position++] = vLineBuffer[vLineBufferPosition];
                nv21[position++] = uLineBuffer[uLineBufferPosition];
                vLineBufferPosition += vPixelStride;
                uLineBufferPosition += uPixelStride;
            }
        }
    }
}

