/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.Nullable;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.king.logx.LogX;
import com.king.zxing.DecodeConfig;
import com.king.zxing.analyze.AreaRectAnalyzer;
import java.util.Map;

public class MultiFormatAnalyzer
extends AreaRectAnalyzer {
    MultiFormatReader mReader;

    public MultiFormatAnalyzer() {
        this((DecodeConfig)null);
    }

    public MultiFormatAnalyzer(@Nullable Map<DecodeHintType, Object> hints) {
        this(new DecodeConfig().setHints(hints));
    }

    public MultiFormatAnalyzer(@Nullable DecodeConfig config) {
        super(config);
        this.initReader();
    }

    private void initReader() {
        this.mReader = new MultiFormatReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Result analyze(byte[] data, int dataWidth, int dataHeight, int left, int top, int width, int height) {
        Result rawResult = null;
        try {
            long start = System.currentTimeMillis();
            this.mReader.setHints(this.mHints);
            PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(data, dataWidth, dataHeight, left, top, width, height, false);
            rawResult = this.decodeInternal((LuminanceSource)source, this.isMultiDecode);
            if (rawResult == null && this.mDecodeConfig != null) {
                if (this.mDecodeConfig.isSupportVerticalCode()) {
                    byte[] rotatedData = new byte[data.length];
                    for (int y = 0; y < dataHeight; ++y) {
                        for (int x = 0; x < dataWidth; ++x) {
                            rotatedData[x * dataHeight + dataHeight - y - 1] = data[x + y * dataWidth];
                        }
                    }
                    rawResult = this.decodeInternal((LuminanceSource)new PlanarYUVLuminanceSource(rotatedData, dataHeight, dataWidth, top, left, height, width, false), this.mDecodeConfig.isSupportVerticalCodeMultiDecode());
                }
                if (rawResult == null && this.mDecodeConfig.isSupportLuminanceInvert()) {
                    rawResult = this.decodeInternal(source.invert(), this.mDecodeConfig.isSupportLuminanceInvertMultiDecode());
                }
            }
            if (rawResult != null) {
                long end = System.currentTimeMillis();
                LogX.d((String)("Found barcode in " + (end - start) + " ms"), (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mReader.reset();
        }
        return rawResult;
    }

    private Result decodeInternal(LuminanceSource source, boolean isMultiDecode) {
        Result result = null;
        try {
            try {
                result = this.mReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer(source)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isMultiDecode && result == null) {
                result = this.mReader.decodeWithState(new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer(source)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

