/* The following code was generated by JFlex 1.7.0 */

package com.github.jezza.lang;

import static com.github.jezza.lang.Tokens.*;

import java.io.StringReader;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>C:/Users/Jezza/Desktop/JavaProjects/toml/src/main/resources/toml.flex</tt>
 */
final class _TomlLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int S_BASIC_STRING = 2;
  public static final int S_BASIC_STRING_RECOVERY = 4;
  public static final int S_LITERAL_STRING = 6;
  public static final int S_ML_BASIC_STRING = 8;
  public static final int S_ML_LITERAL_STRING = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\35\1\2\1\0\1\3\1\1\22\0\1\31\1\36\1\37"+
    "\1\4\3\36\1\33\3\36\1\7\1\46\1\25\1\17\1\36\1\10"+
    "\1\16\6\14\2\5\1\26\2\36\1\47\3\36\4\12\1\20\1\12"+
    "\15\32\1\30\1\54\4\32\1\27\1\50\1\34\1\51\1\36\1\6"+
    "\1\36\1\24\1\15\2\12\1\43\1\23\2\32\1\21\2\32\1\44"+
    "\1\32\1\22\1\13\2\32\1\41\1\45\1\40\1\42\2\32\1\11"+
    "\1\32\1\27\1\52\1\36\1\53\1\36\1\0\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uffff\36\uff90\36";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\2\2\1\3\1\4\1\1\1\3\1\5"+
    "\4\4\1\6\1\7\1\4\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\17"+
    "\1\23\1\17\1\20\1\24\1\25\1\17\1\26\2\2"+
    "\1\3\1\4\1\0\1\4\1\3\1\0\1\3\2\0"+
    "\6\4\2\3\1\4\2\0\1\4\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\2\0\1\35\1\36\1\3\1\0"+
    "\2\37\1\0\1\4\2\0\1\37\5\0\1\40\1\41"+
    "\1\42\1\43\1\44\1\4\1\37\1\45\1\46\1\4"+
    "\2\0\1\47\1\50\1\3\1\0\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\4\2\45\2\46\1\51\2\0"+
    "\1\4\1\0\1\52\2\0\1\4\1\0\1\53\1\0"+
    "\1\4\2\0\1\4\1\54\1\0\1\4\2\0\1\55"+
    "\1\54\1\56\1\4\1\0\1\4\1\0\1\4\6\0"+
    "\1\57\2\0\1\60\1\0\1\57\3\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\55\0\132\0\207\0\264\0\341\0\132\0\u010e"+
    "\0\u013b\0\u0168\0\u0195\0\u01c2\0\u01ef\0\132\0\u021c\0\u0249"+
    "\0\u0276\0\u02a3\0\u02d0\0\u02fd\0\u032a\0\132\0\132\0\132"+
    "\0\132\0\132\0\132\0\132\0\u0357\0\u0384\0\132\0\132"+
    "\0\u03b1\0\132\0\u03de\0\u040b\0\u0438\0\132\0\u0465\0\u0492"+
    "\0\u04bf\0\132\0\u04ec\0\u0519\0\u0546\0\u0573\0\u05a0\0\u05cd"+
    "\0\u05fa\0\u0627\0\u0654\0\u0681\0\u06ae\0\u06db\0\u0708\0\u0735"+
    "\0\u0762\0\u078f\0\u07bc\0\u07e9\0\u0816\0\u0843\0\u0870\0\132"+
    "\0\132\0\132\0\132\0\132\0\132\0\u089d\0\u08ca\0\u08f7"+
    "\0\u0924\0\u0951\0\u097e\0\u09ab\0\u09d8\0\u0a05\0\u0a32\0\u0a5f"+
    "\0\u0a8c\0\u0ab9\0\u0ae6\0\u0b13\0\u0b40\0\u0b6d\0\u0b9a\0\u0bc7"+
    "\0\u0bf4\0\u0c21\0\u0195\0\u0195\0\u0c4e\0\u0c7b\0\u0ca8\0\u0cd5"+
    "\0\u0d02\0\u0d2f\0\u0d5c\0\132\0\132\0\u0d89\0\u0db6\0\u0de3"+
    "\0\u0e10\0\u0e3d\0\u0e6a\0\132\0\132\0\u0e97\0\u0ec4\0\132"+
    "\0\u0ef1\0\132\0\u0195\0\u0f1e\0\u0f4b\0\u0f78\0\u0fa5\0\u0195"+
    "\0\u0fd2\0\u0fff\0\u102c\0\u1059\0\132\0\u1086\0\u10b3\0\u10e0"+
    "\0\u110d\0\u113a\0\u1167\0\u1194\0\u11c1\0\u11ee\0\u121b\0\u1248"+
    "\0\u11ee\0\132\0\u1275\0\u12a2\0\u12cf\0\u12fc\0\u1329\0\u1356"+
    "\0\u1383\0\u13b0\0\u13dd\0\u140a\0\u1437\0\u1464\0\u1491\0\u14be"+
    "\0\132\0\u14eb\0\u1518\0\u1545\0\u1572\0\u159f";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\3\10\1\11\1\12\1\13\1\14\1\15\3\13"+
    "\1\12\1\13\1\12\1\16\1\13\1\17\1\20\1\21"+
    "\1\13\1\22\1\7\2\13\1\10\1\13\1\23\1\7"+
    "\1\10\1\7\1\24\1\25\5\13\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\13\4\34\30\35\1\36\1\34"+
    "\1\35\1\37\15\35\55\0\4\40\27\41\1\42\21\41"+
    "\1\0\33\43\1\44\2\43\1\45\15\43\1\46\32\47"+
    "\1\50\21\47\1\0\3\10\25\0\1\10\3\0\1\10"+
    "\17\0\1\11\1\51\1\52\52\11\5\0\1\53\1\54"+
    "\1\0\1\53\3\13\1\53\1\13\1\53\1\55\1\56"+
    "\5\13\1\0\2\13\1\0\1\13\5\0\3\13\1\56"+
    "\2\13\6\0\1\13\5\0\2\13\1\0\7\13\1\0"+
    "\6\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\1\57\1\0\1\60\1\61\3\0\1\57"+
    "\1\0\1\57\2\0\1\62\1\63\2\0\1\60\34\0"+
    "\1\53\1\54\1\0\1\53\1\64\1\13\1\65\1\53"+
    "\1\66\1\53\1\55\1\56\5\13\1\0\2\13\1\0"+
    "\1\13\5\0\3\13\1\56\2\13\6\0\1\13\5\0"+
    "\2\13\1\0\7\13\1\0\2\13\1\67\3\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\2\13\1\0\7\13\1\0\4\13\1\70\1\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\2\13\1\0\7\13\1\0\4\13\1\71\1\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\1\72\1\13\1\60\1\73\3\13\1\72\1\13\1\72"+
    "\1\0\1\13\1\17\1\20\2\13\1\74\1\0\2\13"+
    "\1\0\1\13\5\0\6\13\6\0\1\13\33\0\1\75"+
    "\60\0\1\76\22\0\2\13\1\0\7\13\1\0\6\13"+
    "\1\0\2\13\1\0\1\13\5\0\1\13\1\77\4\13"+
    "\6\0\1\13\4\0\30\35\2\0\1\35\1\0\15\35"+
    "\15\0\1\100\4\0\1\101\1\102\13\0\1\103\1\104"+
    "\1\105\1\106\11\0\1\107\4\0\27\41\1\0\21\41"+
    "\1\0\33\43\1\0\2\43\1\0\15\43\1\0\3\10"+
    "\11\0\1\100\4\0\1\101\1\102\5\0\1\10\3\0"+
    "\1\10\1\0\1\103\1\104\1\105\1\106\11\0\1\107"+
    "\37\0\1\110\16\0\32\47\1\0\21\47\33\0\1\111"+
    "\23\0\1\52\57\0\1\112\1\54\1\0\1\112\3\13"+
    "\1\112\1\13\1\112\1\55\1\56\5\13\1\113\2\13"+
    "\1\0\1\13\5\0\3\13\1\56\2\13\6\0\1\13"+
    "\5\0\1\72\1\13\1\0\1\72\3\13\1\72\1\13"+
    "\1\72\1\0\6\13\1\0\2\13\1\0\1\13\5\0"+
    "\6\13\6\0\1\13\5\0\1\114\2\0\1\114\3\0"+
    "\1\114\1\0\1\114\43\0\1\115\1\13\1\116\1\115"+
    "\3\13\1\115\1\13\1\115\1\0\5\13\1\117\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\1\57\1\120\1\0\1\57\3\0\1\57\1\0\1\57"+
    "\1\55\1\121\22\0\1\121\16\0\1\122\2\0\1\122"+
    "\3\0\1\122\1\0\1\122\43\0\1\57\1\120\1\0"+
    "\1\57\1\123\1\0\1\124\1\57\1\125\1\57\1\55"+
    "\1\121\22\0\1\121\33\0\1\126\56\0\1\127\35\0"+
    "\1\130\1\13\1\0\1\130\1\13\1\130\1\13\3\130"+
    "\1\0\1\130\2\13\2\130\1\13\1\0\2\13\1\0"+
    "\1\13\5\0\3\13\1\130\2\13\6\0\1\13\5\0"+
    "\2\13\1\0\1\131\3\13\1\131\1\13\1\131\1\0"+
    "\6\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\2\13\1\0\1\132\5\13\1\132\1\0"+
    "\6\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\2\13\1\0\7\13\1\0\3\13\1\133"+
    "\2\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\2\13\1\0\7\13\1\0\2\13\1\134"+
    "\3\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\2\13\1\0\7\13\1\0\6\13\1\0"+
    "\2\13\1\0\1\13\5\0\4\13\1\135\1\13\6\0"+
    "\1\13\5\0\1\72\1\54\1\0\1\72\3\13\1\72"+
    "\1\13\1\72\1\55\1\56\5\13\1\0\2\13\1\0"+
    "\1\13\5\0\3\13\1\56\2\13\6\0\1\13\5\0"+
    "\1\72\1\54\1\0\1\72\1\64\1\13\1\65\1\72"+
    "\1\66\1\72\1\55\1\56\5\13\1\0\2\13\1\0"+
    "\1\13\5\0\3\13\1\56\2\13\6\0\1\13\5\0"+
    "\1\136\1\13\1\0\1\136\3\13\1\136\1\13\1\136"+
    "\1\0\6\13\1\0\2\13\1\0\1\13\5\0\6\13"+
    "\6\0\1\13\33\0\1\137\60\0\1\140\22\0\2\13"+
    "\1\0\7\13\1\0\6\13\1\0\2\13\1\0\1\13"+
    "\5\0\2\13\1\141\3\13\6\0\1\13\5\0\1\142"+
    "\2\0\1\142\1\0\1\142\1\0\3\142\1\0\1\142"+
    "\2\0\2\142\16\0\1\142\16\0\1\143\2\0\1\143"+
    "\1\0\1\143\1\0\3\143\1\0\1\143\2\0\2\143"+
    "\16\0\1\143\50\0\1\144\50\0\1\145\26\0\1\146"+
    "\1\54\1\0\1\146\3\13\1\146\1\13\1\146\1\55"+
    "\1\56\5\13\1\0\2\13\1\0\1\13\5\0\3\13"+
    "\1\56\2\13\6\0\1\13\5\0\1\147\2\0\1\147"+
    "\3\0\1\147\1\0\1\147\43\0\1\114\1\55\1\0"+
    "\1\114\3\0\1\114\1\0\1\114\1\0\1\121\22\0"+
    "\1\121\16\0\1\115\1\117\1\0\1\115\3\13\1\115"+
    "\1\13\1\115\1\0\6\13\1\0\2\13\1\0\1\13"+
    "\5\0\6\13\6\0\1\13\5\0\1\150\2\0\1\150"+
    "\3\0\1\150\1\0\1\150\43\0\1\115\1\13\1\0"+
    "\1\115\3\13\1\115\1\13\1\115\1\0\6\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\1\57\2\0\1\57\3\0\1\57\1\0\1\57\43\0"+
    "\1\150\1\0\1\116\1\150\3\0\1\150\1\0\1\150"+
    "\6\0\1\116\34\0\1\122\1\60\1\0\1\122\3\0"+
    "\1\122\1\0\1\122\1\55\1\121\22\0\1\121\16\0"+
    "\1\151\2\0\1\151\1\0\1\151\1\0\3\151\1\0"+
    "\1\151\2\0\2\151\16\0\1\151\21\0\1\152\3\0"+
    "\1\152\1\0\1\152\46\0\1\153\5\0\1\153\61\0"+
    "\1\154\53\0\1\155\37\0\1\130\1\64\1\0\1\130"+
    "\1\13\1\130\1\13\3\130\1\0\1\130\2\13\2\130"+
    "\1\13\1\0\2\13\1\0\1\13\5\0\3\13\1\130"+
    "\2\13\6\0\1\13\5\0\1\13\1\65\1\0\1\131"+
    "\3\13\1\131\1\13\1\131\1\0\6\13\1\0\2\13"+
    "\1\0\1\13\5\0\6\13\6\0\1\13\5\0\1\13"+
    "\1\66\1\0\1\132\5\13\1\132\1\0\6\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\2\13\1\0\7\13\1\0\6\13\1\0\2\13\1\0"+
    "\1\13\5\0\5\13\1\156\6\0\1\13\5\0\1\136"+
    "\1\74\1\0\1\136\3\13\1\136\1\13\1\136\1\55"+
    "\1\56\5\13\1\0\2\13\1\0\1\13\5\0\3\13"+
    "\1\56\2\13\6\0\1\13\1\0\1\157\1\160\53\0"+
    "\1\161\1\162\57\0\2\13\1\0\7\13\1\0\6\13"+
    "\1\0\2\13\1\0\1\13\5\0\3\13\1\163\2\13"+
    "\6\0\1\13\5\0\1\164\2\0\1\164\1\0\1\164"+
    "\1\0\3\164\1\0\1\164\2\0\2\164\16\0\1\164"+
    "\16\0\1\165\2\0\1\165\1\0\1\165\1\0\3\165"+
    "\1\0\1\165\2\0\2\165\16\0\1\165\16\0\1\72"+
    "\1\54\1\0\1\72\3\13\1\72\1\13\1\72\1\55"+
    "\1\56\4\13\1\166\1\0\2\13\1\0\1\13\5\0"+
    "\3\13\1\56\2\13\6\0\1\13\5\0\1\167\2\0"+
    "\1\167\3\0\1\167\1\0\1\167\43\0\1\150\1\116"+
    "\1\0\1\150\3\0\1\150\1\0\1\150\43\0\1\151"+
    "\1\123\1\0\1\151\1\0\1\151\1\0\3\151\1\0"+
    "\1\151\2\0\2\151\16\0\1\151\17\0\1\124\1\0"+
    "\1\152\3\0\1\152\1\0\1\152\44\0\1\125\1\0"+
    "\1\153\5\0\1\153\43\0\2\13\1\0\7\13\1\0"+
    "\6\13\1\0\2\13\1\0\1\13\5\0\3\13\1\170"+
    "\2\13\6\0\1\13\2\0\1\160\54\0\1\162\57\0"+
    "\1\171\2\0\1\171\1\0\1\171\1\0\3\171\1\0"+
    "\1\171\2\0\2\171\16\0\1\171\16\0\1\172\2\0"+
    "\1\172\1\0\1\172\1\0\3\172\1\0\1\172\2\0"+
    "\2\172\16\0\1\172\16\0\1\173\1\13\1\0\1\173"+
    "\3\13\1\173\1\13\1\173\1\0\6\13\1\0\2\13"+
    "\1\0\1\13\5\0\6\13\6\0\1\13\26\0\1\174"+
    "\33\0\1\175\2\0\1\175\1\0\1\175\1\0\3\175"+
    "\1\0\1\175\2\0\2\175\16\0\1\175\16\0\1\176"+
    "\2\0\1\176\1\0\1\176\1\0\3\176\1\0\1\176"+
    "\2\0\2\176\16\0\1\176\16\0\1\177\1\13\1\0"+
    "\1\177\3\13\1\177\1\13\1\177\1\0\6\13\1\0"+
    "\2\13\1\0\1\13\5\0\6\13\6\0\1\13\5\0"+
    "\1\200\2\0\1\200\3\0\1\200\1\0\1\200\43\0"+
    "\1\201\2\0\1\201\1\0\1\201\1\0\3\201\1\0"+
    "\1\201\2\0\2\201\16\0\1\201\16\0\2\13\1\0"+
    "\7\13\1\0\5\13\1\202\1\0\2\13\1\0\1\13"+
    "\5\0\6\13\6\0\1\13\5\0\1\203\2\0\1\203"+
    "\3\0\1\203\1\0\1\203\43\0\1\204\2\0\1\204"+
    "\1\0\1\204\1\0\3\204\1\0\1\204\2\0\2\204"+
    "\16\0\1\204\16\0\1\205\1\13\1\0\1\205\3\13"+
    "\1\205\1\13\1\205\1\0\6\13\1\0\2\13\1\0"+
    "\1\13\5\0\6\13\6\0\1\13\17\0\1\206\42\0"+
    "\1\207\2\0\1\207\1\0\1\207\1\0\3\207\1\0"+
    "\1\207\2\0\2\207\16\0\1\207\16\0\1\210\1\13"+
    "\1\0\1\210\3\13\1\210\1\13\1\210\1\0\6\13"+
    "\1\0\2\13\1\0\1\13\5\0\6\13\6\0\1\13"+
    "\5\0\1\211\2\0\1\211\3\0\1\211\1\0\1\211"+
    "\43\0\1\212\2\0\1\212\1\0\1\212\1\0\3\212"+
    "\1\0\1\212\2\0\2\212\16\0\1\212\16\0\2\13"+
    "\1\0\7\13\1\0\6\13\1\0\1\13\1\213\1\214"+
    "\1\13\5\0\1\213\5\13\6\0\1\13\5\0\1\215"+
    "\1\13\1\0\1\215\3\13\1\215\1\13\1\215\1\0"+
    "\6\13\1\0\2\13\1\0\1\13\5\0\6\13\6\0"+
    "\1\13\5\0\1\216\2\0\1\216\3\0\1\216\1\0"+
    "\1\216\43\0\1\217\1\13\1\0\1\217\3\13\1\217"+
    "\1\13\1\217\1\0\6\13\1\0\2\13\1\0\1\13"+
    "\5\0\6\13\6\0\1\13\5\0\1\220\2\0\1\220"+
    "\3\0\1\220\1\0\1\220\43\0\2\13\1\0\7\13"+
    "\1\0\6\13\1\221\2\13\1\0\1\13\5\0\6\13"+
    "\6\0\1\13\26\0\1\221\33\0\1\222\2\0\1\222"+
    "\3\0\1\222\1\0\1\222\43\0\1\223\2\0\1\223"+
    "\3\0\1\223\1\0\1\223\64\0\1\224\33\0\1\225"+
    "\2\0\1\225\3\0\1\225\1\0\1\225\43\0\1\226"+
    "\2\0\1\226\3\0\1\226\1\0\1\226\45\0\1\227"+
    "\7\0\1\230\5\0\1\227\1\0\1\231\32\0\1\232"+
    "\2\0\1\232\3\0\1\232\1\0\1\232\43\0\1\233"+
    "\2\0\1\233\3\0\1\233\1\0\1\233\43\0\1\234"+
    "\2\0\1\234\3\0\1\234\1\0\1\234\43\0\1\233"+
    "\1\0\1\227\1\233\3\0\1\233\1\0\1\233\6\0"+
    "\1\227\1\0\1\231\53\0\1\235\33\0\1\236\2\0"+
    "\1\236\3\0\1\236\1\0\1\236\43\0\1\231\2\0"+
    "\1\231\3\0\1\231\1\0\1\231\36\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[5580];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\10\3\0\1\11\6\1\1\11\7\1\7\11"+
    "\2\1\2\11\1\1\1\11\3\1\1\11\3\1\1\11"+
    "\2\1\1\0\2\1\1\0\1\1\2\0\11\1\2\0"+
    "\1\1\6\11\2\0\3\1\1\0\2\1\1\0\1\1"+
    "\2\0\1\1\5\0\12\1\2\0\2\11\1\1\1\0"+
    "\4\1\2\11\2\1\1\11\1\1\1\11\1\1\2\0"+
    "\1\1\1\0\1\1\2\0\1\1\1\0\1\11\1\0"+
    "\1\1\2\0\2\1\1\0\1\1\2\0\2\1\1\11"+
    "\1\1\1\0\1\1\1\0\1\1\6\0\1\1\2\0"+
    "\1\11\1\0\1\1\3\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[158];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true iff the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true iff the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
	private final StringBuilder string = new StringBuilder(32);
	private int lineStart;

	public _TomlLexer(String in) {
		this(new StringReader(in));
	}


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _TomlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 168) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          { 	return Token.EOS;
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return new Token(BAD_CHARACTER, yyline, yycolumn, yytext());
            } 
            // fall through
          case 49: break;
          case 2: 
            { 
            } 
            // fall through
          case 50: break;
          case 3: 
            { return new Token(INTEGER_DEC, yyline, yycolumn, yytext());
            } 
            // fall through
          case 51: break;
          case 4: 
            { return new Token(KEY, yyline, yycolumn, yytext());
            } 
            // fall through
          case 52: break;
          case 5: 
            { return new Token(DOT, yyline, yycolumn, ".");
            } 
            // fall through
          case 53: break;
          case 6: 
            { string.setLength(0); yybegin(S_LITERAL_STRING);
            } 
            // fall through
          case 54: break;
          case 7: 
            { string.setLength(0); yybegin(S_BASIC_STRING);
            } 
            // fall through
          case 55: break;
          case 8: 
            { return new Token(COMMA, yyline, yycolumn, ",");
            } 
            // fall through
          case 56: break;
          case 9: 
            { return new Token(EQ, yyline, yycolumn, "=");
            } 
            // fall through
          case 57: break;
          case 10: 
            { return new Token(LBRACKET, yyline, yycolumn, "[");
            } 
            // fall through
          case 58: break;
          case 11: 
            { return new Token(RBRACKET, yyline, yycolumn, "]");
            } 
            // fall through
          case 59: break;
          case 12: 
            { return new Token(LBRACE, yyline, yycolumn, "{");
            } 
            // fall through
          case 60: break;
          case 13: 
            { return new Token(RBRACE, yyline, yycolumn, "}");
            } 
            // fall through
          case 61: break;
          case 14: 
            { yybegin(YYINITIAL);
						 return new Token(STRING_POISON, yyline, yycolumn, string.toString());
            } 
            // fall through
          case 62: break;
          case 15: 
            { string.append(yytext());
            } 
            // fall through
          case 63: break;
          case 16: 
            { string.append('\\');
            } 
            // fall through
          case 64: break;
          case 17: 
            { yybegin(YYINITIAL);
                         return new Token(STRING, yyline, yycolumn, string.toString());
            } 
            // fall through
          case 65: break;
          case 18: 
            { yybegin(YYINITIAL);
                               return new Token(STRING_POISON, yyline, yycolumn, string.toString());
            } 
            // fall through
          case 66: break;
          case 19: 
            { yybegin(YYINITIAL);
                               return new Token(STRING, yyline, yycolumn, string.toString());
            } 
            // fall through
          case 67: break;
          case 20: 
            { string.append('"');
            } 
            // fall through
          case 68: break;
          case 21: 
            { yybegin(YYINITIAL);
                                  return new Token(ML_STRING_POISON, lineStart, yycolumn, string.toString());
            } 
            // fall through
          case 69: break;
          case 22: 
            { string.append('\'');
            } 
            // fall through
          case 70: break;
          case 23: 
            { string.append('\b');
            } 
            // fall through
          case 71: break;
          case 24: 
            { string.append('\n');
            } 
            // fall through
          case 72: break;
          case 25: 
            { string.append('\f');
            } 
            // fall through
          case 73: break;
          case 26: 
            { string.append('\"');
            } 
            // fall through
          case 74: break;
          case 27: 
            { string.append('\t');
            } 
            // fall through
          case 75: break;
          case 28: 
            { string.append('\r');
            } 
            // fall through
          case 76: break;
          case 29: 
            { string.append("\"\"");
            } 
            // fall through
          case 77: break;
          case 30: 
            { string.append("''");
            } 
            // fall through
          case 78: break;
          case 31: 
            { return new Token(FLOAT, yyline, yycolumn, yytext());
            } 
            // fall through
          case 79: break;
          case 32: 
            { return new Token(INTEGER_HEX, yyline, yycolumn, yytext());
            } 
            // fall through
          case 80: break;
          case 33: 
            { return new Token(INTEGER_OCT, yyline, yycolumn, yytext());
            } 
            // fall through
          case 81: break;
          case 34: 
            { return new Token(INTEGER_BIN, yyline, yycolumn, yytext());
            } 
            // fall through
          case 82: break;
          case 35: 
            { return new Token(INF, yyline, yycolumn, yytext());
            } 
            // fall through
          case 83: break;
          case 36: 
            { return new Token(NAN, yyline, yycolumn, yytext());
            } 
            // fall through
          case 84: break;
          case 37: 
            { string.setLength(0); lineStart = yyline; yybegin(S_ML_LITERAL_STRING);
            } 
            // fall through
          case 85: break;
          case 38: 
            { string.setLength(0); lineStart = yyline; yybegin(S_ML_BASIC_STRING);
            } 
            // fall through
          case 86: break;
          case 39: 
            { yybegin(YYINITIAL);
                                     return new Token(ML_STRING, lineStart, yycolumn, string.toString());
            } 
            // fall through
          case 87: break;
          case 40: 
            { yybegin(YYINITIAL);
                                  return new Token(ML_STRING, lineStart, yycolumn, string.toString());
            } 
            // fall through
          case 88: break;
          case 41: 
            { return new Token(TRUE, yyline, yycolumn, "true");
            } 
            // fall through
          case 89: break;
          case 42: 
            { return new Token(FALSE, yyline, yycolumn, "false");
            } 
            // fall through
          case 90: break;
          case 43: 
            { string.append((char) Integer.parseInt(yytext().substring(2), 16));
            } 
            // fall through
          case 91: break;
          case 44: 
            { return new Token(LOCAL_TIME, yyline, yycolumn, yytext());
            } 
            // fall through
          case 92: break;
          case 45: 
            { return new Token(LOCAL_DATE, yyline, yycolumn, yytext());
            } 
            // fall through
          case 93: break;
          case 46: 
            { string.append(Character.toChars(Integer.parseInt(yytext().substring(2), 16)));
            } 
            // fall through
          case 94: break;
          case 47: 
            { return new Token(LOCAL_DATE_TIME, yyline, yycolumn, yytext());
            } 
            // fall through
          case 95: break;
          case 48: 
            { return new Token(OFFSET_DATE_TIME, yyline, yycolumn, yytext());
            } 
            // fall through
          case 96: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
