/*
 * Decompiled with CFR 0.152.
 */
package com.github.jezza;

import com.github.jezza.TomlTable;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class TomlArray
implements List<Object> {
    private final List<Object> array;

    public TomlArray() {
        this(new ArrayList<Object>(0));
    }

    public TomlArray(int initialCapacity) {
        this(new ArrayList<Object>(initialCapacity));
    }

    public TomlArray(List<Object> array) {
        this.array = Objects.requireNonNull(array);
    }

    public List<Object> asList() {
        return this.array;
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.array.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.array.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.array.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.array.toArray(a);
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public boolean add(Object value) {
        return this.array.add(value);
    }

    @Override
    public boolean remove(Object o) {
        return this.array.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.array.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.array.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        return this.array.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.array.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.array.retainAll(c);
    }

    @Override
    public void clear() {
        this.array.clear();
    }

    @Override
    public Object get(int index) {
        return this.array.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        return this.array.set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        this.array.add(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.array.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.array.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.array.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.array.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.array.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.array.subList(fromIndex, toIndex);
    }

    void write(StringBuilder b, int indent, int increment) {
        if (this.array.isEmpty()) {
            b.append("[]");
            return;
        }
        b.append("[\n");
        for (Object value : this.array) {
            int l = indent * increment;
            for (int i = 0; i < l; ++i) {
                b.append(' ');
            }
            if (value instanceof TomlTable) {
                ((TomlTable)value).write(b, indent + increment, increment);
            } else if (value instanceof TomlArray) {
                ((TomlArray)value).write(b, indent + increment, increment);
            } else if (value instanceof TemporalAccessor) {
                TemporalAccessor accessor = (TemporalAccessor)value;
                b.append(accessor.query(TemporalQueries.chronology())).append(':').append(accessor.query(TemporalQueries.localDate())).append(':').append(accessor.query(TemporalQueries.localTime())).append(':').append(accessor.query(TemporalQueries.precision())).append(':').append(accessor.query(TemporalQueries.zone()));
            } else if (value instanceof String) {
                b.append('\"').append(value).append('\"');
            } else {
                b.append(value);
            }
            b.append(',').append('\n');
        }
        int v = (indent - increment) * increment;
        if (v > 0) {
            for (int i = 0; i < v; ++i) {
                b.append(' ');
            }
        }
        b.append(']');
    }

    public String toString() {
        StringBuilder b = new StringBuilder("TomlArray ");
        this.write(b, 2, 2);
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TomlArray other = (TomlArray)o;
        return this.array.equals(other.array);
    }

    @Override
    public int hashCode() {
        return this.array.hashCode();
    }
}

