/*
 * Decompiled with CFR 0.152.
 */
package com.github.jezza.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Strings {
    private static final String OBJECT_REP = "{}";
    private static final int OBJECT_REP_LENGTH = 2;

    private Strings() {
        throw new IllegalStateException();
    }

    public static boolean useable(CharSequence input) {
        return input != null && input.length() > 0 && input.chars().anyMatch(i -> i > 32);
    }

    public static String format(String input, Object ... objects) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        if (length == 0) {
            return "";
        }
        if (objects == null || objects.length == 0) {
            return input;
        }
        int start = input.indexOf(OBJECT_REP);
        if (start == -1) {
            return input;
        }
        StringBuilder b = new StringBuilder(input.length());
        int index = 0;
        int end = 0;
        do {
            if (end < start) {
                b.append(input, end, start);
            }
            end = start + 2;
            b.append(objects[index++]);
        } while (index < objects.length && (start = input.indexOf(OBJECT_REP, end)) != -1);
        if (end < length) {
            b.append(input, end, length);
        }
        return b.toString();
    }

    public static List<String> split(String input) {
        int mark;
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        int index = input.indexOf(46);
        if (index == -1) {
            return Collections.singletonList(input);
        }
        String[] segments = new String[]{input.substring(0, index)};
        while ((index = input.indexOf(46, mark = index + 1)) != -1) {
            String segment = input.substring(mark, index);
            int length = segments.length;
            segments = Arrays.copyOf(segments, length + 1);
            segments[length] = segment;
        }
        if (mark != input.length()) {
            int length = segments.length;
            segments = Arrays.copyOf(segments, length + 1);
            segments[length] = input.substring(mark);
        }
        return Arrays.asList(segments);
    }
}

