/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class AttrList
implements Iterable<Attr>,
Comparable<AttrList> {
    private static final Comparator<Attr> cmp = new Comparator<Attr>(){

        @Override
        public int compare(Attr o1, Attr o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            int cmpNames = o1.getName().compareTo(o2.getName());
            if (cmpNames != 0) {
                return cmpNames;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    };
    private final int length;
    private final List<Attr> attrs;

    static AttrList create(NamedNodeMap attributes) {
        int l = attributes.getLength();
        ArrayList<Attr> as = new ArrayList<Attr>(l);
        for (int i = 0; i < l; ++i) {
            as.add((Attr)attributes.item(i));
        }
        return new AttrList(as);
    }

    AttrList(List<Attr> attrs) {
        this.length = attrs.size();
        this.attrs = attrs;
        Collections.sort(this.attrs, cmp);
    }

    public int size() {
        return this.length;
    }

    @Override
    public Iterator<Attr> iterator() {
        return this.attrs.iterator();
    }

    public String toString() {
        return this.attrs.toString();
    }

    public int hashCode() {
        return this.attrs.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttrList)) {
            return false;
        }
        AttrList other = (AttrList)o;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(AttrList other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this == other) {
            return 0;
        }
        if (this.length != other.length) {
            return this.length - other.length;
        }
        Iterator<Attr> i1 = this.attrs.iterator();
        Iterator<Attr> i2 = other.attrs.iterator();
        while (i1.hasNext()) {
            int c = cmp.compare(i1.next(), i2.next());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

