/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.github.jferard.fastods.testlib.Computations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

public abstract class Bench {
    private final int colCount;
    private final Logger logger;
    private final Random random;
    private final int rowCount;
    private final List<Long> times;
    private final String name;

    public Bench(Logger logger, String name, int rowCount, int colCount) {
        this.logger = logger;
        this.name = name;
        this.rowCount = rowCount;
        this.colCount = colCount;
        this.times = new ArrayList<Long>();
        this.random = new Random();
    }

    public Computations getWithWarmUp() {
        return new Computations(this.name, this.times.subList(2, this.times.size()));
    }

    public Computations getWithoutWarmUp() {
        return new Computations(this.name, this.times);
    }

    public void iteration() throws IOException {
        this.times.add(this.test());
    }

    public abstract long test() throws IOException;

    protected int getColCount() {
        return this.colCount;
    }

    protected Random getRandom() {
        return this.random;
    }

    protected int getRowCount() {
        return this.rowCount;
    }
}

