/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.github.jferard.fastods.testlib.AttrList;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Stack;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ChildrenTester {
    protected final Stack<String> state1 = new Stack();
    protected final Stack<String> state2 = new Stack();
    private String firstDifference = null;

    protected ChildrenTester() {
    }

    protected boolean attributesEquals(Node element1, Node element2) {
        if (element1 == element2) {
            return true;
        }
        NamedNodeMap attributes1 = element1.getAttributes();
        NamedNodeMap attributes2 = element2.getAttributes();
        if (attributes1 == null) {
            if (attributes2 != null) {
                this.logFail("Node %s has attributes while node %s hasn't", new Object[0]);
                return false;
            }
        } else {
            AttrList list2;
            int l2;
            if (attributes2 == null) {
                this.logFail("Node %s has no attribute while node %s has some", new Object[0]);
                return false;
            }
            int l1 = attributes1.getLength();
            if (l1 != (l2 = attributes2.getLength())) {
                this.logFail("Different attributes number: %s vs %s (%d vs %d)", l1, l2);
                return false;
            }
            AttrList list1 = AttrList.create(attributes1);
            if (!list1.equals(list2 = AttrList.create(attributes2))) {
                this.logFail("Different attributes: %s vs %s (%s vs %s)", list1, list2);
                return false;
            }
        }
        return true;
    }

    private boolean namesEquals(Node element1, Node element2) {
        boolean typesEqual;
        boolean bl = typesEqual = element1.getNodeType() == element2.getNodeType();
        if (!typesEqual) {
            this.logFail("Different nodes types: %s vs %s", new Object[0]);
            return false;
        }
        boolean namesEqual = Objects.equal((Object)element1.getNodeName(), (Object)element2.getNodeName());
        if (!namesEqual) {
            this.logFail("Different nodes names: %s vs %s", new Object[0]);
            return false;
        }
        boolean valuesEqual = Objects.equal((Object)element1.getNodeValue(), (Object)element2.getNodeValue());
        if (!valuesEqual) {
            this.logFail("Different nodes values: %s vs %s", new Object[0]);
            return false;
        }
        boolean nsURIEqual = Objects.equal((Object)element1.getNamespaceURI(), (Object)element2.getNamespaceURI());
        if (!nsURIEqual) {
            this.logFail("Different nodes namespaces: %s vs %s", new Object[0]);
            return false;
        }
        return true;
    }

    boolean equals(Node element1, Node element2) {
        if (element1 == null) {
            return element2 == null;
        }
        if (element2 == null) {
            return false;
        }
        this.pushNode(this.state1, element1);
        this.pushNode(this.state2, element2);
        boolean ne = this.namesEquals(element1, element2);
        boolean ae = this.attributesEquals(element1, element2);
        boolean ce = this.childrenEquals(element1, element2);
        this.state1.pop();
        this.state2.pop();
        return ne && ae && ce;
    }

    private void pushNode(Stack<String> state1, Node element1) {
        if (element1.getNodeType() == 3) {
            state1.push(element1.getNodeValue());
        } else {
            state1.push(element1.getNodeName());
        }
    }

    public abstract boolean childrenEquals(Node var1, Node var2);

    private String getStateStr(Stack<String> p) {
        if (p.size() <= 1) {
            return "<root>";
        }
        return Joiner.on((String)"/").join(p.subList(1, p.size()));
    }

    protected void logFail(String format, Object ... extra) {
        Object[] objects = Iterables.toArray((Iterable)Iterables.concat(Arrays.asList(this.getStateStr(this.state1), this.getStateStr(this.state2)), Arrays.asList(extra)), Object.class);
        this.firstDifference = String.format(format, objects);
    }

    public Optional<String> getFirstDifference() {
        return Optional.fromNullable((Object)this.firstDifference);
    }

    public void setFirstDifference(String difference) {
        this.firstDifference = difference;
    }
}

