/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.google.common.base.Joiner;
import java.util.ArrayList;

public class CodePointTester {
    private static final int FIRST_ASCII_PRINTABLE_CHAR = 32;
    private static final int LAST_ASCII_PRINTABLE_CHAR = 127;

    public static String codePointsAsString(CategoryFilter filter) {
        int i;
        ArrayList<String> segments = new ArrayList<String>();
        int from = -1;
        for (i = 0; i <= 0x10FFFF; ++i) {
            if (filter.check(i)) {
                if (from != -1) continue;
                from = i;
                continue;
            }
            if (from < 0) continue;
            segments.add(CodePointTester.format(from, i - 1));
            from = -1;
        }
        if (from >= 0) {
            segments.add(CodePointTester.format(from, i));
        }
        return Joiner.on((String)" | ").join(segments);
    }

    private static String format(int from, int to) {
        if (from == to) {
            return CodePointTester.formatChar("'%c'", "#x%x", from);
        }
        return CodePointTester.formatChar("[%c-", "[#x%x-", from) + CodePointTester.formatChar("%c]", "#x%x]", to);
    }

    private static String formatChar(String printableFormat, String nonPrintableFormat, int from) {
        if (32 <= from && from <= 127) {
            return String.format(printableFormat, from);
        }
        return String.format(nonPrintableFormat, from);
    }

    public static interface CategoryFilter {
        public boolean check(int var1);
    }
}

