/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import java.util.Collections;
import java.util.List;

public class Computations {
    private final String name;
    private final List<Long> times;

    public Computations(String name, List<Long> times) {
        this.name = name;
        this.times = times;
    }

    public long getAvgTime() {
        if (this.times.isEmpty()) {
            return -1L;
        }
        long l = 0L;
        for (long time : this.times) {
            l += time;
        }
        return l / (long)this.times.size();
    }

    public long getBestTime() {
        if (this.times.isEmpty()) {
            return -1L;
        }
        return Collections.min(this.times);
    }

    public long getWorstTime() {
        if (this.times.isEmpty()) {
            return -1L;
        }
        return Collections.max(this.times);
    }

    public String toString() {
        return "Computations[name = " + this.name + ", avg = " + this.getAvgTime() + ", best = " + this.getBestTime() + ", worst = " + this.getWorstTime() + "]";
    }
}

