/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.github.jferard.fastods.testlib.ChildrenTester;
import com.github.jferard.fastods.testlib.SortedChildrenTester;
import com.github.jferard.fastods.testlib.UnsortedChildrenTester;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DomTester {
    private final Charset UTF_8 = Charset.forName("UTF-8");
    private final DocumentBuilder builder;

    public static void assertEquals(String expected, String actual) {
        DomTester.assertEquals(expected, actual, new SortedChildrenTester());
    }

    public static void assertUnsortedEquals(String expected, String actual) {
        DomTester.assertEquals(expected, actual, new UnsortedChildrenTester());
    }

    public static void assertEquals(String expected, String actual, ChildrenTester childrenTester) {
        if (!DomTester.equals(expected, actual, childrenTester)) {
            throw new AssertionError(childrenTester.getFirstDifference().get());
        }
    }

    public static void assertNotEquals(String expected, String actual) {
        DomTester.assertNotEquals(expected, actual, new SortedChildrenTester());
    }

    public static void assertUnsortedNotEquals(String expected, String actual) {
        DomTester.assertNotEquals(expected, actual, new UnsortedChildrenTester());
    }

    public static void assertNotEquals(String expected, String actual, ChildrenTester childrenTester) {
        if (DomTester.equals(expected, actual, childrenTester)) {
            throw new AssertionError((Object)String.format("XML contents %s and %s where equal", DomTester.getEllipsis(expected), DomTester.getEllipsis(actual)));
        }
    }

    private static String getEllipsis(String str) {
        int length = str.length();
        if (length < 20) {
            return str;
        }
        return str.substring(0, 20) + "...";
    }

    public static boolean equals(String s1, String s2) {
        return DomTester.equals(s1, s2, new SortedChildrenTester());
    }

    public static boolean unsortedEquals(String s1, String s2) {
        return DomTester.equals(s1, s2, new UnsortedChildrenTester());
    }

    public static boolean equals(String s1, String s2, ChildrenTester childrenTester) {
        try {
            DomTester tester = new DomTester();
            return tester.stringEquals(s1, s2, childrenTester);
        }
        catch (Throwable e) {
            childrenTester.setFirstDifference(e.toString());
            return false;
        }
    }

    DomTester() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
    }

    private boolean stringEquals(String s1, String s2, ChildrenTester childrenTester) throws SAXException, IOException {
        Document document1 = this.builder.parse(new ByteArrayInputStream(("<domtesterroot>" + s1 + "</domtesterroot>").getBytes(this.UTF_8)));
        Document document2 = this.builder.parse(new ByteArrayInputStream(("<domtesterroot>" + s2 + "</domtesterroot>").getBytes(this.UTF_8)));
        Element element1 = document1.getDocumentElement();
        Element element2 = document2.getDocumentElement();
        return childrenTester.equals(element1, element2);
    }
}

