/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class OdfToolkitUtil {
    private OdfToolkitUtil() {
    }

    public static String getStringValue(Cell cell) {
        return cell.getOdfElement().getOfficeStringValueAttribute();
    }

    public static String getParentStyleName(Cell cell) {
        return cell.getOdfElement().getAutomaticStyle().getStyleParentStyleNameAttribute();
    }

    public static OdfStyle getDocumentStyle(SpreadsheetDocument document, String styleName, OdfStyleFamily styleFamily) throws Exception {
        return document.getStylesDom().getOfficeStyles().getStyle(styleName, styleFamily);
    }

    public static Node getFirstElement(Element element, String tagName) {
        return element.getElementsByTagName(tagName).item(0);
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes.getNamedItem(attributeName).getTextContent();
    }

    public static String getStyleName(Cell cell) {
        return cell.getOdfElement().getStyleName();
    }

    public static String getStyleFamilyName(Cell cell) {
        return cell.getOdfElement().getStyleFamily().getName();
    }
}

