/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.github.jferard.fastods.testlib.AttrList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnsortedNodeList
implements Iterable<Node>,
Comparable<UnsortedNodeList> {
    static final Comparator<Node> cmp = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            int cmpType = o1.getNodeType() - o2.getNodeType();
            if (cmpType != 0) {
                return cmpType;
            }
            int cmpName = o1.getNodeName().compareTo(o2.getNodeName());
            if (cmpName != 0) {
                return cmpName;
            }
            NamedNodeMap attributes1 = o1.getAttributes();
            NamedNodeMap attributes2 = o2.getAttributes();
            if (attributes1 == null) {
                return attributes2 == null ? 0 : 1;
            }
            if (attributes2 == null) {
                return -1;
            }
            int cmpAttrs = AttrList.create(attributes1).compareTo(AttrList.create(attributes2));
            if (cmpAttrs != 0) {
                return cmpAttrs;
            }
            return 0;
        }
    };
    private final int length;
    private final List<Node> list;

    UnsortedNodeList(NodeList nodes) {
        this.length = nodes.getLength();
        this.list = new ArrayList<Node>(this.length);
        for (int i = 0; i < this.length; ++i) {
            this.list.add(nodes.item(i));
        }
        Collections.sort(this.list, cmp);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.list.iterator();
    }

    @Override
    public int compareTo(UnsortedNodeList other) {
        if (this.length != other.length) {
            return this.length - other.length;
        }
        Iterator<Node> i1 = this.list.iterator();
        Iterator<Node> i2 = other.list.iterator();
        while (i1.hasNext()) {
            int c = cmp.compare(i1.next(), i2.next());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsortedNodeList)) {
            return false;
        }
        UnsortedNodeList other = (UnsortedNodeList)o;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return this.list.toString();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public static String toString(Node n) {
        if (n == null) {
            return "[null]";
        }
        NamedNodeMap attributes = n.getAttributes();
        String s = attributes == null ? "" : AttrList.create(attributes).toString();
        return "Node[name=" + n.getNodeName() + ", value=" + n.getNodeValue() + ", attr=" + s + "]";
    }

    public int size() {
        return this.length;
    }
}

