/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;

public class ZipUTF8WriterMock
implements Appendable {
    private final Map<String, StringBuilder> builderByEntryName;
    private StringBuilder curBuilder;

    public static ZipUTF8WriterMock createMock() {
        return new ZipUTF8WriterMock(new HashMap<String, StringBuilder>());
    }

    ZipUTF8WriterMock(Map<String, StringBuilder> builderByEntryName) {
        this.builderByEntryName = builderByEntryName;
        this.curBuilder = null;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.curBuilder == null) {
            throw new IOException();
        }
        this.curBuilder.append(c);
        return this;
    }

    @Override
    public Appendable append(CharSequence arg0) throws IOException {
        if (this.curBuilder == null) {
            throw new IOException();
        }
        return this.curBuilder.append(arg0);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (this.curBuilder == null) {
            throw new IOException();
        }
        return this.curBuilder.append(csq, start, end);
    }

    public void close() throws IOException {
        if (this.curBuilder != null) {
            throw new IOException();
        }
    }

    public void closeEntry() throws IOException {
        if (this.curBuilder == null) {
            throw new IOException();
        }
        this.curBuilder = null;
    }

    public void finish() {
        this.curBuilder = null;
    }

    public void flush() {
    }

    public void putNextEntry(ZipEntry arg0) {
        this.curBuilder = new StringBuilder();
        this.builderByEntryName.put(arg0.getName(), this.curBuilder);
    }

    public void setComment(String comment) {
        throw new RuntimeException();
    }

    public void write(String str) throws IOException {
        if (this.curBuilder == null) {
            throw new IOException();
        }
        this.curBuilder.append(str);
    }

    public StringBuilder getBuilder(String name) {
        return this.builderByEntryName.get(name);
    }
}

